/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.editors.tabs.operations;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class DialogCellLayout
extends Layout {
    private Control contents;
    private Button selButton;
    private Button delButton;

    public DialogCellLayout(Control contents, Button selectionButton, Button deleteButton) {
        this.selButton = selectionButton;
        this.delButton = deleteButton;
        this.contents = contents;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean force) {
        if (wHint != -1 && hHint != -1) {
            return new Point(wHint, hHint);
        }
        Point contentsSize = this.contents.computeSize(-1, -1, force);
        Point buttonSize = this.selButton.computeSize(-1, -1, force);
        Point result = new Point(buttonSize.x, Math.max(contentsSize.y, buttonSize.y));
        return result;
    }

    protected void layout(Composite editor, boolean force) {
        Rectangle bounds = editor.getClientArea();
        Point selSize = this.selButton.computeSize(-1, -1, force);
        Point delSize = this.delButton.computeSize(-1, -1, force);
        if (this.contents != null) {
            this.contents.setBounds(bounds.x, 0, bounds.width - selSize.x - delSize.x, bounds.height);
        }
        this.selButton.setBounds(bounds.width - selSize.x, 0, selSize.x, bounds.height);
        this.delButton.setBounds(bounds.width - selSize.x - delSize.x, 0, delSize.x, bounds.height);
    }
}

