/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.local.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.palladiosimulator.edp2.dao.MetaDao;
import org.palladiosimulator.edp2.dao.exception.DataNotAccessibleException;
import org.palladiosimulator.edp2.local.LocalDirectoryRepository;
import org.palladiosimulator.edp2.local.localPackage;
import org.palladiosimulator.edp2.models.Repository.impl.RepositoryImpl;
import org.palladiosimulator.edp2.repository.local.dao.LocalDirectoryMetaDao;

public class LocalDirectoryRepositoryImpl
extends RepositoryImpl
implements LocalDirectoryRepository {
    protected static final String URI_EDEFAULT = null;
    protected String uri = URI_EDEFAULT;

    protected LocalDirectoryRepositoryImpl() {
        LocalDirectoryMetaDao delegate = new LocalDirectoryMetaDao();
        delegate.setParent((MetaDao)this);
        this.metaDao = delegate;
    }

    protected EClass eStaticClass() {
        return localPackage.Literals.LOCAL_DIRECTORY_REPOSITORY;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public void setUri(String newUri) {
        String oldUri = this.uri;
        this.uri = newUri;
        this.setId(newUri);
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldUri, (Object)this.uri));
        }
    }

    @Override
    public File convertUriStringToFile(String uriString) throws DataNotAccessibleException {
        return this.convertUriStringToFileInternal(uriString);
    }

    private File convertUriStringToFileInternal(String uriString) throws DataNotAccessibleException {
        String fileLocation;
        URI uri = URI.createURI((String)uriString);
        if (uri.isPlatform()) {
            URL urlToFoo = null;
            try {
                urlToFoo = FileLocator.toFileURL((URL)new URL(uri.toString()));
                fileLocation = urlToFoo.getFile();
            }
            catch (MalformedURLException e) {
                throw new DataNotAccessibleException("The URI is not well-formed.", (Throwable)e);
            }
            catch (IOException e) {
                throw new DataNotAccessibleException("The URI could not be converted.", (Throwable)e);
            }
        } else {
            fileLocation = uri.toFileString();
        }
        if (fileLocation == null) {
            throw new DataNotAccessibleException("The URI could not be converted to a local file.", null);
        }
        File directory = new File(fileLocation);
        if (!directory.isDirectory()) {
            throw new DataNotAccessibleException("The URI does not point to a directory.", null);
        }
        return directory;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 5: {
                return this.getUri();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 5: {
                this.setUri((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 5: {
                this.setUri(URI_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 5: {
                return URI_EDEFAULT == null ? this.uri != null : !URI_EDEFAULT.equals(this.uri);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (uri: ");
        result.append(this.uri);
        result.append(')');
        return result.toString();
    }
}

