/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.ui.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.palladiosimulator.edp2.EDP2Plugin;
import org.palladiosimulator.edp2.dao.exception.DataNotAccessibleException;
import org.palladiosimulator.edp2.models.Repository.Repository;
import org.palladiosimulator.edp2.ui.EDP2UIPlugin;
import org.palladiosimulator.edp2.util.MeasurementsUtility;

public class CloseDataSourceHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof TreeSelection) {
            TreeSelection treeSelection = (TreeSelection)selection;
            if (treeSelection.getFirstElement() instanceof Repository) {
                Repository repo = (Repository)treeSelection.getFirstElement();
                try {
                    MeasurementsUtility.ensureClosedRepository((Repository)repo);
                    EDP2Plugin.INSTANCE.getRepositories().getAvailableRepositories().remove((Object)repo);
                }
                catch (DataNotAccessibleException dataNotAccessibleException) {}
            } else {
                Shell shell = EDP2UIPlugin.INSTANCE.getWorkbench().getActiveWorkbenchWindow().getShell();
                ErrorDialog.openError((Shell)shell, (String)"Select Repository", (String)"Closing an EDP2 datasource failed.", (IStatus)new Status(4, "org.palladiosimulator.edp2.ui", "You need to select a EDP2 Repository to execute the close command"));
            }
        }
        return null;
    }
}

