/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentautomation.application.tooladapter.simucom;

import de.uka.ipd.sdq.codegen.simucontroller.runconfig.AbstractSimulationWorkflowConfiguration;
import de.uka.ipd.sdq.codegen.simucontroller.runconfig.SimuComWorkflowConfiguration;
import de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs.SimuComJob;
import de.uka.ipd.sdq.simucomframework.SimuComConfig;
import de.uka.ipd.sdq.simulation.AbstractSimulationConfig;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.palladiosimulator.experimentautomation.abstractsimulation.AbstractSimulationConfiguration;
import org.palladiosimulator.experimentautomation.application.VariationFactorTuple;
import org.palladiosimulator.experimentautomation.application.jobs.CheckForSLOViolationsJob;
import org.palladiosimulator.experimentautomation.application.jobs.LogExperimentInformationJob;
import org.palladiosimulator.experimentautomation.application.tooladapter.IToolAdapter;
import org.palladiosimulator.experimentautomation.application.tooladapter.RunAnalysisJob;
import org.palladiosimulator.experimentautomation.application.tooladapter.abstractsimulation.AbstractSimulationConfigFactory;
import org.palladiosimulator.experimentautomation.application.tooladapter.abstractsimulation.AbstractSimulationWorkflowConfigurationFactory;
import org.palladiosimulator.experimentautomation.application.tooladapter.simucom.model.SimuComConfiguration;
import org.palladiosimulator.experimentautomation.application.tooladapter.simucom.model.SimucomtooladapterPackage;
import org.palladiosimulator.experimentautomation.experiments.Experiment;
import org.palladiosimulator.experimentautomation.experiments.ToolConfiguration;

public class SimuComToolAdapter
implements IToolAdapter {
    private static final String SIMULATOR_ID_SIMUCOM = "de.uka.ipd.sdq.codegen.simucontroller.simucom";
    private static final Logger LOGGER = Logger.getLogger(SimuComToolAdapter.class);

    public RunAnalysisJob createRunAnalysisJob(Experiment experiment, ToolConfiguration toolConfig, List<VariationFactorTuple> variationFactorTuples, int repetition) {
        SimuComConfiguration simuComToolConfig = (SimuComConfiguration)toolConfig;
        Map configMap = AbstractSimulationConfigFactory.createConfigMap((Experiment)experiment, (AbstractSimulationConfiguration)simuComToolConfig, (String)SIMULATOR_ID_SIMUCOM, variationFactorTuples);
        SimuComConfig simuComConfig = this.createSimuComConfig(configMap);
        SimuComWorkflowConfiguration workflowConfig = this.createSimuComWorkflowConfiguration(simuComConfig);
        RunAnalysisJob result = new RunAnalysisJob();
        result.setConfiguration(configMap);
        try {
            result.add((IJob)new LogExperimentInformationJob(experiment, (AbstractSimulationConfig)simuComConfig, variationFactorTuples, repetition));
            result.add((IJob)new SimuComJob(workflowConfig, null, false));
            result.addJob((IJob)new CheckForSLOViolationsJob(result, experiment.getInitialModel().getServiceLevelObjectives(), simuComToolConfig.getDatasource(), simuComConfig.getNameBase(), simuComConfig.getVariationId()));
        }
        catch (CoreException e) {
            LOGGER.error((Object)("SimuCom execution failed: " + (Object)((Object)e)));
        }
        return result;
    }

    public boolean hasSupportFor(ToolConfiguration configuration) {
        return SimucomtooladapterPackage.eINSTANCE.getSimuComConfiguration().isInstance((Object)configuration);
    }

    private SimuComConfig createSimuComConfig(Map<String, Object> configMap) {
        configMap.put("simulateLinkingResources", false);
        configMap.put("simulateFailures", false);
        return new SimuComConfig(configMap, false);
    }

    private SimuComWorkflowConfiguration createSimuComWorkflowConfiguration(SimuComConfig simuComConfig) {
        SimuComWorkflowConfiguration workflowConfig = new SimuComWorkflowConfiguration(new HashMap());
        AbstractSimulationWorkflowConfigurationFactory.fillWorkflowConfiguration((AbstractSimulationWorkflowConfiguration)workflowConfig);
        workflowConfig.setSimuComConfiguration(simuComConfig);
        return workflowConfig;
    }
}

