/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentautomation.application.jobs;

import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.palladiosimulator.edp2.dao.exception.DataNotAccessibleException;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.datastream.IDataStream;
import org.palladiosimulator.edp2.datastream.edp2source.Edp2DataTupleDataSource;
import org.palladiosimulator.edp2.impl.RepositoryManager;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentGroup;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentRun;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentSetting;
import org.palladiosimulator.edp2.models.ExperimentData.Measurement;
import org.palladiosimulator.edp2.models.ExperimentData.MeasurementRange;
import org.palladiosimulator.edp2.models.ExperimentData.RawMeasurements;
import org.palladiosimulator.edp2.models.Repository.Repository;
import org.palladiosimulator.edp2.util.MeasurementsUtility;
import org.palladiosimulator.experimentautomation.abstractsimulation.EDP2Datasource;
import org.palladiosimulator.experimentautomation.application.tooladapter.RunAnalysisJob;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.servicelevelobjective.ServiceLevelObjective;
import org.palladiosimulator.servicelevelobjective.ServiceLevelObjectiveRepository;
import org.palladiosimulator.servicelevelobjective.edp2.filters.SLOViolationEDP2DatasourceFilter;

public class CheckForSLOViolationsJob
extends SequentialBlackboardInteractingJob<MDSDBlackboard> {
    private final RunAnalysisJob runAnalysisJob;
    private final ServiceLevelObjectiveRepository serviceLevelObjectives;
    private final ExperimentSetting experimentSetting;

    public CheckForSLOViolationsJob(RunAnalysisJob runAnalysisJob, ServiceLevelObjectiveRepository serviceLevelObjectives, EDP2Datasource edp2datasource, String experimentGroupPurpose, String experimentSettingDescription) {
        this.runAnalysisJob = runAnalysisJob;
        this.serviceLevelObjectives = serviceLevelObjectives;
        Repository repository = this.getEDP2Repository(edp2datasource.getId());
        ExperimentGroup experimentGroup = this.getExperimentGroup(repository, experimentGroupPurpose);
        this.experimentSetting = this.getExperimentSetting(experimentGroup, experimentSettingDescription);
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        long sloViolations = this.computeSloViolations();
        if (sloViolations > 0L) {
            this.runAnalysisJob.setSloWasViolated();
        }
    }

    private long computeSloViolations() {
        int lastExperiment = this.experimentSetting.getExperimentRuns().size() - 1;
        ExperimentRun experimentRun = (ExperimentRun)this.experimentSetting.getExperimentRuns().get(lastExperiment);
        long sloViolations = 0L;
        for (ServiceLevelObjective serviceLevelObjective : this.serviceLevelObjectives.getServicelevelobjectives()) {
            Measurement measurement = this.findMeasurement((List<Measurement>)experimentRun.getMeasurement(), serviceLevelObjective);
            RawMeasurements rawMeasurements = ((MeasurementRange)measurement.getMeasurementRanges().get(0)).getRawMeasurements();
            HashMap<String, ServiceLevelObjective> properties = new HashMap<String, ServiceLevelObjective>(1);
            properties.put("serviceLevelObjective", serviceLevelObjective);
            Edp2DataTupleDataSource dataSource = new Edp2DataTupleDataSource(rawMeasurements);
            SLOViolationEDP2DatasourceFilter sloFilter = new SLOViolationEDP2DatasourceFilter((IDataSource)dataSource);
            sloFilter.setProperties(properties);
            IDataStream dataStream = sloFilter.getDataStream();
            sloViolations += (long)dataStream.size();
            dataStream.close();
        }
        return sloViolations;
    }

    private Measurement findMeasurement(List<Measurement> measurementList, ServiceLevelObjective serviceLevelObjective) {
        for (Measurement measurement : measurementList) {
            String sloMeasuringPoint;
            String measureMeasuringPoint;
            if (!this.containsMetric(measurement.getMeasuringType().getMetric(), serviceLevelObjective.getMeasurementSpecification().getMetricDescription()) || !(measureMeasuringPoint = measurement.getMeasuringType().getMeasuringPoint().getStringRepresentation()).equals(sloMeasuringPoint = serviceLevelObjective.getMeasurementSpecification().getMonitor().getMeasuringPoint().getStringRepresentation())) continue;
            return measurement;
        }
        throw new RuntimeException("Measurement for SLO \"" + serviceLevelObjective.getName() + "\" not found. MeasurementList has " + measurementList.size() + " elements.");
    }

    private boolean containsMetric(MetricDescription metric, MetricDescription metricToCheckFor) {
        if (metric == metricToCheckFor || metric.getId().equals(metricToCheckFor.getId())) {
            return true;
        }
        if (metric instanceof MetricSetDescription) {
            for (MetricDescription subMetric : ((MetricSetDescription)metric).getSubsumedMetrics()) {
                if (!this.containsMetric(subMetric, metricToCheckFor)) continue;
                return true;
            }
        }
        return false;
    }

    private ExperimentGroup getExperimentGroup(Repository repository, String purpose) {
        for (ExperimentGroup experimentGroup : repository.getExperimentGroups()) {
            if (!experimentGroup.getPurpose().equals(purpose)) continue;
            return experimentGroup;
        }
        throw new IllegalArgumentException("Could not find experiment group with purpose \"" + purpose + "\"");
    }

    private ExperimentSetting getExperimentSetting(ExperimentGroup experimentGroup, String experimentSettingDescription) {
        for (ExperimentSetting expSetting : experimentGroup.getExperimentSettings()) {
            if (!expSetting.getDescription().equals(experimentSettingDescription)) continue;
            return expSetting;
        }
        throw new IllegalArgumentException("Could not find experiment setting for variation \"" + experimentSettingDescription + "\"");
    }

    private Repository getEDP2Repository(String edp2datasourceID) {
        Repository repository = RepositoryManager.getRepositoryFromUUID((String)edp2datasourceID);
        if (repository == null) {
            throw new RuntimeException("Could not determine datasource type. This should not have happened.");
        }
        try {
            MeasurementsUtility.ensureOpenRepository((Repository)repository);
        }
        catch (DataNotAccessibleException e) {
            throw new RuntimeException("Could not open EDP2 repository");
        }
        return repository;
    }
}

