/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentautomation.application.jobs;

import de.uka.ipd.sdq.codegen.simucontroller.debug.IDebugListener;
import de.uka.ipd.sdq.workflow.extension.AbstractExtendableJob;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.analyzer.workflow.jobs.PreparePCMBlackboardPartitionJob;
import org.palladiosimulator.experimentautomation.application.config.ExperimentAutomationConfiguration;
import org.palladiosimulator.experimentautomation.application.jobs.CopyPartitionJob;
import org.palladiosimulator.experimentautomation.application.jobs.LoadModelsIntoBlackboardJob;
import org.palladiosimulator.experimentautomation.application.jobs.ModifyModelsJob;
import org.palladiosimulator.experimentautomation.application.jobs.PrepareBlackboardJob;
import org.palladiosimulator.experimentautomation.application.jobs.RunExperimentForEachToolJob;
import org.palladiosimulator.experimentautomation.experiments.Experiment;
import org.palladiosimulator.experimentautomation.experiments.Modification;

public class RunExperimentAutomationJob
extends AbstractExtendableJob<MDSDBlackboard> {
    public static String WORKFLOW_ID_BEFORE_EXPERIMENT_RUN = "workflow.extension.experimentautomation.before.experimentrun";

    public RunExperimentAutomationJob(ExperimentAutomationConfiguration configuration) {
        this(configuration, null);
    }

    public RunExperimentAutomationJob(ExperimentAutomationConfiguration configuration, IDebugListener listener) {
        super(false);
        if (listener == null && configuration.isDebug()) {
            throw new IllegalArgumentException("Debug listener has to be non-null for debug runs");
        }
        this.add((IJob)new PreparePCMBlackboardPartitionJob());
        for (Experiment experiment : configuration.getExperiments()) {
            this.add((IJob)new PrepareBlackboardJob());
            this.add((IJob)new LoadModelsIntoBlackboardJob(experiment.getInitialModel()));
            this.add((IJob)new ModifyModelsJob((EList<Modification>)experiment.getModifications()));
            this.handleJobExtensions(WORKFLOW_ID_BEFORE_EXPERIMENT_RUN, configuration);
            this.add((IJob)new CopyPartitionJob("org.palladiosimulator.pcmmodels.partition", "org.palladiosimulator.analyzed.partition"));
            this.add((IJob)new RunExperimentForEachToolJob(experiment));
        }
    }
}

