/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentautomation.application.variation.valueprovider;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.palladiosimulator.experimentautomation.application.variation.valueprovider.IValueProviderStrategy;
import org.palladiosimulator.experimentautomation.experiments.SetValueProvider;

public class SetValueProviderStrategy
implements IValueProviderStrategy<Double> {
    private final SetValueProvider specification;
    private final List<Double> values;

    public SetValueProviderStrategy(SetValueProvider specification) {
        this.specification = specification;
        this.values = SetValueProviderStrategy.parseValueString(this.specification.getValues());
    }

    @Override
    public Double valueAtPosition(int position) {
        if (position > this.values.size() - 1) {
            return -1.0;
        }
        return this.values.get(position);
    }

    private static List<Double> parseValueString(String values) {
        ArrayList<Double> result = new ArrayList<Double>();
        StringTokenizer tokens = new StringTokenizer(values, ",");
        while (tokens.hasMoreElements()) {
            String value = tokens.nextToken();
            Double d = new Double(value);
            result.add(d);
        }
        return result;
    }
}

