/**
 */
package org.palladiosimulator.metricspec.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.palladiosimulator.metricspec.util.MetricSpecAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers. The
 * adapters generated by this factory convert EMF adapter notifications into calls to
 * {@link #fireNotifyChanged fireNotifyChanged}. The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances. <!-- begin-user-doc --> <!--
 * end-user-doc -->
 *
 * @generated
 */
public class MetricSpecItemProviderAdapterFactory extends MetricSpecAdapterFactory implements
        ComposeableAdapterFactory, IChangeNotifier, IDisposable {

    /**
     * This keeps track of the root adapter factory that delegates to this adapter factory. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ComposedAdapterFactory parentAdapterFactory;

    /**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected IChangeNotifier changeNotifier = new ChangeNotifier();

    /**
     * This keeps track of all the supported types checked by {@link #isFactoryForType
     * isFactoryForType}. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected Collection<Object> supportedTypes = new ArrayList<Object>();

    /**
     * This constructs an instance. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    public MetricSpecItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.metricspec.Identifier} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    protected IdentifierItemProvider identifierItemProvider;

    /**
     * This creates an adapter for a {@link org.palladiosimulator.metricspec.Identifier}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createIdentifierAdapter() {
        if (this.identifierItemProvider == null) {
            this.identifierItemProvider = new IdentifierItemProvider(this);
        }

        return this.identifierItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.metricspec.TextualBaseMetricDescription} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected TextualBaseMetricDescriptionItemProvider textualBaseMetricDescriptionItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.metricspec.TextualBaseMetricDescription}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createTextualBaseMetricDescriptionAdapter() {
        if (this.textualBaseMetricDescriptionItemProvider == null) {
            this.textualBaseMetricDescriptionItemProvider = new TextualBaseMetricDescriptionItemProvider(this);
        }

        return this.textualBaseMetricDescriptionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.metricspec.AggregationFunctionDescription} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected AggregationFunctionDescriptionItemProvider aggregationFunctionDescriptionItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.metricspec.AggregationFunctionDescription}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createAggregationFunctionDescriptionAdapter() {
        if (this.aggregationFunctionDescriptionItemProvider == null) {
            this.aggregationFunctionDescriptionItemProvider = new AggregationFunctionDescriptionItemProvider(this);
        }

        return this.aggregationFunctionDescriptionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.metricspec.MetricSetDescription} instances. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected MetricSetDescriptionItemProvider metricSetDescriptionItemProvider;

    /**
     * This creates an adapter for a {@link org.palladiosimulator.metricspec.MetricSetDescription}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createMetricSetDescriptionAdapter() {
        if (this.metricSetDescriptionItemProvider == null) {
            this.metricSetDescriptionItemProvider = new MetricSetDescriptionItemProvider(this);
        }

        return this.metricSetDescriptionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.metricspec.NumericalBaseMetricDescription} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected NumericalBaseMetricDescriptionItemProvider numericalBaseMetricDescriptionItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.metricspec.NumericalBaseMetricDescription}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createNumericalBaseMetricDescriptionAdapter() {
        if (this.numericalBaseMetricDescriptionItemProvider == null) {
            this.numericalBaseMetricDescriptionItemProvider = new NumericalBaseMetricDescriptionItemProvider(this);
        }

        return this.numericalBaseMetricDescriptionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.metricspec.MetricDescriptionRepository} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected MetricDescriptionRepositoryItemProvider metricDescriptionRepositoryItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.metricspec.MetricDescriptionRepository}. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createMetricDescriptionRepositoryAdapter() {
        if (this.metricDescriptionRepositoryItemProvider == null) {
            this.metricDescriptionRepositoryItemProvider = new MetricDescriptionRepositoryItemProvider(this);
        }

        return this.metricDescriptionRepositoryItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    /**
     * This sets the composed adapter factory that contains this factory. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void setParentAdapterFactory(final ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public boolean isFactoryForType(final Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    /**
     * This implementation substitutes the factory itself as the key for the adapter. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter adapt(final Notifier notifier, final Object type) {
        return super.adapt(notifier, this);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Object adapt(final Object object, final Object type) {
        if (this.isFactoryForType(type)) {
            final Object adapter = super.adapt(object, type);
            if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter))) {
                return adapter;
            }
        }

        return null;
    }

    /**
     * This adds a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void addListener(final INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    /**
     * This removes a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void removeListener(final INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    /**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void fireNotifyChanged(final Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);

        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    /**
     * This disposes all of the item providers created by this factory. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    @Override
    public void dispose() {
        if (this.identifierItemProvider != null) {
            this.identifierItemProvider.dispose();
        }
        if (this.textualBaseMetricDescriptionItemProvider != null) {
            this.textualBaseMetricDescriptionItemProvider.dispose();
        }
        if (this.aggregationFunctionDescriptionItemProvider != null) {
            this.aggregationFunctionDescriptionItemProvider.dispose();
        }
        if (this.metricSetDescriptionItemProvider != null) {
            this.metricSetDescriptionItemProvider.dispose();
        }
        if (this.numericalBaseMetricDescriptionItemProvider != null) {
            this.numericalBaseMetricDescriptionItemProvider.dispose();
        }
        if (this.metricDescriptionRepositoryItemProvider != null) {
            this.metricDescriptionRepositoryItemProvider.dispose();
        }
    }

}
