/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.metricspec;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CaptureType implements Enumerator
{
    IDENTIFIER(0, "Identifier", "Identifier"),
    INTEGER_NUMBER(1, "IntegerNumber", "IntegerNumber"),
    REAL_NUMBER(2, "RealNumber", "RealNumber");

    public static final int IDENTIFIER_VALUE = 0;
    public static final int INTEGER_NUMBER_VALUE = 1;
    public static final int REAL_NUMBER_VALUE = 2;
    private static final CaptureType[] VALUES_ARRAY;
    public static final List<CaptureType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CaptureType[]{IDENTIFIER, INTEGER_NUMBER, REAL_NUMBER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CaptureType get(String literal) {
        CaptureType[] captureTypeArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            CaptureType result = captureTypeArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static CaptureType getByName(String name) {
        CaptureType[] captureTypeArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            CaptureType result = captureTypeArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static CaptureType get(int value) {
        switch (value) {
            case 0: {
                return IDENTIFIER;
            }
            case 1: {
                return INTEGER_NUMBER;
            }
            case 2: {
                return REAL_NUMBER;
            }
        }
        return null;
    }

    private CaptureType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

