/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.metricspec;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Scale implements Enumerator
{
    NOMINAL(0, "Nominal", "Nominal"),
    ORDINAL(1, "Ordinal", "Ordinal"),
    INTERVAL(2, "Interval", "Interval"),
    RATIO(3, "Ratio", "Ratio");

    public static final int NOMINAL_VALUE = 0;
    public static final int ORDINAL_VALUE = 1;
    public static final int INTERVAL_VALUE = 2;
    public static final int RATIO_VALUE = 3;
    private static final Scale[] VALUES_ARRAY;
    public static final List<Scale> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Scale[]{NOMINAL, ORDINAL, INTERVAL, RATIO};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Scale get(String literal) {
        Scale[] scaleArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            Scale result = scaleArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static Scale getByName(String name) {
        Scale[] scaleArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            Scale result = scaleArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static Scale get(int value) {
        switch (value) {
            case 0: {
                return NOMINAL;
            }
            case 1: {
                return ORDINAL;
            }
            case 2: {
                return INTERVAL;
            }
            case 3: {
                return RATIO;
            }
        }
        return null;
    }

    private Scale(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

