/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.monitorrepository;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum StatisticalCharacterizationEnum implements Enumerator
{
    NONE(0, "None", "None"),
    MEDIAN(1, "Median", "Median"),
    ARITHMETIC_MEAN(2, "ArithmeticMean", "ArithmeticMean"),
    GEOMETRIC_MEAN(3, "GeometricMean", "GeometricMean"),
    HARMONIC_MEAN(4, "HarmonicMean", "HarmonicMean");

    public static final int NONE_VALUE = 0;
    public static final int MEDIAN_VALUE = 1;
    public static final int ARITHMETIC_MEAN_VALUE = 2;
    public static final int GEOMETRIC_MEAN_VALUE = 3;
    public static final int HARMONIC_MEAN_VALUE = 4;
    private static final StatisticalCharacterizationEnum[] VALUES_ARRAY;
    public static final List<StatisticalCharacterizationEnum> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new StatisticalCharacterizationEnum[]{NONE, MEDIAN, ARITHMETIC_MEAN, GEOMETRIC_MEAN, HARMONIC_MEAN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static StatisticalCharacterizationEnum get(String literal) {
        StatisticalCharacterizationEnum[] statisticalCharacterizationEnumArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            StatisticalCharacterizationEnum result = statisticalCharacterizationEnumArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static StatisticalCharacterizationEnum getByName(String name) {
        StatisticalCharacterizationEnum[] statisticalCharacterizationEnumArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            StatisticalCharacterizationEnum result = statisticalCharacterizationEnumArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static StatisticalCharacterizationEnum get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return MEDIAN;
            }
            case 2: {
                return ARITHMETIC_MEAN;
            }
            case 3: {
                return GEOMETRIC_MEAN;
            }
            case 4: {
                return HARMONIC_MEAN;
            }
        }
        return null;
    }

    private StatisticalCharacterizationEnum(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

