/**
 * Copyright 2005-2009 by SDQ, IPD, University of Karlsruhe, Germany
 */
package org.palladiosimulator.pcm.subsystem.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.composition.ComposedStructure;
import org.palladiosimulator.pcm.core.entity.ComposedProvidingRequiringEntity;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.core.entity.InterfaceProvidingEntity;
import org.palladiosimulator.pcm.core.entity.InterfaceProvidingRequiringEntity;
import org.palladiosimulator.pcm.core.entity.InterfaceRequiringEntity;
import org.palladiosimulator.pcm.core.entity.NamedElement;
import org.palladiosimulator.pcm.core.entity.ResourceInterfaceRequiringEntity;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.subsystem.SubSystem;
import org.palladiosimulator.pcm.subsystem.SubsystemPackage;

import de.uka.ipd.sdq.identifier.Identifier;

/**
 * <!-- begin-user-doc --> The <b>Adapter Factory</b> for the model. It provides an adapter
 * <code>createXXX</code> method for each class of the model. <!-- end-user-doc -->
 *
 * @see org.palladiosimulator.pcm.subsystem.SubsystemPackage
 * @generated
 */
public class SubsystemAdapterFactory extends AdapterFactoryImpl {

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    public static final String copyright = "Copyright 2005-2015 by palladiosimulator.org";

    /**
     * The cached model package. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected static SubsystemPackage modelPackage;

    /**
     * Creates an instance of the adapter factory. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    public SubsystemAdapterFactory() {
        if (modelPackage == null)
        {
            modelPackage = SubsystemPackage.eINSTANCE;
        }
    }

    /**
     * Returns whether this factory is applicable for the type of the object. <!-- begin-user-doc
     * --> This implementation returns <code>true</code> if the object is either the model's package
     * or is an instance object of the model. <!-- end-user-doc -->
     *
     * @return whether this factory is applicable for the type of the object.
     * @generated
     */
    @Override
    public boolean isFactoryForType(final Object object) {
        if (object == modelPackage)
        {
            return true;
        }
        if (object instanceof EObject)
        {
            return ((EObject) object).eClass().getEPackage() == modelPackage;
        }
        return false;
    }

    /**
     * The switch that delegates to the <code>createXXX</code> methods. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    protected SubsystemSwitch<Adapter> modelSwitch = new SubsystemSwitch<Adapter>()
    {
        @Override
        public Adapter caseSubSystem(final SubSystem object)
        {
            return SubsystemAdapterFactory.this.createSubSystemAdapter();
        }

        @Override
        public Adapter caseIdentifier(final Identifier object)
        {
            return SubsystemAdapterFactory.this.createIdentifierAdapter();
        }

        @Override
        public Adapter caseNamedElement(final NamedElement object)
        {
            return SubsystemAdapterFactory.this.createNamedElementAdapter();
        }

        @Override
        public Adapter caseEntity(final Entity object)
        {
            return SubsystemAdapterFactory.this.createEntityAdapter();
        }

        @Override
        public Adapter caseComposedStructure(final ComposedStructure object)
        {
            return SubsystemAdapterFactory.this.createComposedStructureAdapter();
        }

        @Override
        public Adapter caseInterfaceProvidingEntity(final InterfaceProvidingEntity object)
        {
            return SubsystemAdapterFactory.this.createInterfaceProvidingEntityAdapter();
        }

        @Override
        public Adapter caseResourceInterfaceRequiringEntity(final ResourceInterfaceRequiringEntity object)
        {
            return SubsystemAdapterFactory.this.createResourceInterfaceRequiringEntityAdapter();
        }

        @Override
        public Adapter caseInterfaceRequiringEntity(final InterfaceRequiringEntity object)
        {
            return SubsystemAdapterFactory.this.createInterfaceRequiringEntityAdapter();
        }

        @Override
        public Adapter caseInterfaceProvidingRequiringEntity(final InterfaceProvidingRequiringEntity object)
        {
            return SubsystemAdapterFactory.this.createInterfaceProvidingRequiringEntityAdapter();
        }

        @Override
        public Adapter caseComposedProvidingRequiringEntity(final ComposedProvidingRequiringEntity object)
        {
            return SubsystemAdapterFactory.this.createComposedProvidingRequiringEntityAdapter();
        }

        @Override
        public Adapter caseRepositoryComponent(final RepositoryComponent object)
        {
            return SubsystemAdapterFactory.this.createRepositoryComponentAdapter();
        }

        @Override
        public Adapter defaultCase(final EObject object)
        {
            return SubsystemAdapterFactory.this.createEObjectAdapter();
        }
    };

    /**
     * Creates an adapter for the <code>target</code>. <!-- begin-user-doc --> <!-- end-user-doc -->
             *
             * @param target
             *            the object to adapt.
             * @return the adapter for the <code>target</code>.
     * @generated
     */
    @Override
    public Adapter createAdapter(final Notifier target) {
        return this.modelSwitch.doSwitch((EObject) target);
    }

    /**
     * Creates a new adapter for an object of class '
     * {@link org.palladiosimulator.pcm.subsystem.SubSystem <em>Sub System</em>}'. <!--
     * begin-user-doc --> This default implementation returns null so that we can easily ignore
     * cases; it's useful to ignore a case when inheritance will catch all the cases anyway. <!--
     * end-user-doc -->
     *
     * @return the new adapter.
     * @see org.palladiosimulator.pcm.subsystem.SubSystem
     * @generated
     */
    public Adapter createSubSystemAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link de.uka.ipd.sdq.identifier.Identifier
             * <em>Identifier</em>}'. <!-- begin-user-doc --> This default implementation returns null so
             * that we can easily ignore cases; it's useful to ignore a case when inheritance will catch all
             * the cases anyway. <!-- end-user-doc -->
             *
             * @return the new adapter.
     * @see de.uka.ipd.sdq.identifier.Identifier
     * @generated
     */
    public Adapter createIdentifierAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '
     * {@link org.palladiosimulator.pcm.core.entity.NamedElement <em>Named Element</em>}'. <!--
     * begin-user-doc --> This default implementation returns null so that we can easily ignore
     * cases; it's useful to ignore a case when inheritance will catch all the cases anyway. <!--
     * end-user-doc -->
     *
     * @return the new adapter.
     * @see org.palladiosimulator.pcm.core.entity.NamedElement
     * @generated
     */
    public Adapter createNamedElementAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '
             * {@link org.palladiosimulator.pcm.core.entity.Entity <em>Entity</em>}'. <!-- begin-user-doc
             * --> This default implementation returns null so that we can easily ignore cases; it's useful
             * to ignore a case when inheritance will catch all the cases anyway. <!-- end-user-doc -->
             *
             * @return the new adapter.
     * @see org.palladiosimulator.pcm.core.entity.Entity
     * @generated
     */
    public Adapter createEntityAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '
             * {@link org.palladiosimulator.pcm.core.composition.ComposedStructure
             * <em>Composed Structure</em>}'. <!-- begin-user-doc --> This default implementation returns
             * null so that we can easily ignore cases; it's useful to ignore a case when inheritance will
             * catch all the cases anyway. <!-- end-user-doc -->
             *
             * @return the new adapter.
     * @see org.palladiosimulator.pcm.core.composition.ComposedStructure
     * @generated
     */
    public Adapter createComposedStructureAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '
             * {@link org.palladiosimulator.pcm.core.entity.InterfaceProvidingEntity
             * <em>Interface Providing Entity</em>}'. <!-- begin-user-doc --> This default implementation
             * returns null so that we can easily ignore cases; it's useful to ignore a case when
             * inheritance will catch all the cases anyway. <!-- end-user-doc -->
             *
             * @return the new adapter.
     * @see org.palladiosimulator.pcm.core.entity.InterfaceProvidingEntity
     * @generated
     */
    public Adapter createInterfaceProvidingEntityAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '
             * {@link org.palladiosimulator.pcm.core.entity.ResourceInterfaceRequiringEntity
             * <em>Resource Interface Requiring Entity</em>}'. <!-- begin-user-doc --> This default
             * implementation returns null so that we can easily ignore cases; it's useful to ignore a case
             * when inheritance will catch all the cases anyway. <!-- end-user-doc -->
             *
             * @return the new adapter.
     * @see org.palladiosimulator.pcm.core.entity.ResourceInterfaceRequiringEntity
     * @generated
     */
    public Adapter createResourceInterfaceRequiringEntityAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '
             * {@link org.palladiosimulator.pcm.core.entity.InterfaceRequiringEntity
             * <em>Interface Requiring Entity</em>}'. <!-- begin-user-doc --> This default implementation
             * returns null so that we can easily ignore cases; it's useful to ignore a case when
             * inheritance will catch all the cases anyway. <!-- end-user-doc -->
             *
             * @return the new adapter.
     * @see org.palladiosimulator.pcm.core.entity.InterfaceRequiringEntity
     * @generated
     */
    public Adapter createInterfaceRequiringEntityAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '
             * {@link org.palladiosimulator.pcm.core.entity.InterfaceProvidingRequiringEntity
             * <em>Interface Providing Requiring Entity</em>}'. <!-- begin-user-doc --> This default
             * implementation returns null so that we can easily ignore cases; it's useful to ignore a case
             * when inheritance will catch all the cases anyway. <!-- end-user-doc -->
             *
             * @return the new adapter.
     * @see org.palladiosimulator.pcm.core.entity.InterfaceProvidingRequiringEntity
     * @generated
     */
    public Adapter createInterfaceProvidingRequiringEntityAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '
             * {@link org.palladiosimulator.pcm.core.entity.ComposedProvidingRequiringEntity
             * <em>Composed Providing Requiring Entity</em>}'. <!-- begin-user-doc --> This default
             * implementation returns null so that we can easily ignore cases; it's useful to ignore a case
             * when inheritance will catch all the cases anyway. <!-- end-user-doc -->
             *
             * @return the new adapter.
     * @see org.palladiosimulator.pcm.core.entity.ComposedProvidingRequiringEntity
     * @generated
     */
    public Adapter createComposedProvidingRequiringEntityAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '
     * {@link org.palladiosimulator.pcm.repository.RepositoryComponent <em>Component</em>}'. <!--
     * begin-user-doc --> This default implementation returns null so that we can easily ignore
     * cases; it's useful to ignore a case when inheritance will catch all the cases anyway. <!--
     * end-user-doc -->
     *
     * @return the new adapter.
     * @see org.palladiosimulator.pcm.repository.RepositoryComponent
     * @generated
     */
    public Adapter createRepositoryComponentAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for the default case. <!-- begin-user-doc --> This default
             * implementation returns null. <!-- end-user-doc -->
             *
             * @return the new adapter.
     * @generated
     */
    public Adapter createEObjectAdapter() {
        return null;
    }

} // SubsystemAdapterFactory
