/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.pcm.ui.wizard;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.palladiosimulator.pcm.ui.wizard.ExtensionHelper;
import org.palladiosimulator.pcm.ui.wizard.NewPalladioTemplateWizardPage;
import org.palladiosimulator.pcm.ui.wizard.PalladioTemplate;

public class NewPalladioProjectWizard
extends Wizard
implements INewWizard {
    private WizardNewProjectCreationPage projectInfoPage;
    private NewPalladioTemplateWizardPage palladioTemplatePage;
    private IProject project;
    private IConfigurationElement config;
    private IWorkbench workbench;

    public NewPalladioProjectWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.projectInfoPage = new WizardNewProjectCreationPage("NewPalladioProject");
        this.projectInfoPage.setDescription("Create a new Palladio project with a basic set of models.");
        this.projectInfoPage.setTitle("New Palladio Project");
        this.addPage((IWizardPage)this.projectInfoPage);
        Set<PalladioTemplate> availableTemplates = this.getAvailableTemplates();
        this.palladioTemplatePage = new NewPalladioTemplateWizardPage(availableTemplates);
        this.addPage((IWizardPage)this.palladioTemplatePage);
    }

    public boolean performFinish() {
        if (this.project != null) {
            return true;
        }
        final IProject projectHandle = this.projectInfoPage.getProjectHandle();
        URI projectURI = !this.projectInfoPage.useDefaults() ? this.projectInfoPage.getLocationURI() : null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription desc = workspace.newProjectDescription(projectHandle.getName());
        desc.setLocationURI(projectURI);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                NewPalladioProjectWizard.this.createProject(desc, projectHandle, monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)e.getMessage());
            return false;
        }
        this.project = projectHandle;
        if (this.project == null) {
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.config);
        BasicNewProjectResourceWizard.selectAndReveal((IResource)this.project, (IWorkbenchWindow)this.workbench.getActiveWorkbenchWindow());
        return true;
    }

    void createProject(IProjectDescription description, IProject proj, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("", 2000);
            proj.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            proj.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            IProject container = proj;
            PalladioTemplate selectedTemplate = this.palladioTemplatePage.getSelectedTemplate();
            if (selectedTemplate != null) {
                Map<String, String> uriMap = selectedTemplate.getModelFiles();
                for (String uri : uriMap.keySet()) {
                    String targetFileName = uriMap.get(uri);
                    this.addModelFile(uri, targetFileName, (IContainer)container, monitor);
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    private Set<PalladioTemplate> getAvailableTemplates() {
        ExtensionHelper helper = new ExtensionHelper();
        return helper.getPalladioModelTemplates();
    }

    private void addModelFile(String sourceFileURI, String targetFileName, IContainer container, IProgressMonitor monitor) throws CoreException {
        block13: {
            InputStream resourceStream = null;
            try {
                try {
                    URL url = new URL(sourceFileURI);
                    resourceStream = url.openConnection().getInputStream();
                    if (resourceStream != null) {
                        this.addFileToProject(container, new Path(targetFileName), resourceStream, monitor);
                    }
                }
                catch (IOException ioe) {
                    this.throwCoreException(ioe.getLocalizedMessage());
                    if (resourceStream == null) break block13;
                    try {
                        resourceStream.close();
                    }
                    catch (IOException e) {
                        this.throwCoreException(e.getLocalizedMessage());
                    }
                }
            }
            finally {
                if (resourceStream != null) {
                    try {
                        resourceStream.close();
                    }
                    catch (IOException e) {
                        this.throwCoreException(e.getLocalizedMessage());
                    }
                }
            }
        }
    }

    private void addFileToProject(IContainer container, Path path, InputStream contentStream, IProgressMonitor monitor) throws CoreException {
        IFile file = container.getFile((IPath)path);
        if (file.exists()) {
            file.setContents(contentStream, true, true, monitor);
        } else {
            file.create(contentStream, true, monitor);
        }
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "org.palladiosimulator.pcm.ui", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
    }
}

