/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.pcm.allocation.util;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.allocation.AllocationPackage;

public class AllocationValidator
extends EObjectValidator {
    public static final String copyright = "Copyright 2005-2015 by palladiosimulator.org";
    public static final AllocationValidator INSTANCE = new AllocationValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.palladiosimulator.pcm.allocation";
    public static final int ALLOCATION_CONTEXT__ONE_ASSEMBLY_CONTEXT_OR_ONE_EVENT_CHANNEL_SHOULD_BE_REFERRED = 1;
    public static final int ALLOCATION__EACH_ASSEMBLY_CONTEXT_WITHIN_SYSTEM_HAS_TO_BE_ALLOCATED_EXACTLY_ONCE = 2;
    public static final int ALLOCATION__COMMUNICATING_SERVERS_HAVE_TO_BE_CONNECTED_BY_LINKING_RESOURCE = 3;
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 3;
    protected static final int DIAGNOSTIC_CODE_COUNT = 3;

    protected EPackage getEPackage() {
        return AllocationPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateAllocationContext((AllocationContext)value, diagnostics, context);
            }
            case 1: {
                return this.validateAllocation((Allocation)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateAllocationContext(AllocationContext allocationContext, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)allocationContext, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)allocationContext, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)allocationContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)allocationContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)allocationContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)allocationContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)allocationContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)allocationContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAllocationContext_OneAssemblyContextOrOneEventChannelShouldBeReferred(allocationContext, diagnostics, context);
        }
        return result;
    }

    public boolean validateAllocationContext_OneAssemblyContextOrOneEventChannelShouldBeReferred(AllocationContext allocationContext, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return allocationContext.OneAssemblyContextOrOneEventChannelShouldBeReferred(diagnostics, context);
    }

    public boolean validateAllocation(Allocation allocation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)allocation, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)allocation, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)allocation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)allocation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)allocation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)allocation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)allocation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)allocation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAllocation_EachAssemblyContextWithinSystemHasToBeAllocatedExactlyOnce(allocation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAllocation_CommunicatingServersHaveToBeConnectedByLinkingResource(allocation, diagnostics, context);
        }
        return result;
    }

    public boolean validateAllocation_EachAssemblyContextWithinSystemHasToBeAllocatedExactlyOnce(Allocation allocation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return allocation.EachAssemblyContextWithinSystemHasToBeAllocatedExactlyOnce(diagnostics, context);
    }

    public boolean validateAllocation_CommunicatingServersHaveToBeConnectedByLinkingResource(Allocation allocation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return allocation.CommunicatingServersHaveToBeConnectedByLinkingResource(diagnostics, context);
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

