/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.pcm.parameter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum VariableCharacterisationType implements Enumerator
{
    STRUCTURE(0, "STRUCTURE", "STRUCTURE"),
    NUMBER_OF_ELEMENTS(1, "NUMBER_OF_ELEMENTS", "NUMBER_OF_ELEMENTS"),
    VALUE(2, "VALUE", "VALUE"),
    BYTESIZE(3, "BYTESIZE", "BYTESIZE"),
    TYPE(4, "TYPE", "TYPE");

    public static final String copyright = "Copyright 2005-2015 by palladiosimulator.org";
    public static final int STRUCTURE_VALUE = 0;
    public static final int NUMBER_OF_ELEMENTS_VALUE = 1;
    public static final int VALUE_VALUE = 2;
    public static final int BYTESIZE_VALUE = 3;
    public static final int TYPE_VALUE = 4;
    private static final VariableCharacterisationType[] VALUES_ARRAY;
    public static final List<VariableCharacterisationType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new VariableCharacterisationType[]{STRUCTURE, NUMBER_OF_ELEMENTS, VALUE, BYTESIZE, TYPE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static VariableCharacterisationType get(String literal) {
        VariableCharacterisationType[] variableCharacterisationTypeArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            VariableCharacterisationType result = variableCharacterisationTypeArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static VariableCharacterisationType getByName(String name) {
        VariableCharacterisationType[] variableCharacterisationTypeArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            VariableCharacterisationType result = variableCharacterisationTypeArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static VariableCharacterisationType get(int value) {
        switch (value) {
            case 0: {
                return STRUCTURE;
            }
            case 1: {
                return NUMBER_OF_ELEMENTS;
            }
            case 2: {
                return VALUE;
            }
            case 3: {
                return BYTESIZE;
            }
            case 4: {
                return TYPE;
            }
        }
        return null;
    }

    private VariableCharacterisationType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

