/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.ee.api.http;

import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.palladiosimulator.protocom.framework.java.ee.experiment.IExperiment;

@Path(value="/experiment")
public class Experiment {
    @Inject
    private IExperiment experiment;
    private static final ConcurrentHashMap<String, Long> START_TIMES;
    private static String scenarioName;

    static {
        scenarioName = "Scenario";
        START_TIMES = new ConcurrentHashMap();
    }

    @PUT
    @Path(value="start")
    public Response startExperiment(String name) {
        scenarioName = name;
        START_TIMES.clear();
        this.experiment.startRun();
        return Response.noContent().build();
    }

    @PUT
    @Path(value="stop")
    public Response stopExperiment() {
        this.experiment.stopRun();
        return Response.noContent().build();
    }

    @PUT
    @Path(value="iteration/start/{id}")
    public void startIteration(@PathParam(value="id") String id) {
        long time = System.nanoTime();
        START_TIMES.put(id, time);
    }

    @PUT
    @Path(value="iteration/stop/{id}")
    public void stopIteration(@PathParam(value="id") String id) {
        long now = System.nanoTime();
        this.experiment.takeMeasurement(String.valueOf(scenarioName) + " Response Time", START_TIMES.get(id), now);
        START_TIMES.remove(id);
    }
}

