/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.ee.modules;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.palladiosimulator.protocom.framework.java.ee.modules.Module;
import org.palladiosimulator.protocom.framework.java.ee.modules.ModuleStartException;
import org.palladiosimulator.protocom.framework.java.ee.protocol.RegistryException;

public class SystemModule
extends Module {
    private static final Logger LOGGER = Logger.getRootLogger();
    private final String className;

    public SystemModule(String name, String className) {
        super("0", name);
        this.className = className;
        this.setDisplayName("System: " + name);
    }

    @Override
    public void start(String location) throws ModuleStartException {
        if (this.isStarted()) {
            LOGGER.error((Object)("System '" + this.getName() + "' already started"));
            throw new ModuleStartException();
        }
        LOGGER.info((Object)("Starting system '" + this.getName() + "'"));
        try {
            Class<?> systemClass = Class.forName(this.className);
            Class[] types = new Class[]{String.class, String.class};
            Object[] arguments = new Object[]{location, this.getId()};
            Constructor<?> constructor = systemClass.getConstructor(types);
            constructor.newInstance(arguments);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RegistryException) {
                LOGGER.error((Object)"Failed to look up components in registry");
                throw new ModuleStartException();
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setStarted(true);
    }
}

