/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.ee.protocol;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.palladiosimulator.protocom.framework.java.ee.protocol.RegistryEntry;
import org.palladiosimulator.protocom.framework.java.ee.protocol.Response;
import org.palladiosimulator.protocom.framework.java.ee.protocol.StringResponse;

@WebServlet(urlPatterns={"/registry"}, loadOnStartup=0)
public class RemoteRegistry
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static HashMap<String, RegistryEntry> registeredObjects;
    private static final ObjectMapper MAPPER;

    static {
        MAPPER = new ObjectMapper();
    }

    public void init() throws ServletException {
        registeredObjects = new HashMap();
    }

    private String objectToJson(Object object) {
        String json = "";
        try {
            json = MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return json;
    }

    private Response register(String entryString) {
        StringResponse response = new StringResponse();
        RegistryEntry entry = null;
        try {
            entry = (RegistryEntry)MAPPER.readValue(entryString, RegistryEntry.class);
            if (registeredObjects.containsKey(entry.getName())) {
                response.setError(1);
            } else {
                response.setError(0);
                registeredObjects.put(entry.getName(), entry);
            }
        }
        catch (IOException e) {
            response.setError(2);
        }
        return response;
    }

    private Response unregister(String name) {
        StringResponse response = new StringResponse();
        if (registeredObjects.containsKey(name)) {
            response.setError(0);
            registeredObjects.remove(name);
        } else {
            response.setError(2);
        }
        return response;
    }

    private Response lookup(String name) {
        StringResponse response = new StringResponse();
        RegistryEntry entry = registeredObjects.get(name);
        if (entry != null) {
            response.setError(0);
            response.setPayload(this.objectToJson(entry));
        } else {
            response.setError(1);
        }
        return response;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setAttribute("registeredObjects", registeredObjects);
        String action = request.getParameter("action");
        if (action == null) {
            RequestDispatcher dispatcher = request.getRequestDispatcher("jsp/RemoteRegistry.jsp");
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        } else {
            Response result = null;
            response.setContentType("application/json");
            if (action.equals("register")) {
                result = this.register(request.getParameter("entry"));
            } else if (action.equals("unregister")) {
                result = this.unregister(request.getParameter("name"));
            } else if (action.equals("lookup")) {
                result = this.lookup(request.getParameter("name"));
            }
            if (result == null || result.getError() != 0) {
                response.setStatus(404);
            }
            response.getOutputStream().print(result.toJson());
        }
    }
}

