/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.se;

import de.uka.ipd.sdq.probfunction.math.IProbabilityFunctionFactory;
import de.uka.ipd.sdq.probfunction.math.IRandomGenerator;
import de.uka.ipd.sdq.probfunction.math.impl.DefaultRandomGenerator;
import de.uka.ipd.sdq.probfunction.math.impl.ProbabilityFunctionFactoryImpl;
import de.uka.ipd.sdq.sensorframework.entities.Experiment;
import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.simucomframework.variables.cache.StoExCache;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.palladiosimulator.protocom.framework.java.se.AbstractAllocationStorage;
import org.palladiosimulator.protocom.framework.java.se.ComponentAllocation;
import org.palladiosimulator.protocom.framework.java.se.IStopable;
import org.palladiosimulator.protocom.framework.java.se.experiment.ExperimentManager;
import org.palladiosimulator.protocom.framework.java.se.registry.RmiRegistry;
import org.palladiosimulator.protocom.framework.java.se.utils.CommandLineParser;
import org.palladiosimulator.protocom.framework.java.se.utils.RunProperties;
import org.palladiosimulator.protocom.framework.java.se.utils.UserMenu;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.DegreeOfAccuracyEnum;

public abstract class AbstractMain {
    protected static final Logger LOGGER = Logger.getRootLogger();
    protected List<Thread> threads = new ArrayList<Thread>();
    protected RunProperties runProps;

    protected void run(String[] args) {
        this.runProps = CommandLineParser.parseCommandLine(args);
        this.setupLogging();
        LOGGER.info((Object)"Command line read. Logging initialised. Protocom starts its workflow now...");
        LOGGER.info((Object)"Reading allocation configuration. Callibrating container if needed");
        this.initAllocationStorage();
        AbstractAllocationStorage.initContainer();
        DefaultRandomGenerator randomGen = new DefaultRandomGenerator();
        if (this.runProps.hasOption('E')) {
            randomGen.setSeed(Long.valueOf(Long.parseLong(this.runProps.getOptionValue('E'))));
        }
        RmiRegistry.setRemoteAddress(this.getRMIRegistry());
        RmiRegistry.setRegistryPort(this.getRMIPort());
        LOGGER.info((Object)("Initialising StoEx Cache " + (this.runProps.hasOption('E') ? " - Seed: " + this.runProps.getOptionValue('E') : "")));
        ProbabilityFunctionFactoryImpl probFunctionFactory = ProbabilityFunctionFactoryImpl.getInstance();
        probFunctionFactory.setRandomGenerator((IRandomGenerator)randomGen);
        StoExCache.initialiseStoExCache((IProbabilityFunctionFactory)probFunctionFactory);
        this.createUserMenu();
    }

    private void createUserMenu() {
        List<Integer> itemIds = UserMenu.showUserMenu(this.getSystems());
        for (int itemId : itemIds) {
            this.handleMenuItem(itemId);
        }
    }

    private void handleMenuItem(int itemId) {
        if (itemId == 1) {
            LOGGER.debug((Object)"Start: Start everything in local mode");
            RmiRegistry.startRegistry();
            AbstractAllocationStorage.setLocalMode(true);
            this.setupResources();
            this.startLocalMode();
        } else if (itemId == 2) {
            LOGGER.debug((Object)"Start: RmiRegistry");
            RmiRegistry.main(null);
        } else if (itemId == 3) {
            LOGGER.debug((Object)"Start: Usage Scenarios");
            try {
                ExperimentManager.init(String.valueOf(this.runProps.getOptionValue('n')) + " (Usage Scenario)", String.valueOf(this.runProps.getOptionValue('d')) + "-UsageScenario", 1);
                ExperimentManager.getInstance().startNewExperimentRun();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            this.startMeasurements();
        } else {
            String[][] systems;
            int i = 4;
            String[][] stringArray = systems = this.getSystems();
            int n = systems.length;
            int n2 = 0;
            while (n2 < n) {
                String[] system = stringArray[n2];
                if (itemId == i) {
                    LOGGER.debug((Object)("Start: System " + system[0]));
                    this.invokeMethod(this.getMain(system[0]), this.getRMIRegistry(), "" + this.getRMIPort());
                }
                ++i;
                ++n2;
            }
            Collection<String> containers = AbstractAllocationStorage.getContainerIds();
            for (String containerId : containers) {
                if (itemId == i) {
                    LOGGER.debug((Object)("Start: Container " + AbstractAllocationStorage.getContainerName(containerId)));
                    AbstractAllocationStorage.setActiveContainer(containerId);
                    ExperimentManager.init(String.valueOf(this.runProps.getOptionValue('n')) + " (" + AbstractAllocationStorage.getContainerName(containerId) + ")", String.valueOf(this.runProps.getOptionValue('d')) + "-" + AbstractAllocationStorage.getContainerName(containerId), 2);
                    ExperimentManager.getInstance().createExperimentRun();
                    this.setupResources();
                    this.startComponentsFromContainer(containerId);
                }
                ++i;
            }
        }
    }

    private String getRMIRegistry() {
        if (this.runProps.hasOption("R")) {
            return this.runProps.getOptionValue("R");
        }
        return "localhost";
    }

    private int getRMIPort() {
        if (this.runProps.hasOption("O")) {
            return Integer.parseInt(this.runProps.getOptionValue("O"));
        }
        return 1099;
    }

    private Method getMain(Class<?> mainClass) {
        if (mainClass == null) {
            return null;
        }
        try {
            return mainClass.getMethod("main", String[].class);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected void startMeasurements() {
        if (!this.runProps.hasOption('P') || this.runProps.hasOption('W')) {
            this.initialiseThreads(ExperimentManager.getExperiment(), ExperimentManager.getLatestExperimentRun());
        }
        if (!this.runProps.hasOption('P') && !this.runProps.hasOption('W')) {
            try {
                LOGGER.info((Object)("Current time: " + new Date()));
                this.startThreads();
                this.stop();
                LOGGER.info((Object)("Current time: " + new Date()));
                ExperimentManager.getInstance().writeResultsAndClose();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (RemoteException e) {
                LOGGER.error((Object)"Error when calling remote server.", (Throwable)e);
            }
        }
        System.exit(0);
    }

    private void startLocalMode() {
        ExperimentManager.init(this.runProps.getOptionValue('n'), this.runProps.getOptionValue('d'), 2);
        ExperimentManager.getInstance().createExperimentRun();
        Collection<String> containers = AbstractAllocationStorage.getContainerIds();
        for (String containerId : containers) {
            this.startComponentsFromContainer(containerId);
        }
        this.initialiseSystems();
        this.startMeasurements();
    }

    private void startComponentsFromContainer(String containerId) {
        Collection<ComponentAllocation> components = AbstractAllocationStorage.getComponents(containerId);
        for (ComponentAllocation component : components) {
            LOGGER.info((Object)("Start: Component " + component.getComponentClass().getName() + ", assembly context: " + component.getAssemblyContext()));
            this.invokeMethod(this.getMain(component.getComponentClass()), this.getRMIRegistry(), "" + this.getRMIPort(), component.getAssemblyContext());
        }
    }

    protected abstract void initAllocationStorage();

    private void invokeMethod(Method method, String ... params) {
        try {
            method.invoke(null, new Object[]{params});
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to run main method", (Throwable)e);
            System.exit(-1);
        }
    }

    private Method getMain(String mainClass) {
        if (mainClass == null) {
            return null;
        }
        try {
            Class<?> cls = Class.forName(mainClass);
            return cls.getMethod("main", String[].class);
        }
        catch (Throwable e) {
            LOGGER.info((Object)"Failed to retrieve main class. Falling back to menu mode");
            return null;
        }
    }

    private void startThreads() {
        LOGGER.info((Object)"Starting workload threads. ");
        if (this.runProps.hasOption('m')) {
            LOGGER.info((Object)("Taking " + this.runProps.getOptionValue('m') + " measurements"));
        } else {
            LOGGER.info((Object)"Request a measurement stop by pressing any key!");
        }
        for (Thread t : this.threads) {
            t.start();
        }
    }

    private void setupLogging() {
        LOGGER.removeAllAppenders();
        PatternLayout layout = new PatternLayout("%d{HH:mm} %-5p [%t]: %m%n");
        LOGGER.addAppender((Appender)new ConsoleAppender((Layout)layout));
        if (this.runProps.hasOption('D')) {
            LOGGER.setLevel(Level.DEBUG);
        } else {
            LOGGER.setLevel(Level.INFO);
        }
    }

    private void stop() {
        if (!this.runProps.hasOption('m')) {
            LOGGER.debug((Object)"Request Thread stop");
            for (Thread t : this.threads) {
                ((IStopable)((Object)t)).requestStop();
            }
        }
        for (Thread t : this.threads) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    protected abstract void setupResources();

    protected abstract void initialiseSystems();

    protected abstract String[][] getSystems();

    protected DegreeOfAccuracyEnum getAccuracy() {
        DegreeOfAccuracyEnum accuracy = DegreeOfAccuracyEnum.MEDIUM;
        if (this.runProps.hasOption('a')) {
            try {
                String acc = this.runProps.getOptionValue('a').toUpperCase();
                accuracy = DegreeOfAccuracyEnum.valueOf((String)acc);
                LOGGER.info((Object)("Using accuracy for calibration: " + acc));
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn((Object)("Calibration accuracy " + this.runProps.getOptionValue('a') + " not found! Using MEDIUM instead"));
            }
        } else {
            LOGGER.info((Object)"Using default accuracy for calibration: MEDIUM");
        }
        return accuracy;
    }

    protected abstract void initialiseThreads(Experiment var1, ExperimentRun var2);

    public static String getAssemblyContextFromArguments(String[] args) {
        if (args != null && args.length > 2) {
            return args[2];
        }
        return "";
    }
}

