/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.se.strategies;

import java.util.HashMap;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.DegreeOfAccuracyEnum;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.IDemandStrategy;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.ResourceTypeEnum;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.cpu.FibonacciDemand;

public class StrategiesRegistry {
    private final HashMap<ResourceTypeEnum, IDemandStrategy> strategiesHash = new HashMap();
    private static StrategiesRegistry singletonInstance = new StrategiesRegistry();

    private StrategiesRegistry() {
        FibonacciDemand strat = new FibonacciDemand();
        strat.initializeStrategy(DegreeOfAccuracyEnum.MEDIUM, 1.0);
        strat.ensureCalibrationExists();
        this.registerStrategyFor(ResourceTypeEnum.CPU, (IDemandStrategy)strat);
    }

    public static StrategiesRegistry singleton() {
        return singletonInstance;
    }

    public void registerStrategyFor(ResourceTypeEnum resourceType, IDemandStrategy strategy) {
        this.strategiesHash.put(resourceType, strategy);
    }

    public IDemandStrategy getStrategyFor(ResourceTypeEnum resource) {
        assert (this.strategiesHash.containsKey(resource));
        return this.strategiesHash.get(resource);
    }
}

