/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.resourcestrategies.activeresource;

import java.io.File;
import java.util.Arrays;
import java.util.Properties;
import javax.measure.quantity.Duration;
import javax.measure.quantity.Quantity;
import javax.measure.unit.BaseUnit;
import javax.measure.unit.NonSI;
import javax.measure.unit.ProductUnit;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.apache.log4j.Logger;
import org.jscience.physics.amount.Amount;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.CalibrationEntry;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.CalibrationTable;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.DegreeOfAccuracyEnum;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.ICalibrationListener;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.IDemandStrategy;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.ResourceTypeEnum;

public abstract class AbstractDemandStrategy
implements IDemandStrategy {
    private static final int RIGHT_ENDPOINT = 1;
    private static final int LEFT_ENDPOINT = 0;
    public static final Unit<Work> WORKUNITS = new BaseUnit("WU");
    public static final String CALIBRATION_PATH_CONFIG_KEY = "CalibrationPath";
    private static final int MIN_CALIBRATION_CYCLES = 5;
    private CalibrationTable calibrationTable;
    private static final Amount<Duration> ONE_MILLISECOND = Amount.valueOf((long)1L, (Unit)SI.MILLI((Unit)SI.SECOND));
    private static final int DEFAULT_ACCURACY = 8;
    private final int warmUpCycles;
    private final int low;
    private final int medium;
    private final int high;
    protected long defaultIterationCount;
    private Properties properties;
    private Amount<ProcessingRate> processingRate;
    private ICalibrationListener listener;
    private boolean debug;
    protected DegreeOfAccuracyEnum degreeOfAccuracy;
    private static final Logger LOGGER = Logger.getLogger((String)AbstractDemandStrategy.class.getName());
    private static final String CALIBRATION_PATH = "../ProtoComCalibration/";
    private static final int[] CALIBRATION_CYCLES = new int[]{1024, 512, 256, 128, 64, 50, 40, 30, 25, 20, 15, 10};
    private static final int OUTLIER_RATE = 5;

    public AbstractDemandStrategy(int low, int medium, int high, int iterationCount, int warmups) {
        this.low = low;
        this.medium = medium;
        this.high = high;
        this.defaultIterationCount = iterationCount;
        this.warmUpCycles = warmups;
    }

    @Override
    public void initializeStrategy(DegreeOfAccuracyEnum degree, double initProcessingRate) {
        LOGGER.info((Object)("Initialising " + this.getName() + " " + this.getStrategysResource().name() + "  strategy with accuracy " + degree.name()));
        this.degreeOfAccuracy = degree;
        this.processingRate = Amount.valueOf((double)initProcessingRate, ProcessingRate.UNIT);
        LOGGER.debug((Object)(String.valueOf(this.getName()) + " " + this.getStrategysResource().name() + " strategy initialised"));
    }

    @Override
    public void initializeStrategy(DegreeOfAccuracyEnum degreeOfAccuracy, double processingRate, String calibrationPath) {
        if (calibrationPath != null) {
            Properties props = new Properties();
            props.setProperty(CALIBRATION_PATH_CONFIG_KEY, calibrationPath);
            this.setProperties(props);
        }
        this.initializeStrategy(degreeOfAccuracy, processingRate);
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public void consume(double demand) {
        if (this.calibrationTable == null) {
            LOGGER.fatal((Object)"No calibration found - STRATEGY HAS TO BE INITIALIZED FIRST!");
            throw new RuntimeException("No calibration found - STRATEGY HAS TO BE INITIALIZED FIRST!");
        }
        Amount demandedWork = Amount.valueOf((double)demand, Work.UNIT);
        Amount millisec = demandedWork.divide(this.processingRate).to((Unit)SI.SECOND);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Consume called, demand is : " + demandedWork + ", " + millisec));
        }
        long[] factors = this.fillTimeFrame((Amount<Duration>)millisec);
        int i = 0;
        while (i < factors.length) {
            long loopCount = factors[i];
            int j = 0;
            while ((long)j < loopCount) {
                this.run(this.calibrationTable.getEntry(i).getParameter());
                ++j;
            }
            ++i;
        }
        LOGGER.debug((Object)"Demand consumed");
    }

    @Override
    public abstract ResourceTypeEnum getStrategysResource();

    @Override
    public abstract String getName();

    protected String getCalibrationFileName() {
        return this.getCalibrationPath() + "/" + this.getName() + "_" + 11 + "_" + this.degreeOfAccuracy.name() + ".ser";
    }

    protected File getCalibrationPath() {
        String pathString = null;
        pathString = this.properties != null ? String.valueOf(this.properties.getProperty(CALIBRATION_PATH_CONFIG_KEY)) + "/" : CALIBRATION_PATH;
        File path = null;
        if (pathString != null) {
            path = new File(pathString);
        }
        if (!path.exists()) {
            if (path.mkdirs()) {
                LOGGER.info((Object)("Created Calibration Path " + path));
            } else {
                LOGGER.error((Object)("Could not create " + path + ". Assure you have the rights to create and write to this folder."));
                System.exit(0);
            }
        }
        return path;
    }

    protected abstract void run(long var1);

    @Override
    public void ensureCalibrationExists() {
        File configFile = new File(this.getCalibrationFileName());
        CalibrationTable loadedCalibration = CalibrationTable.load(configFile);
        if (loadedCalibration != null) {
            this.calibrationTable = loadedCalibration;
        } else {
            this.calibrate();
            this.calibrationTable.save(configFile);
        }
    }

    @Override
    public CalibrationTable calibrate() {
        this.calibrationTable = new CalibrationTable();
        if (this.debug) {
            LOGGER.debug((Object)"Debugging calibration");
            int i = 0;
            while (i < 10) {
                try {
                    Thread.sleep(750L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.listener.progressChanged(this, (float)(i + 1) / 10.0f);
                this.calibrationTable.addEntry(i, (Amount<Duration>)Amount.valueOf((long)1L, (Unit)SI.MILLI((Unit)SI.SECOND)), 0L);
                ++i;
            }
            return this.calibrationTable;
        }
        int i = 0;
        while (i < this.warmUpCycles) {
            this.run(this.defaultIterationCount);
            ++i;
        }
        LOGGER.info((Object)"The timetable with the corresponding parameters:");
        i = 0;
        while (i < this.calibrationTable.size()) {
            Amount<Duration> targetTime = Amount.valueOf((long)(1 << i), (Unit)SI.MILLI((Unit)SI.SECOND));
            long parameter = this.getRoot(targetTime);
            if (i > 2) {
                targetTime = this.recalibrate(parameter, i);
            }
            if (this.listener != null) {
                float progress = (float)i / (float)(this.calibrationTable.size() - 1);
                this.listener.progressChanged(this, progress);
            }
            this.calibrationTable.addEntry(i, targetTime, parameter);
            LOGGER.info((Object)this.calibrationTable.getEntry(i));
            ++i;
        }
        return this.calibrationTable;
    }

    @Override
    public void setCalibrationListener(ICalibrationListener listener) {
        this.listener = listener;
    }

    @Override
    public void setCalibrationTable(CalibrationTable table) {
        this.calibrationTable = table;
    }

    @Override
    public boolean hasCalibrationTable() {
        return this.calibrationTable != null;
    }

    @Override
    public void setDebug(boolean enable) {
        this.debug = enable;
    }

    @Override
    public boolean debugEnabled() {
        return this.debug;
    }

    private long getRoot(Amount<Duration> targetTime) {
        int numberOfRepetitions = 2;
        return this.getRoot(targetTime, 2);
    }

    private long getRoot(Amount<Duration> targetTime, int numberOfRepetitions) {
        long[] targetParameter = new long[numberOfRepetitions];
        int i = 0;
        while (i < numberOfRepetitions) {
            targetParameter[i] = this.getRootOnce(targetTime);
            ++i;
        }
        return this.mean(targetParameter);
    }

    private long getRootOnce(Amount<Duration> targetTime) {
        long[] intervalEndpoints = new long[2];
        Amount[] intervalFunctionValues = new Amount[2];
        this.initialiseInterval(targetTime, intervalEndpoints, intervalFunctionValues);
        if (!this.hasRoot((Amount<Duration>)intervalFunctionValues[0], (Amount<Duration>)intervalFunctionValues[1]) || intervalFunctionValues[0].isGreaterThan(intervalFunctionValues[1])) {
            LOGGER.error((Object)"PROBLEM: No root found. Special algorithm without monotonically increasing load !?!");
            LOGGER.error((Object)("f_n_left = " + intervalFunctionValues[0]));
            LOGGER.error((Object)("f_n_right = " + intervalFunctionValues[1]));
            throw new RuntimeException("PROBLEM: No root found. Special algorithm without monotonically increasing load !?!");
        }
        LOGGER.debug((Object)"--- Running bisection method ----");
        Amount<Duration> epsilon = this.getEpsilon(targetTime);
        while (Math.abs(intervalEndpoints[0] - intervalEndpoints[1]) > 2L && intervalFunctionValues[1].minus(intervalFunctionValues[0]).abs().isLargerThan(epsilon)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("[" + intervalEndpoints[0] + ", " + intervalEndpoints[1] + "] --> " + "[" + AbstractDemandStrategy.formatDuration((Amount<Duration>)intervalFunctionValues[0]) + ", " + AbstractDemandStrategy.formatDuration((Amount<Duration>)intervalFunctionValues[1]) + "]"));
            }
            long intervalMedian = (intervalEndpoints[0] + intervalEndpoints[1]) / 2L;
            Amount<Duration> f_n_median = this.calcRunTimeFunction(intervalMedian, targetTime);
            if (this.hasSameSign(intervalFunctionValues[0].getEstimatedValue(), f_n_median.getEstimatedValue())) {
                intervalEndpoints[0] = intervalMedian;
                intervalFunctionValues[0] = f_n_median;
                continue;
            }
            intervalEndpoints[1] = intervalMedian;
            intervalFunctionValues[1] = f_n_median;
        }
        return (intervalEndpoints[0] + intervalEndpoints[1]) / 2L;
    }

    private Amount<Duration> getEpsilon(Amount<Duration> targetTime) {
        Amount result = targetTime.times(0.01);
        if (result.to(SI.MILLI((Unit)SI.SECOND)).isGreaterThan(ONE_MILLISECOND)) {
            return ONE_MILLISECOND;
        }
        return result;
    }

    private boolean hasSameSign(double a, double b) {
        return a * b > 0.0;
    }

    private Amount<Duration> recalibrate(long parameter, int index) {
        int cycles = CALIBRATION_CYCLES[index];
        return this.getRunTime(parameter, (Amount<Duration>)Amount.valueOf((long)cycles, (Unit)SI.MILLI((Unit)SI.SECOND)));
    }

    private void initialiseInterval(Amount<Duration> targetTime, long[] intervalEndpoints, Amount<Duration>[] intervalFunctionValues) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Find inital interval for target time " + AbstractDemandStrategy.formatDuration(targetTime)));
        }
        long z = 0L;
        do {
            intervalEndpoints[0] = intervalEndpoints[1];
            intervalFunctionValues[0] = intervalFunctionValues[1];
            intervalEndpoints[1] = z * this.defaultIterationCount;
            intervalFunctionValues[1] = this.calcRunTimeFunction(intervalEndpoints[1], targetTime);
            long l = z = z == 0L ? 1L : z << 1;
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)("[" + intervalEndpoints[0] + ", " + intervalEndpoints[1] + "] --> " + "[" + AbstractDemandStrategy.formatDuration(intervalFunctionValues[0]) + ", " + AbstractDemandStrategy.formatDuration(intervalFunctionValues[1]) + "]"));
        } while (intervalFunctionValues[1].isLessThan(Amount.valueOf((long)0L, (Unit)SI.SECOND)));
    }

    private boolean hasRoot(Amount<Duration> f_n_left, Amount<Duration> f_n_right) {
        return !this.hasSameSign(f_n_left.getEstimatedValue(), f_n_right.getEstimatedValue());
    }

    private Amount<Duration> calcRunTimeFunction(long parameter, Amount<Duration> targetTime) {
        return this.getRunTime(parameter, targetTime).minus(targetTime);
    }

    private Amount<Duration> getRunTime(long parameter, Amount<Duration> targetTime) {
        int cycles = this.getCalibrationCycles(this.getAccuracyValue(), targetTime);
        long[] approximation = new long[cycles];
        int i = 0;
        while (i < cycles) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("Measuring calibration run " + i + " of " + cycles));
            }
            long start = System.nanoTime();
            this.run(parameter);
            approximation[i] = System.nanoTime() - start;
            ++i;
        }
        long mean = this.mean(approximation);
        LOGGER.debug((Object)("Mean time for parameter " + parameter + " is " + mean));
        return Amount.valueOf((long)mean, (Unit)SI.NANO((Unit)SI.SECOND));
    }

    private long mean(long[] p) {
        int start;
        long sum = 0L;
        Arrays.sort(p);
        int i = start = p.length > 5 ? p.length / 5 : 0;
        while (i < p.length - start) {
            sum += p[i];
            ++i;
        }
        return sum / (long)(p.length - start * 2);
    }

    private int getCalibrationCycles(int exponent, Amount<Duration> targetTime) {
        Amount threshold = Amount.valueOf((long)(1 << exponent), (Unit)SI.MILLI((Unit)SI.SECOND));
        return Math.max((int)Math.floor(threshold.divide(targetTime).getEstimatedValue()), 5);
    }

    private int getAccuracyValue() {
        int result = 8;
        switch (this.degreeOfAccuracy) {
            case HIGH: {
                result += this.high;
                break;
            }
            case MEDIUM: {
                result += this.medium;
                break;
            }
            case LOW: {
                result += this.low;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported degree of accuracy");
            }
        }
        return result;
    }

    private long[] fillTimeFrame(Amount<Duration> millisec) {
        long[] result = new long[11];
        Amount sum = millisec;
        int i = 10;
        while (i >= 0) {
            CalibrationEntry calibrationEntry = this.calibrationTable.getEntry(i);
            result[i] = (long)Math.floor(sum.divide(calibrationEntry.getTargetTime()).to(Unit.ONE).getEstimatedValue());
            if (result[i] >= 1L) {
                sum = sum.minus(calibrationEntry.getTargetTime().times(result[i]));
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)(String.valueOf(AbstractDemandStrategy.formatDuration(calibrationEntry.getTargetTime())) + " | " + calibrationEntry.getParameter() + " | " + result[i] + "|" + AbstractDemandStrategy.formatDuration((Amount<Duration>)sum)));
            }
            --i;
        }
        return result;
    }

    @Deprecated
    public void watchConsume(double demand) {
        int repetitionCount = 10;
        if (this.calibrationTable == null) {
            LOGGER.fatal((Object)"No calibration found - STRATEGY HAS TO BE INITIALIZED FIRST!");
            throw new RuntimeException("No calibration found - STRATEGY HAS TO BE INITIALIZED FIRST!");
        }
        Amount demandedWork = Amount.valueOf((double)demand, Work.UNIT);
        Amount expectedTime = demandedWork.divide(this.processingRate).to((Unit)SI.SECOND);
        LOGGER.info((Object)("Request issued to consume " + demandedWork));
        LOGGER.info((Object)("Expected duration is " + AbstractDemandStrategy.formatDuration((Amount<Duration>)expectedTime)));
        long theTime = System.nanoTime();
        int h = 0;
        while (h < 10) {
            this.consume(demand);
            ++h;
        }
        Amount measuredTime = Amount.valueOf((long)((System.nanoTime() - theTime) / 10L), (Unit)SI.NANO((Unit)SI.SECOND));
        LOGGER.info((Object)("Demand of " + AbstractDemandStrategy.formatDuration((Amount<Duration>)expectedTime) + " consumed at an average value of " + AbstractDemandStrategy.formatDuration((Amount<Duration>)measuredTime) + ". Abs. difference is " + AbstractDemandStrategy.formatDuration((Amount<Duration>)measuredTime.minus(expectedTime).abs())));
    }

    public static String formatDuration(Amount<Duration> t) {
        Unit[] units;
        if (t == null) {
            return "null";
        }
        Unit[] unitArray = units = new Unit[]{SI.NANO((Unit)SI.SECOND), SI.MICRO((Unit)SI.SECOND), SI.MILLI((Unit)SI.SECOND), SI.SECOND, NonSI.MINUTE, NonSI.HOUR};
        int n = units.length;
        int n2 = 0;
        while (n2 < n) {
            Unit u = unitArray[n2];
            double value = t.to(u).getEstimatedValue();
            if (Math.abs(value) < 1000.0) {
                return String.valueOf(value) + " " + u;
            }
            ++n2;
        }
        return t.toText().toString();
    }

    public static interface ProcessingRate
    extends Quantity {
        public static final Unit<ProcessingRate> UNIT = new ProductUnit(Work.UNIT.divide((Unit)SI.SECOND));
    }

    public static interface Work
    extends Quantity {
        public static final Unit<Work> UNIT = WORKUNITS;
    }
}

