/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.resourcestrategies.activeresource.hdd;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.AbstractDemandStrategy;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.DegreeOfAccuracyEnum;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.IDemandStrategy;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.ResourceTypeEnum;
import org.palladiosimulator.protocom.resourcestrategies.system.SystemResourcesUtil;

public class ReadLargeChunksDemand
extends AbstractDemandStrategy
implements IDemandStrategy {
    private final int maxFileSize;
    private static final int DEFAULT_MAX_FILE_SIZE = 8000000;
    private final long numberOfFiles;
    private final File fileDirectory;
    private final List<File> files = new LinkedList<File>();
    private final List<File> cleanupFiles = new LinkedList<File>();
    private Iterator<File> iterator = null;
    private static final Logger LOGGER = Logger.getLogger((String)ReadLargeChunksDemand.class.getName());

    public ReadLargeChunksDemand() {
        this(SystemResourcesUtil.TEMP_DIR, 8000000);
    }

    public ReadLargeChunksDemand(File path, int maxFileSize) {
        super(-2, 0, 2, 100, 10);
        this.fileDirectory = path;
        this.maxFileSize = maxFileSize;
        this.numberOfFiles = ReadLargeChunksDemand.calculateDefaultNumberOfFiles();
    }

    private static long calculateDefaultNumberOfFiles() {
        long ramSize = SystemResourcesUtil.getTotalPhysicalMemorySize();
        long number = ramSize / 8000000L;
        number = (long)((float)number * 1.1f);
        return number;
    }

    @Override
    protected void run(long load) {
        LOGGER.debug((Object)("Consume HDD demand of: " + load));
        try {
            int success;
            long remainingLoad = load;
            do {
                FileInputStream fis = new FileInputStream(this.nextFile());
                long consume = remainingLoad > (long)this.maxFileSize ? (long)this.maxFileSize : remainingLoad;
                byte[] byteArray = new byte[(int)consume];
                success = fis.read(byteArray);
                fis.close();
                LOGGER.trace((Object)("Adjusted demand consumed: " + success));
            } while ((remainingLoad -= (long)success) > 0L);
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"HDD demand strategy failed", (Throwable)e);
            System.exit(-1);
        }
        catch (IOException e) {
            LOGGER.error((Object)"HDD demand strategy failed", (Throwable)e);
            System.exit(-1);
        }
        LOGGER.debug((Object)"Complete HDD demand consumed");
    }

    private synchronized File nextFile() {
        assert (this.files.size() > 0);
        assert (this.iterator != null);
        if (!this.iterator.hasNext()) {
            this.iterator = this.files.iterator();
        }
        return this.iterator.next();
    }

    @Override
    public ResourceTypeEnum getStrategysResource() {
        return ResourceTypeEnum.HDD;
    }

    @Override
    public void initializeStrategy(DegreeOfAccuracyEnum degreeOfAccuracy, double processingRate, String calibrationPath) {
        this.preInitHDDStrategy();
        super.initializeStrategy(degreeOfAccuracy, processingRate, calibrationPath);
    }

    @Override
    public void initializeStrategy(DegreeOfAccuracyEnum degreeOfAccuracy, double processingRate) {
        this.preInitHDDStrategy();
        super.initializeStrategy(degreeOfAccuracy, processingRate);
    }

    private void preInitHDDStrategy() {
        if (this.files.size() > 0) {
            return;
        }
        LOGGER.debug((Object)("Pre-Initialising strategy reading from " + this.fileDirectory));
        if (!this.fileDirectory.exists()) {
            LOGGER.info((Object)"Directory given for reading files does not exist. Trying to prepare one");
            try {
                this.createFileDirectory();
                this.writeTestFiles();
                LOGGER.info((Object)"Wrote files to be read.");
            }
            catch (IOException e) {
                LOGGER.error((Object)"Failed creating files for HDD strategy. Maybe missing permission?", (Throwable)e);
                System.exit(-1);
            }
        } else if (this.fileDirectory.isDirectory()) {
            LOGGER.info((Object)("Reading file list from " + this.fileDirectory.getAbsolutePath()));
            this.initialiseFileList(this.fileDirectory);
        } else {
            LOGGER.error((Object)("There already is a file at " + this.fileDirectory.getAbsolutePath()));
        }
        if (this.files.isEmpty()) {
            try {
                this.writeTestFiles();
                LOGGER.debug((Object)"Wrote files to be read.");
            }
            catch (IOException e) {
                LOGGER.error((Object)"Failed reading files for HDD strategy", (Throwable)e);
                System.exit(-1);
            }
        }
        if (this.files.size() < 1) {
            LOGGER.error((Object)"The strategy could not be initialised as there are no files to read.");
            System.exit(-1);
        } else {
            this.iterator = this.files.iterator();
            LOGGER.info((Object)("HDD Strategy initialised with " + this.files.size() + " files in folder " + this.fileDirectory.getAbsolutePath()));
        }
    }

    private void createFileDirectory() throws IOException {
        if (!this.fileDirectory.mkdirs()) {
            LOGGER.error((Object)"File directory could not be created during initialisation.");
            throw new IOException("Directory for files store could not be created");
        }
    }

    private boolean writeTestFiles() throws IOException {
        long neededSize = this.numberOfFiles * 8000000L;
        long tmpSize = SystemResourcesUtil.getFreeTempDirectorySize();
        if (neededSize > tmpSize) {
            LOGGER.error((Object)("The required storage space for calibration exceeds the free space in " + SystemResourcesUtil.TEMP_DIR.getAbsolutePath()));
            System.exit(-1);
        }
        int i = 0;
        while ((long)i < this.numberOfFiles) {
            File childFile = new File(this.fileDirectory, "file" + i);
            childFile.createNewFile();
            FileOutputStream fos = new FileOutputStream(childFile);
            byte[] bytes = new byte[this.maxFileSize];
            fos.write(bytes);
            fos.flush();
            fos.close();
            this.files.add(childFile);
            this.cleanupFiles.add(childFile);
            ++i;
        }
        return true;
    }

    private void initialiseFileList(File files) {
        File[] childFiles = files.listFiles();
        if (childFiles != null) {
            LOGGER.debug((Object)("Found " + childFiles.length + " files in the first directory(" + files.getAbsolutePath() + ")."));
            File[] fileArray = childFiles;
            int n = childFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    this.initialiseFileList(file);
                } else if (file.length() >= (long)this.maxFileSize) {
                    this.files.add(file);
                } else {
                    LOGGER.debug((Object)("File is too small: " + file.getAbsolutePath() + ". We skip it..."));
                }
                ++n2;
            }
        }
    }

    public int getMaxFileSize() {
        return this.maxFileSize;
    }

    @Override
    public String getName() {
        return "Read Large Chunks";
    }

    @Override
    public void cleanup() {
        for (File file : this.cleanupFiles) {
            LOGGER.debug((Object)("Trying to delete file " + file.getName()));
            if (file.delete()) continue;
            LOGGER.error((Object)("Failed to delete file " + file.getName()));
        }
    }
}

