/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.jobs;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.palladiosimulator.analyzer.workflow.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.analyzer.workflow.configurations.AbstractCodeGenerationWorkflowRunConfiguration;
import org.palladiosimulator.pcm.core.entity.NamedElement;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.protocom.ProtoComProject;
import org.palladiosimulator.protocom.ProtoComProjectFactory;
import org.palladiosimulator.protocom.traverse.framework.allocation.XAllocation;
import org.palladiosimulator.protocom.traverse.framework.repository.XRepository;
import org.palladiosimulator.protocom.traverse.framework.resourceenvironment.XResourceEnvironment;
import org.palladiosimulator.protocom.traverse.framework.system.XSystem;
import org.palladiosimulator.protocom.traverse.framework.usage.XUsageScenario;
import org.palladiosimulator.protocom.traverse.jee.JeeConfigurationModule;
import org.palladiosimulator.protocom.traverse.jeeservlet.JeeServletConfigurationModule;
import org.palladiosimulator.protocom.traverse.jse.JseConfigurationModule;
import org.palladiosimulator.protocom.traverse.jsestub.JseStubConfigurationModule;
import org.palladiosimulator.protocom.workflow.ProtoComGenerationConfiguration;

public class TransformPCMToCodeXtendJob
extends SequentialBlackboardInteractingJob<MDSDBlackboard>
implements IJob,
IBlackboardInteractingJob<MDSDBlackboard> {
    protected ProtoComGenerationConfiguration configuration;

    public TransformPCMToCodeXtendJob(ProtoComGenerationConfiguration configuration) {
        this.configuration = configuration;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        ProtoComProjectFactory.setProjectType((AbstractCodeGenerationWorkflowRunConfiguration.CodeGenerationAdvice)this.configuration.getCodeGenerationAdvice());
        JseConfigurationModule guiceConfiguration = null;
        if (this.configuration.getCodeGenerationAdvice() == AbstractCodeGenerationWorkflowRunConfiguration.CodeGenerationAdvice.PROTO) {
            guiceConfiguration = new JseConfigurationModule();
        } else if (this.configuration.getCodeGenerationAdvice() == AbstractCodeGenerationWorkflowRunConfiguration.CodeGenerationAdvice.POJO) {
            guiceConfiguration = new JseStubConfigurationModule();
        } else if (this.configuration.getCodeGenerationAdvice() == AbstractCodeGenerationWorkflowRunConfiguration.CodeGenerationAdvice.EJB3) {
            guiceConfiguration = new JeeConfigurationModule();
        } else if (this.configuration.getCodeGenerationAdvice() == AbstractCodeGenerationWorkflowRunConfiguration.CodeGenerationAdvice.SERVLET) {
            guiceConfiguration = new JeeServletConfigurationModule();
        }
        guiceConfiguration.setProjectURI(this.configuration.getStoragePluginID());
        Injector injector = Guice.createInjector((Module[])new Module[]{guiceConfiguration});
        int repositoryIndex = 0;
        while (repositoryIndex < this.getRepositoryCount()) {
            this.getRepositoryTransformationSlots(repositoryIndex);
            ++repositoryIndex;
        }
        PCMResourceSetPartition pcmPartition = (PCMResourceSetPartition)((MDSDBlackboard)this.myBlackboard).getPartition("org.palladiosimulator.pcmmodels.partition");
        for (Repository content : pcmPartition.getRepositories()) {
            ((XRepository)injector.getInstance(XRepository.class)).setEntity((NamedElement)content).transform();
        }
        ((XSystem)injector.getInstance(XSystem.class)).setEntity((NamedElement)pcmPartition.getSystem()).transform();
        ((XAllocation)injector.getInstance(XAllocation.class)).setEntity((NamedElement)pcmPartition.getAllocation()).transform();
        ((XResourceEnvironment)injector.getInstance(XResourceEnvironment.class)).setEntity((NamedElement)pcmPartition.getResourceEnvironment()).transform();
        for (UsageScenario scenario : pcmPartition.getUsageModel().getUsageScenario_UsageModel()) {
            ((XUsageScenario)injector.getInstance(XUsageScenario.class)).setEntity((NamedElement)scenario).transform();
        }
        for (ProtoComProject p : ProtoComProjectFactory.getCreatedProjects().values()) {
            p.compile();
        }
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
        ProtoComProjectFactory.cleanup();
    }

    public String getName() {
        return "Generate ProtoCom Plugin Code";
    }

    private int getRepositoryCount() {
        PCMResourceSetPartition pcmPartition = (PCMResourceSetPartition)((MDSDBlackboard)this.myBlackboard).getPartition("org.palladiosimulator.pcmmodels.partition");
        return pcmPartition.getRepositories().size();
    }

    private HashMap<String, Object> getRepositoryTransformationSlots(int repositoryIndex) {
        HashMap<String, Object> sC2 = new HashMap<String, Object>();
        PCMResourceSetPartition pcmPartition = (PCMResourceSetPartition)((MDSDBlackboard)this.myBlackboard).getPartition("org.palladiosimulator.pcmmodels.partition");
        sC2.put("pcmmodel", pcmPartition.getRepositories().get(repositoryIndex));
        return sC2;
    }
}

