/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom;

import com.google.common.base.Objects;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import java.io.File;
import java.util.HashMap;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.palladiosimulator.analyzer.workflow.configurations.AbstractCodeGenerationWorkflowRunConfiguration;
import org.palladiosimulator.protocom.ProjectDeletionChoice;
import org.palladiosimulator.protocom.ProjectDeletionRunner;
import org.palladiosimulator.protocom.ProtoComProject;

public class ProtoComProjectFactory {
    private static final Logger LOGGER = Logger.getLogger(ProtoComProjectFactory.class);
    private static HashMap<String, ProtoComProject> createdProjects = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private static AbstractCodeGenerationWorkflowRunConfiguration.CodeGenerationAdvice projectType;

    public static ProtoComProject getProject(String projectURI, String filePath) {
        ProtoComProject project = createdProjects.get(projectURI);
        boolean _equals = Objects.equal((Object)project, null);
        if (_equals) {
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            ProtoComProjectFactory.checkForExistingProject((IProgressMonitor)_nullProgressMonitor, projectURI);
            return ProtoComProjectFactory.createProject(projectURI, filePath);
        }
        return project;
    }

    public static HashMap<String, ProtoComProject> getCreatedProjects() {
        return createdProjects;
    }

    public static void cleanup() {
        createdProjects.clear();
    }

    public static AbstractCodeGenerationWorkflowRunConfiguration.CodeGenerationAdvice setProjectType(AbstractCodeGenerationWorkflowRunConfiguration.CodeGenerationAdvice type) {
        projectType = type;
        return projectType;
    }

    public static AbstractCodeGenerationWorkflowRunConfiguration.CodeGenerationAdvice getProjectType() {
        return projectType;
    }

    private static ProtoComProject createProject(String projectURI, String filePath) {
        ProtoComProject project = new ProtoComProject(projectURI, filePath, projectType);
        createdProjects.put(projectURI, project);
        return project;
    }

    private static void checkForExistingProject(IProgressMonitor monitor, String projectURI) {
        block7: {
            try {
                boolean _exists;
                IWorkspace _workspace = ResourcesPlugin.getWorkspace();
                IWorkspaceRoot _root = _workspace.getRoot();
                IProject iProject = _root.getProject(projectURI);
                boolean _or = false;
                boolean _projectFolderExists = ProtoComProjectFactory.projectFolderExists(projectURI);
                _or = _projectFolderExists ? true : (_exists = iProject.exists());
                if (!_or) break block7;
                ProjectDeletionChoice dialogChoice = ProtoComProjectFactory.userAcceptsProjectDelete(projectURI);
                boolean _equals = Objects.equal((Object)((Object)dialogChoice), (Object)((Object)ProjectDeletionChoice.ABORT));
                if (_equals) {
                    throw new JobFailedException("Aborted Prototype generation");
                }
                boolean _equals_1 = Objects.equal((Object)((Object)dialogChoice), (Object)((Object)ProjectDeletionChoice.DELETION));
                if (_equals_1) {
                    try {
                        ProtoComProjectFactory.deleteProject(monitor, iProject, projectURI);
                        break block7;
                    }
                    catch (Throwable _t) {
                        if (_t instanceof CoreException) {
                            CoreException e = (CoreException)_t;
                            throw new JobFailedException("Removing old project failed", (Throwable)e);
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                }
                throw new RuntimeException("Error when asking for user input");
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }

    private static boolean projectFolderExists(String projectURI) {
        IWorkspace _workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot _root = _workspace.getRoot();
        IPath _rawLocation = _root.getRawLocation();
        IPath _append = _rawLocation.append(projectURI);
        File projectFolder = _append.toFile();
        return projectFolder.exists();
    }

    private static ProjectDeletionChoice userAcceptsProjectDelete(String projectURI) {
        ProjectDeletionRunner runner = new ProjectDeletionRunner(projectURI);
        IWorkbench _workbench = PlatformUI.getWorkbench();
        Display _display = _workbench.getDisplay();
        _display.syncExec((Runnable)runner);
        return runner.shouldDelete();
    }

    private static void deleteProject(IProgressMonitor monitor, IProject myProject, String projectURI) throws CoreException {
        boolean _isEnabledFor = LOGGER.isEnabledFor((Priority)Level.INFO);
        if (_isEnabledFor) {
            String _name = myProject.getName();
            String _plus = "Deleting project " + _name;
            LOGGER.info((Object)_plus);
        }
        myProject.close(monitor);
        myProject.delete(4, monitor);
        IWorkspace _workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot _root = _workspace.getRoot();
        _root.refreshLocal(1, monitor);
        boolean _projectFolderExists = ProtoComProjectFactory.projectFolderExists(projectURI);
        if (_projectFolderExists) {
            ProtoComProjectFactory.clearProjectFolder(projectURI);
        }
    }

    private static void clearProjectFolder(String projectURI) {
        IWorkspace _workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot _root = _workspace.getRoot();
        IPath _rawLocation = _root.getRawLocation();
        IPath _append = _rawLocation.append(projectURI);
        File projectFolder = _append.toFile();
        ProtoComProjectFactory.deleteFolder(projectFolder);
    }

    private static boolean deleteFolder(File folder) {
        boolean _isDirectory = folder.isDirectory();
        if (_isDirectory) {
            File[] _listFiles;
            File[] fileArray = _listFiles = folder.listFiles();
            int n = _listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                boolean _not;
                File child = fileArray[n2];
                boolean _deleteFolder = ProtoComProjectFactory.deleteFolder(child);
                boolean bl = _not = !_deleteFolder;
                if (_not) {
                    return false;
                }
                ++n2;
            }
        }
        return folder.delete();
    }
}

