/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.recorderframework.edp2;

import java.util.Date;
import javax.measure.Measure;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.palladiosimulator.edp2.dao.MeasurementsDao;
import org.palladiosimulator.edp2.models.ExperimentData.DataSeries;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentDataFactory;
import org.palladiosimulator.edp2.models.ExperimentData.Measurement;
import org.palladiosimulator.edp2.models.ExperimentData.MeasurementRange;
import org.palladiosimulator.edp2.models.ExperimentData.RawMeasurements;
import org.palladiosimulator.edp2.models.ExperimentData.Run;
import org.palladiosimulator.edp2.util.MeasurementsUtility;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.recorderframework.AbstractRecorder;
import org.palladiosimulator.recorderframework.config.IRecorderConfiguration;
import org.palladiosimulator.recorderframework.edp2.config.EDP2RecorderConfiguration;

public class EDP2RawRecorder
extends AbstractRecorder {
    private static final ExperimentDataFactory EXPERIMENT_DATA_FACTORY = ExperimentDataFactory.eINSTANCE;
    private EDP2RecorderConfiguration edp2RecorderConfig;
    private Measurement measurement;

    public void initialize(IRecorderConfiguration recorderConfiguration) {
        this.edp2RecorderConfig = (EDP2RecorderConfiguration)recorderConfiguration;
        this.measurement = this.edp2RecorderConfig.getMeasurement();
        this.attachRawMeasurementRangeToMeasurements();
    }

    public void writeData(MeasuringValue data) {
        MeasurementsUtility.storeMeasurement((Measurement)this.measurement, (MeasuringValue)data);
    }

    public void flush() {
        MeasurementRange measurementRange = (MeasurementRange)this.measurement.getMeasurementRanges().get(0);
        Run run = this.measurement.getRun();
        long startTime = run.getStartTime().getTime();
        long endTime = new Date().getTime();
        run.setDuration(Measure.valueOf((long)(endTime - startTime), (Unit)SI.SECOND));
        measurementRange.setStartTime(Measure.valueOf((long)startTime, (Unit)SI.SECOND));
        measurementRange.setEndTime(Measure.valueOf((long)endTime, (Unit)SI.SECOND));
        for (DataSeries ds : measurementRange.getRawMeasurements().getDataSeries()) {
            MeasurementsDao dao = MeasurementsUtility.getMeasurementsDao((DataSeries)ds);
            dao.flush();
        }
    }

    private void attachRawMeasurementRangeToMeasurements() {
        MeasurementRange measurementsRange = EXPERIMENT_DATA_FACTORY.createMeasurementRange(this.measurement);
        RawMeasurements rawMeasurements = EXPERIMENT_DATA_FACTORY.createRawMeasurements(measurementsRange);
        MeasurementsUtility.createDAOsForRawMeasurements((RawMeasurements)rawMeasurements);
    }
}

