/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.recorderframework.edp2.config;

import de.uka.ipd.sdq.identifier.Identifier;
import java.util.HashMap;
import java.util.Map;
import org.palladiosimulator.commons.datastructureutils.MapHelper;
import org.palladiosimulator.edp2.impl.RepositoryManager;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentDataFactory;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentGroup;
import org.palladiosimulator.edp2.models.ExperimentData.Measurement;
import org.palladiosimulator.edp2.models.ExperimentData.MeasuringType;
import org.palladiosimulator.edp2.models.ExperimentData.Run;
import org.palladiosimulator.edp2.models.Repository.Repository;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPointRepository;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.recorderframework.config.AbstractRecorderConfigurationFactory;
import org.palladiosimulator.recorderframework.config.IRecorderConfiguration;
import org.palladiosimulator.recorderframework.edp2.config.EDP2RecorderConfiguration;

public abstract class AbstractEDP2RecorderConfigurationFactory<RUN extends Run>
extends AbstractRecorderConfigurationFactory {
    public static final String REPOSITORY_ID = "EDP2RepositoryID";
    public static final String VARIATION_ID = "variationId";
    protected Repository repository;
    protected ExperimentGroup experimentGroup;
    protected RUN experimentRun;

    public void initialize(Map<String, Object> configuration) {
        super.initialize(configuration);
        this.initializeEDP2Repository((String)MapHelper.getValue(configuration, (String)REPOSITORY_ID, String.class));
        this.initializeExperimentGroup();
    }

    public IRecorderConfiguration createRecorderConfiguration(Map<String, Object> configuration) {
        MetricDescription metricDescription = (MetricDescription)configuration.get("recorderAcceptedMetric");
        this.addMetricDescriptionToRepository(metricDescription);
        MeasuringPoint measuringPoint = (MeasuringPoint)configuration.get("measuringPoint");
        Measurement measurement = this.initializeMeasurements(this.initializeMeasuringType(metricDescription, measuringPoint));
        EDP2RecorderConfiguration result = new EDP2RecorderConfiguration();
        HashMap<String, Object> newConfiguration = new HashMap<String, Object>();
        newConfiguration.putAll(configuration);
        newConfiguration.put("measurement", measurement);
        result.setConfiguration(newConfiguration);
        return result;
    }

    public void finalizeRecorderConfigurationFactory() {
        this.repository.flush();
    }

    private MeasuringType initializeMeasuringType(MetricDescription metricDescription, MeasuringPoint measuringPoint) {
        for (MeasuringType measuringType : this.experimentGroup.getMeasuringTypes()) {
            if (!measuringType.getMetric().equals(metricDescription) || !measuringType.getMeasuringPoint().equals(measuringPoint)) continue;
            return measuringType;
        }
        return this.createMeasuringType(metricDescription, measuringPoint);
    }

    protected MeasuringType createMeasuringType(MetricDescription measureMetric, MeasuringPoint measuringPoint) {
        this.initializeMeasuringPointRepository(measuringPoint);
        MeasuringType measuringType = ExperimentDataFactory.eINSTANCE.createMeasuringType();
        measuringType.setMeasuringPoint(measuringPoint);
        measuringType.setMetric(measureMetric);
        measuringType.setExperimentGroup(this.experimentGroup);
        return measuringType;
    }

    private void initializeMeasuringPointRepository(MeasuringPoint measuringPoint) {
        if (measuringPoint.getMeasuringPointRepository() == null) {
            throw new IllegalArgumentException("Measuring point \"" + measuringPoint + "\" lacks a repository!");
        }
        MeasuringPointRepository measuringPointRepository = measuringPoint.getMeasuringPointRepository();
        for (MeasuringPointRepository repo : this.experimentGroup.getMeasuringPointRepositories()) {
            if (!repo.getId().equals(measuringPointRepository.getId())) continue;
            return;
        }
        this.experimentGroup.getMeasuringPointRepositories().add((Object)measuringPointRepository);
    }

    private Measurement initializeMeasurements(MeasuringType measuringType) {
        Measurement measurements = ExperimentDataFactory.eINSTANCE.createMeasurement();
        measurements.setMeasuringType(measuringType);
        this.experimentRun.getMeasurement().add((Object)measurements);
        return measurements;
    }

    private void initializeEDP2Repository(String repositoryID) {
        this.repository = RepositoryManager.getRepositoryFromUUID((String)repositoryID);
        if (this.repository == null) {
            throw new IllegalArgumentException("The provided EDP2 repository does not exist. Please check your configuration");
        }
    }

    private void initializeExperimentGroup() {
        for (ExperimentGroup group : this.repository.getExperimentGroups()) {
            if (!group.getPurpose().equals(this.getExperimentName())) continue;
            this.experimentGroup = group;
            return;
        }
        this.experimentGroup = ExperimentDataFactory.eINSTANCE.createExperimentGroup();
        this.experimentGroup.setPurpose(this.getExperimentName());
        this.repository.getExperimentGroups().add((Object)this.experimentGroup);
    }

    private MetricDescription addMetricDescriptionToRepository(MetricDescription metricDescription) {
        if (metricDescription.getRepository() != null) {
            return metricDescription;
        }
        for (Identifier identifiable : this.repository.getDescriptions()) {
            if (!identifiable.getId().equals(metricDescription.getId())) continue;
            return (MetricDescription)identifiable;
        }
        this.repository.getDescriptions().add((Object)metricDescription);
        if (metricDescription instanceof MetricSetDescription) {
            for (MetricDescription childMetricDescription : ((MetricSetDescription)metricDescription).getSubsumedMetrics()) {
                this.addMetricDescriptionToRepository(childMetricDescription);
            }
        }
        return metricDescription;
    }
}

