/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.reliability.sensitivity;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FailureDimension implements Enumerator
{
    SOFTWARE(0, "SOFTWARE", "SOFTWARE"),
    HARDWARE(1, "HARDWARE", "HARDWARE"),
    NETWORK(2, "NETWORK", "NETWORK");

    public static final int SOFTWARE_VALUE = 0;
    public static final int HARDWARE_VALUE = 1;
    public static final int NETWORK_VALUE = 2;
    private static final FailureDimension[] VALUES_ARRAY;
    public static final List<FailureDimension> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FailureDimension[]{SOFTWARE, HARDWARE, NETWORK};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FailureDimension get(String literal) {
        FailureDimension[] failureDimensionArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            FailureDimension result = failureDimensionArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static FailureDimension getByName(String name) {
        FailureDimension[] failureDimensionArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            FailureDimension result = failureDimensionArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static FailureDimension get(int value) {
        switch (value) {
            case 0: {
                return SOFTWARE;
            }
            case 1: {
                return HARDWARE;
            }
            case 2: {
                return NETWORK;
            }
        }
        return null;
    }

    private FailureDimension(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

