/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.reliability.helper;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.query.conditions.eobjects.EObjectCondition;
import org.eclipse.emf.query.conditions.eobjects.EObjectTypeRelationCondition;
import org.eclipse.emf.query.conditions.eobjects.TypeRelation;
import org.eclipse.emf.query.statements.FROM;
import org.eclipse.emf.query.statements.IQueryResult;
import org.eclipse.emf.query.statements.SELECT;
import org.eclipse.emf.query.statements.WHERE;
import org.palladiosimulator.pcm.allocation.AllocationPackage;
import org.palladiosimulator.pcm.parameter.ParameterPackage;
import org.palladiosimulator.pcm.repository.RepositoryPackage;
import org.palladiosimulator.pcm.resourceenvironment.ResourceenvironmentPackage;
import org.palladiosimulator.pcm.resourcetype.ResourcetypePackage;
import org.palladiosimulator.pcm.seff.SeffPackage;
import org.palladiosimulator.pcm.system.SystemPackage;
import org.palladiosimulator.pcm.usagemodel.UsagemodelPackage;

public class EMFHelper {
    private static final Logger LOGGER = Logger.getLogger((String)EMFHelper.class.getName());

    public EList<EObject> getElements(EObject root, EClass type) {
        BasicEList resultList = new BasicEList();
        EObjectTypeRelationCondition hasCompatibleType = new EObjectTypeRelationCondition(type, TypeRelation.SAMETYPE_OR_SUBTYPE_LITERAL);
        IQueryResult queryResult = new SELECT(new FROM(root), new WHERE((EObjectCondition)hasCompatibleType)).execute();
        for (Object result : queryResult) {
            resultList.add((Object)((EObject)result));
        }
        return resultList;
    }

    public static void saveToXMIFile(EObject modelToSave, String fileName) {
        LOGGER.debug((Object)("Saving " + modelToSave.toString() + " to " + fileName));
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        URI fileURI = URI.createFileURI((String)new File(fileName).getAbsolutePath());
        Resource resource = resourceSet.createResource(fileURI);
        resource.getContents().add((Object)modelToSave);
        try {
            resource.save(Collections.EMPTY_MAP);
        }
        catch (FileNotFoundException e) {
            if (fileName.length() > 250) {
                EMFHelper.saveToXMIFile(modelToSave, String.valueOf(fileName.substring(0, fileName.indexOf("-"))) + "-shortened-" + fileName.hashCode());
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage());
        }
    }

    public static EObject loadFromXMIFile(String fileName, String eNamespaceURI, EPackage ePackage) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)eNamespaceURI, (Object)ePackage);
        EMFHelper.registerPackages((ResourceSet)resourceSet);
        return EMFHelper.loadXMI(fileName, (ResourceSet)resourceSet);
    }

    public static EObject loadFromXMIFile(String fileName) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        EMFHelper.registerPackages((ResourceSet)resourceSet);
        return EMFHelper.loadXMI(fileName, (ResourceSet)resourceSet);
    }

    private static EObject loadXMI(String fileName, ResourceSet resourceSet) {
        File file = new File(fileName);
        URI uri = file.isFile() ? URI.createFileURI((String)file.getAbsolutePath()) : URI.createURI((String)fileName);
        Resource resource = null;
        try {
            resource = resourceSet.getResource(uri, true);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            return null;
        }
        EObject eObject = (EObject)resource.getContents().iterator().next();
        return EcoreUtil.getRootContainer((EObject)eObject);
    }

    private static void registerPackages(ResourceSet resourceSet) {
        resourceSet.getPackageRegistry().put((Object)"http://palladiosimulator.org/PalladioComponentModel/Allocation/5.1", (Object)AllocationPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://palladiosimulator.org/PalladioComponentModel/Parameter/5.1", (Object)ParameterPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://palladiosimulator.org/PalladioComponentModel/ResourceEnvironment/5.1", (Object)ResourceenvironmentPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://palladiosimulator.org/PalladioComponentModel/ResourceType/5.1", (Object)ResourcetypePackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://palladiosimulator.org/PalladioComponentModel/Repository/5.1", (Object)RepositoryPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://palladiosimulator.org/PalladioComponentModel/SEFF/5.1", (Object)SeffPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://palladiosimulator.org/PalladioComponentModel/System/5.1", (Object)SystemPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://palladiosimulator.org/PalladioComponentModel/UsageModel/5.1", (Object)UsagemodelPackage.eINSTANCE);
    }
}

