/**
 */
package org.palladiosimulator.simulizar.action.core.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.palladiosimulator.simulizar.action.core.util.CoreAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers. The
 * adapters generated by this factory convert EMF adapter notifications into calls to
 * {@link #fireNotifyChanged fireNotifyChanged}. The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances. <!-- begin-user-doc --> <!--
 * end-user-doc -->
 *
 * @generated
 */
public class CoreItemProviderAdapterFactory extends CoreAdapterFactory
        implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
    /**
     * This keeps track of the root adapter factory that delegates to this adapter factory. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ComposedAdapterFactory parentAdapterFactory;

    /**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected IChangeNotifier changeNotifier = new ChangeNotifier();

    /**
     * This keeps track of all the supported types checked by {@link #isFactoryForType
     * isFactoryForType}. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected Collection<Object> supportedTypes = new ArrayList<Object>();

    /**
     * This constructs an instance. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    public CoreItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.simulizar.action.core.AdaptationBehaviorRepository} instances.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected AdaptationBehaviorRepositoryItemProvider adaptationBehaviorRepositoryItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.simulizar.action.core.AdaptationBehaviorRepository}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createAdaptationBehaviorRepositoryAdapter() {
        if (this.adaptationBehaviorRepositoryItemProvider == null) {
            this.adaptationBehaviorRepositoryItemProvider = new AdaptationBehaviorRepositoryItemProvider(this);
        }

        return this.adaptationBehaviorRepositoryItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.simulizar.action.core.AdaptationBehavior} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected AdaptationBehaviorItemProvider adaptationBehaviorItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.simulizar.action.core.AdaptationBehavior}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createAdaptationBehaviorAdapter() {
        if (this.adaptationBehaviorItemProvider == null) {
            this.adaptationBehaviorItemProvider = new AdaptationBehaviorItemProvider(this);
        }

        return this.adaptationBehaviorItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.simulizar.action.core.NestedAdaptationBehavior} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected NestedAdaptationBehaviorItemProvider nestedAdaptationBehaviorItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.simulizar.action.core.NestedAdaptationBehavior}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createNestedAdaptationBehaviorAdapter() {
        if (this.nestedAdaptationBehaviorItemProvider == null) {
            this.nestedAdaptationBehaviorItemProvider = new NestedAdaptationBehaviorItemProvider(this);
        }

        return this.nestedAdaptationBehaviorItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.simulizar.action.core.StateTransformingAction} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected StateTransformingActionItemProvider stateTransformingActionItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.simulizar.action.core.StateTransformingAction}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createStateTransformingActionAdapter() {
        if (this.stateTransformingActionItemProvider == null) {
            this.stateTransformingActionItemProvider = new StateTransformingActionItemProvider(this);
        }

        return this.stateTransformingActionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.simulizar.action.core.EnactAdaptationAction} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected EnactAdaptationActionItemProvider enactAdaptationActionItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.simulizar.action.core.EnactAdaptationAction}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createEnactAdaptationActionAdapter() {
        if (this.enactAdaptationActionItemProvider == null) {
            this.enactAdaptationActionItemProvider = new EnactAdaptationActionItemProvider(this);
        }

        return this.enactAdaptationActionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.simulizar.action.core.ResourceDemandingAction} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ResourceDemandingActionItemProvider resourceDemandingActionItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.simulizar.action.core.ResourceDemandingAction}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createResourceDemandingActionAdapter() {
        if (this.resourceDemandingActionItemProvider == null) {
            this.resourceDemandingActionItemProvider = new ResourceDemandingActionItemProvider(this);
        }

        return this.resourceDemandingActionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.simulizar.action.core.GuardedAction} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected GuardedActionItemProvider guardedActionItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.simulizar.action.core.GuardedAction}. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createGuardedActionAdapter() {
        if (this.guardedActionItemProvider == null) {
            this.guardedActionItemProvider = new GuardedActionItemProvider(this);
        }

        return this.guardedActionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.simulizar.action.core.GuardedTransition} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected GuardedTransitionItemProvider guardedTransitionItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.simulizar.action.core.GuardedTransition}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createGuardedTransitionAdapter() {
        if (this.guardedTransitionItemProvider == null) {
            this.guardedTransitionItemProvider = new GuardedTransitionItemProvider(this);
        }

        return this.guardedTransitionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.simulizar.action.core.RoleType} instances. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected RoleTypeItemProvider roleTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.palladiosimulator.simulizar.action.core.RoleType}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createRoleTypeAdapter() {
        if (this.roleTypeItemProvider == null) {
            this.roleTypeItemProvider = new RoleTypeItemProvider(this);
        }

        return this.roleTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.simulizar.action.core.ControllerCall} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ControllerCallItemProvider controllerCallItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.simulizar.action.core.ControllerCall}. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createControllerCallAdapter() {
        if (this.controllerCallItemProvider == null) {
            this.controllerCallItemProvider = new ControllerCallItemProvider(this);
        }

        return this.controllerCallItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    /**
     * This sets the composed adapter factory that contains this factory. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void setParentAdapterFactory(final ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public boolean isFactoryForType(final Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    /**
     * This implementation substitutes the factory itself as the key for the adapter. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter adapt(final Notifier notifier, final Object type) {
        return super.adapt(notifier, this);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Object adapt(final Object object, final Object type) {
        if (this.isFactoryForType(type)) {
            final Object adapter = super.adapt(object, type);
            if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter))) {
                return adapter;
            }
        }

        return null;
    }

    /**
     * This adds a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void addListener(final INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    /**
     * This removes a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void removeListener(final INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    /**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void fireNotifyChanged(final Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);

        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    /**
     * This disposes all of the item providers created by this factory. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    @Override
    public void dispose() {
        if (this.adaptationBehaviorRepositoryItemProvider != null) {
            this.adaptationBehaviorRepositoryItemProvider.dispose();
        }
        if (this.adaptationBehaviorItemProvider != null) {
            this.adaptationBehaviorItemProvider.dispose();
        }
        if (this.nestedAdaptationBehaviorItemProvider != null) {
            this.nestedAdaptationBehaviorItemProvider.dispose();
        }
        if (this.stateTransformingActionItemProvider != null) {
            this.stateTransformingActionItemProvider.dispose();
        }
        if (this.enactAdaptationActionItemProvider != null) {
            this.enactAdaptationActionItemProvider.dispose();
        }
        if (this.resourceDemandingActionItemProvider != null) {
            this.resourceDemandingActionItemProvider.dispose();
        }
        if (this.guardedActionItemProvider != null) {
            this.guardedActionItemProvider.dispose();
        }
        if (this.guardedTransitionItemProvider != null) {
            this.guardedTransitionItemProvider.dispose();
        }
        if (this.roleTypeItemProvider != null) {
            this.roleTypeItemProvider.dispose();
        }
        if (this.controllerCallItemProvider != null) {
            this.controllerCallItemProvider.dispose();
        }
    }

}
