/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.reconfiguration.qvto;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.util.Log;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementModel;
import org.palladiosimulator.runtimemeasurement.util.RuntimeMeasurementSwitch;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOReconfigurationLogger;
import org.palladiosimulator.simulizar.reconfiguration.qvto.util.QVToModelCache;
import org.palladiosimulator.simulizar.reconfiguration.qvto.util.TransformationCache;
import org.palladiosimulator.simulizar.reconfiguration.qvto.util.TransformationData;
import org.palladiosimulator.simulizar.reconfiguration.qvto.util.TransformationParameterInformation;

public abstract class AbstractQVTOExecutor {
    private static final Logger LOGGER = Logger.getLogger(AbstractQVTOExecutor.class);
    private final TransformationCache transformationCache;
    private final QVToModelCache availableModels;
    private static final RuntimeMeasurementSwitch<ModelExtent> CREATE_NON_EMPTY_MODEL_EXTENT_SWITCH = new RuntimeMeasurementSwitch<ModelExtent>(){

        public ModelExtent caseRuntimeMeasurementModel(RuntimeMeasurementModel runtimeMeasurementModel) {
            return new BasicModelExtent((List)runtimeMeasurementModel.getMeasurements());
        }

        public ModelExtent defaultCase(EObject model) {
            BasicModelExtent result = new BasicModelExtent();
            result.add(model);
            return result;
        }
    };

    protected AbstractQVTOExecutor(TransformationCache knownTransformations, QVToModelCache knownModels) {
        this.transformationCache = Objects.requireNonNull(knownTransformations);
        this.availableModels = Objects.requireNonNull(knownModels);
    }

    protected TransformationCache getAvailableTransformations() {
        return this.transformationCache;
    }

    protected QVToModelCache getAvailableModels() {
        return this.availableModels;
    }

    public boolean executeTransformation(URI transformationURI) {
        Optional<TransformationData> data = this.transformationCache.get(Objects.requireNonNull(transformationURI));
        return this.executeTransformation(data.orElseThrow(() -> new IllegalArgumentException("Given transformation not present in transformation cache.")));
    }

    protected final boolean executeTransformation(TransformationData transformationData) {
        ModelExtent[] modelExtents = this.setupModelExtents(Objects.requireNonNull(transformationData));
        ExecutionContext executionContext = this.setupExecutionContext();
        ExecutionDiagnostic result = this.doExecution(transformationData, executionContext, modelExtents);
        return this.handleExecutionResult(result);
    }

    protected final ExecutionDiagnostic doExecution(TransformationData data, ExecutionContext context, ModelExtent[] params) {
        return data.getTransformationExecutor().execute(context, params);
    }

    protected boolean handleExecutionResult(ExecutionDiagnostic executionResult) {
        if (executionResult.getSeverity() == 0) {
            LOGGER.log((Priority)Level.DEBUG, (Object)("Rule successfully executed with message: " + executionResult.getMessage()));
            return true;
        }
        LOGGER.log((Priority)Level.WARN, (Object)("Rule application failed with message: " + executionResult.getMessage()));
        return false;
    }

    protected ExecutionContext setupExecutionContext() {
        ExecutionContextImpl result = new ExecutionContextImpl();
        result.setLog(this.createLog());
        return result;
    }

    protected Log createLog() {
        return new QVTOReconfigurationLogger(this.getClass());
    }

    protected ModelExtent[] setupModelExtents(TransformationData transformationData) {
        assert (transformationData != null && transformationData.getTransformationExecutor() != null);
        ModelExtent[] modelExtents = new ModelExtent[transformationData.getParameterCount()];
        for (TransformationParameterInformation inParams : transformationData.getInParameters()) {
            EObject sourceModel = this.availableModels.getModelByType(inParams.getParameterType()).orElseThrow(() -> new IllegalStateException("No model in QVTo model cache for " + (inParams.getParameterIndex() + 1) + ". parameter of transformation '" + transformationData.getTransformationName() + "'"));
            modelExtents[inParams.getParameterIndex()] = (ModelExtent)CREATE_NON_EMPTY_MODEL_EXTENT_SWITCH.doSwitch(sourceModel);
        }
        transformationData.getPureOutParameters().stream().mapToInt(TransformationParameterInformation::getParameterIndex).forEach(index -> {
            BasicModelExtent basicModelExtent = new BasicModelExtent();
        });
        return modelExtents;
    }
}

