/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.reconfiguration.qvto;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.commons.eclipseutils.FileHelper;
import org.palladiosimulator.simulizar.access.IModelAccess;
import org.palladiosimulator.simulizar.reconfiguration.AbstractReconfigurator;
import org.palladiosimulator.simulizar.reconfiguration.IReconfigurator;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOExecutor;
import org.palladiosimulator.simulizar.reconfiguration.qvto.util.QVToModelCache;
import org.palladiosimulator.simulizar.reconfiguration.qvto.util.TransformationCache;
import org.palladiosimulator.simulizar.runconfig.SimuLizarWorkflowConfiguration;

public class QVTOReconfigurator
extends AbstractReconfigurator
implements IReconfigurator {
    private static final Logger LOGGER = Logger.getLogger(QVTOReconfigurator.class);
    private static final String QVTO_FILE_EXTENSION = ".qvto";
    private QVTOExecutor qvtoExecutor;

    public QVTOReconfigurator() {
    }

    public QVTOReconfigurator(IModelAccess modelAccessFactory, SimuLizarWorkflowConfiguration configuration) {
    }

    public boolean checkAndExecute(EObject monitoredElement) {
        LOGGER.debug((Object)"Checking reconfiguration rules due to PRM change");
        boolean result = this.getQVTOExecutor().executeRules(monitoredElement);
        LOGGER.debug((Object)(result ? "Reconfigured system by a matching rule" : "No reconfiguration rule was executed, all conditions were false"));
        return result;
    }

    private QVTOExecutor getQVTOExecutor() {
        if (this.qvtoExecutor == null) {
            TransformationCache transformationCache = new TransformationCache(QVTOReconfigurator.getQvtoFiles(this.configuration.getReconfigurationRulesFolder()));
            this.qvtoExecutor = new QVTOExecutor(transformationCache, new QVToModelCache(this.modelAccessFactory));
        }
        return this.qvtoExecutor;
    }

    private static URI[] getQvtoFiles(String path) {
        assert (path != null);
        if (path.equals("")) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"No path to QVTo rules given.");
            }
            return new URI[0];
        }
        URI[] uris = FileHelper.getURIs((String)path, (String)QVTO_FILE_EXTENSION);
        if (uris.length == 0) {
            LOGGER.info((Object)"No QVTo rules found, QVTo reconfigurations disabled.");
        }
        return uris;
    }
}

