/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.reconfiguration.qvto.util;

import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreSwitch;
import org.palladiosimulator.analyzer.workflow.jobs.PreparePCMBlackboardPartitionJob;
import org.palladiosimulator.commons.eclipseutils.ExtensionHelper;
import org.palladiosimulator.metricspec.MetricSpecPackage;
import org.palladiosimulator.pcm.resourcetype.ResourcetypePackage;
import org.palladiosimulator.simulizar.access.IModelAccess;

public class QVToModelCache {
    private final Map<EPackage, EObject> cache = new HashMap<EPackage, EObject>();
    private final IModelAccess modelAccess;
    private static final EClass[] MODEL_ECLASS_BLACKLIST = new EClass[]{ResourcetypePackage.Literals.RESOURCE_REPOSITORY, MetricSpecPackage.Literals.METRIC_DESCRIPTION_REPOSITORY};
    private static final EcoreSwitch<EPackage> MODELTYPE_RETRIEVER = new EcoreSwitch<EPackage>(){

        public EPackage caseEPackage(EPackage ePackage) {
            return ePackage;
        }

        public EPackage caseEClass(EClass eClass) {
            return (EPackage)this.doSwitch(eClass.eContainer());
        }

        public EPackage defaultCase(EObject eObject) {
            return (EPackage)this.doSwitch((EObject)eObject.eClass());
        }
    };

    public QVToModelCache(IModelAccess modelAccess) {
        this.modelAccess = Objects.requireNonNull(modelAccess, "modelAccess must not be null.");
        this.storeBlackboardModels();
    }

    private QVToModelCache(QVToModelCache from) {
        this.modelAccess = from.modelAccess;
        this.cache.putAll(from.cache);
    }

    public void storeModel(EObject modelInstance) {
        if (modelInstance != null) {
            EPackage metaModel = (EPackage)MODELTYPE_RETRIEVER.doSwitch(modelInstance);
            this.cache.put(metaModel, modelInstance);
        }
    }

    public final void storeModelFromBlackboardPartition(String partitionId) {
        EList resources;
        ResourceSetPartition partition;
        MDSDBlackboard blackboard = this.modelAccess.getBlackboard();
        if (blackboard.hasPartition(Objects.requireNonNull(partitionId, "partitionId must not be null.")) && (partition = (ResourceSetPartition)blackboard.getPartition(partitionId)) != null && !(resources = partition.getResourceSet().getResources()).isEmpty()) {
            EObject currentModel = (EObject)((Resource)resources.get(0)).getContents().get(0);
            this.storeModel(currentModel);
        }
    }

    public void removeModelOfType(EPackage metaModel) {
        if (metaModel != null) {
            this.cache.remove(metaModel);
        }
    }

    public void removeModel(EObject model) {
        if (model != null && this.cache.containsValue(model)) {
            this.removeModelOfType((EPackage)MODELTYPE_RETRIEVER.doSwitch(model));
        }
    }

    public void clear() {
        this.cache.clear();
    }

    public QVToModelCache snapshot() {
        return new QVToModelCache(this);
    }

    public Optional<EObject> getModelByType(EPackage ePackage) {
        String namespace = Objects.requireNonNull(ePackage.getNsURI());
        return this.cache.keySet().stream().filter(key -> key.getNsURI().equals(namespace)).findAny().map(this.cache::get);
    }

    public boolean containsModelOfType(EPackage ePackage) {
        return this.cache.containsKey(Objects.requireNonNull(ePackage));
    }

    private void storeBlackboardModels() {
        assert (this.modelAccess != null);
        this.storeModel((EObject)this.modelAccess.getRuntimeMeasurementModel());
        this.modelAccess.getGlobalPCMModel().getResourceSet().getResources().stream().map(Resource::getContents).filter(contents -> !contents.isEmpty() && !QVToModelCache.isBlacklisted((EObject)contents.get(0))).forEach(contents -> this.storeModel((EObject)contents.get(0)));
        ExtensionHelper.getAttributes((String)"org.palladiosimulator.simulizar.launcher.modelload", (String)"loadJob", (String)"blackboardPartitionId").forEach(this::storeModelFromBlackboardPartition);
    }

    private static boolean isBlacklisted(EObject model) {
        assert (model != null);
        return model.eResource().getURI().equals(PreparePCMBlackboardPartitionJob.PCM_PALLADIO_PRIMITIVE_TYPE_REPOSITORY_URI) || Arrays.stream(MODEL_ECLASS_BLACKLIST).anyMatch(bannedEClass -> bannedEClass == model.eClass());
    }
}

