/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.reconfiguration.qvto.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.palladiosimulator.simulizar.reconfiguration.qvto.util.TransformationData;
import org.palladiosimulator.simulizar.reconfiguration.qvto.util.TransformationDataFactory;

public class TransformationCache {
    private final Map<URI, TransformationData> cache = new HashMap<URI, TransformationData>();
    private final TransformationDataFactory transformationDataFactory;
    private static final Logger LOGGER = Logger.getLogger(TransformationCache.class);

    @SafeVarargs
    public TransformationCache(URI ... initialTransformations) {
        this.transformationDataFactory = new TransformationDataFactory();
        this.store(initialTransformations);
    }

    private TransformationCache(TransformationCache from) {
        this.cache.putAll(from.cache);
        this.transformationDataFactory = from.transformationDataFactory;
    }

    public TransformationCache snapshot() {
        return new TransformationCache(this);
    }

    @SafeVarargs
    public final void store(URI ... transformationUris) {
        URI[] uris;
        URI[] uRIArray = uris = Objects.requireNonNull(transformationUris);
        int n = uris.length;
        int n2 = 0;
        while (n2 < n) {
            URI transformationUri = uRIArray[n2];
            if (this.contains(transformationUri)) {
                throw new IllegalArgumentException("Transformation " + transformationUri + " already in store.");
            }
            LOGGER.info((Object)("Cache reconfiguration rule \"" + transformationUri + "\""));
            this.cache.put(transformationUri, this.transformationDataFactory.createTransformationData(transformationUri));
            ++n2;
        }
    }

    @SafeVarargs
    public final void remove(URI ... transformationUris) {
        URI[] uris = Objects.requireNonNull(transformationUris);
        Arrays.stream(uris).map(Objects::requireNonNull).forEach(this.cache::remove);
    }

    public Optional<TransformationData> get(URI transformationUri) {
        return Optional.ofNullable(this.cache.get(Objects.requireNonNull(transformationUri)));
    }

    public boolean contains(URI transformationUri) {
        return this.cache.containsKey(Objects.requireNonNull(transformationUri));
    }

    public Iterable<TransformationData> getAll() {
        return this.cache.values();
    }

    public void clear() {
        this.cache.clear();
    }
}

