/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.reconfiguration.qvto.util;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.m2m.qvt.oml.TransformationExecutor;
import org.palladiosimulator.simulizar.reconfiguration.qvto.util.TransformationParameterInformation;

public final class TransformationData {
    private final OperationalTransformation associatedTransformation;
    private final TransformationExecutor transformationExecutor;
    private final Collection<TransformationParameterInformation> inParams;
    private final Collection<TransformationParameterInformation> outParams;

    TransformationData(OperationalTransformation transformation, TransformationExecutor executor, Collection<TransformationParameterInformation> paramInfo) {
        this.associatedTransformation = transformation;
        this.transformationExecutor = executor;
        Map<Boolean, List<TransformationParameterInformation>> partitionedParams = paramInfo.stream().collect(Collectors.partitioningBy(TransformationParameterInformation::isOutParameter));
        this.inParams = Collections.unmodifiableCollection(partitionedParams.getOrDefault(Boolean.FALSE, Collections.emptyList()));
        this.outParams = Collections.unmodifiableCollection(partitionedParams.getOrDefault(Boolean.TRUE, Collections.emptyList()));
    }

    public int getParameterCount() {
        return this.inParams.size() + this.outParams.size();
    }

    public Collection<TransformationParameterInformation> getPureOutParameters() {
        return this.outParams;
    }

    public Collection<TransformationParameterInformation> getInParameters() {
        return this.inParams;
    }

    public String getTransformationName() {
        return this.associatedTransformation.getName();
    }

    public TransformationExecutor getTransformationExecutor() {
        return this.transformationExecutor;
    }
}

