/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.reconfiguration.storydiagram;

import de.mdelab.sdm.interpreter.core.SDMException;
import de.mdelab.sdm.interpreter.core.notifications.NotificationReceiver;
import de.mdelab.sdm.interpreter.core.notifications.OutputStreamNotificationReceiver;
import de.mdelab.sdm.interpreter.core.variables.Variable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.palladiosimulator.analyzer.workflow.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.pcm.allocation.AllocationPackage;
import org.palladiosimulator.pcm.repository.RepositoryPackage;
import org.palladiosimulator.pcm.resourceenvironment.ResourceenvironmentPackage;
import org.palladiosimulator.pcm.system.SystemPackage;
import org.palladiosimulator.pcm.usagemodel.UsagemodelPackage;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementModel;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementPackage;
import org.palladiosimulator.simulizar.reconfiguration.storydiagram.ActivityLoader;
import org.palladiosimulator.simulizar.reconfiguration.storydiagram.SDReconfigurationNotificationReceiver;
import org.palladiosimulator.simulizar.reconfiguration.storydiagram.modelaccess.StoryDiagramModelAccess;
import org.storydriven.core.expressions.Expression;
import org.storydriven.storydiagrams.activities.Activity;
import org.storydriven.storydiagrams.activities.ActivityEdge;
import org.storydriven.storydiagrams.activities.ActivityNode;
import org.storydriven.storydiagrams.interpreter.eclipse.StoryDrivenEclipseInterpreter;
import org.storydriven.storydiagrams.patterns.AbstractLinkVariable;
import org.storydriven.storydiagrams.patterns.AbstractVariable;
import org.storydriven.storydiagrams.patterns.StoryPattern;

public class SDExecutor {
    private static final Logger LOGGER = Logger.getLogger(SDExecutor.class);
    private static final EClass EOBJECT_ECLASS = EcorePackage.eINSTANCE.getEObject();
    private static final String MONITORED_ELEMENT = "monitoredElement";
    private static final EClass PALLADIO_RUNTIME_MEASUREMENT_MODEL_ECLASS = RuntimeMeasurementPackage.eINSTANCE.getRuntimeMeasurementModel();
    private static final EClass RESOURCE_ENVIRONMENT_MODEL_ECLASS = ResourceenvironmentPackage.eINSTANCE.getResourceEnvironment();
    private static final EClass ALLOCATION_MODEL_ECLASS = AllocationPackage.eINSTANCE.getAllocation();
    private static final EClass REPOSITORY_MODEL_ECLASS = RepositoryPackage.eINSTANCE.getRepository();
    private static final EClass SYSTEM_MODEL_ECLASS = SystemPackage.eINSTANCE.getSystem();
    private static final EClass USAGE_MODEL_ECLASS = UsagemodelPackage.eINSTANCE.getUsageModel();
    private static final String PRM_MODEL = "runtimeMeasurementModel";
    private static final String RESOURCE_ENVIRONMENT_MODEL = "resourceEnvironmentModel";
    private static final String ALLOCATION_MODEL = "allocationModel";
    private static final String REPOSITORY_MODEL = "repositoryModel";
    private static final String SYSTEM_MODEL = "systemModel";
    private static final String RETURN_VALUE = "returnValue";
    private static final EClass BOOLEAN_ECLASS = EcorePackage.eINSTANCE.getEBoolean().eClass();
    private static final String USAGE_MODEL = "usageModel";
    private final List<Variable<EClassifier>> staticParameters;
    private final Collection<Activity> activities;
    private final StoryDrivenEclipseInterpreter sdmInterpreter;
    private final Collection<Activity> storyDiagrams;
    private final PCMResourceSetPartition globalPcmResourceSetPartition;
    private final RuntimeMeasurementModel runtimeMeasurementModel;
    private final SDReconfigurationNotificationReceiver<Activity, ActivityNode, ActivityEdge, StoryPattern, AbstractVariable, AbstractLinkVariable, EClassifier, EStructuralFeature, Expression> sdNotificationReceiver;

    public SDExecutor(StoryDiagramModelAccess modelAccessFactory) {
        this.storyDiagrams = modelAccessFactory.getStoryDiagrams();
        this.globalPcmResourceSetPartition = modelAccessFactory.getGlobalPCMModel();
        this.runtimeMeasurementModel = modelAccessFactory.getRuntimeMeasurementModel();
        try {
            this.sdmInterpreter = new StoryDrivenEclipseInterpreter(this.getClass().getClassLoader());
        }
        catch (SDMException e) {
            throw new RuntimeException("Unable to inialise SD interpreter engine", e);
        }
        this.sdNotificationReceiver = new SDReconfigurationNotificationReceiver(this.sdmInterpreter.getFacadeFactory());
        this.sdmInterpreter.getNotificationEmitter().addNotificationReceiver(this.sdNotificationReceiver);
        if (LOGGER.isDebugEnabled()) {
            this.sdmInterpreter.getNotificationEmitter().addNotificationReceiver((NotificationReceiver)new OutputStreamNotificationReceiver(this.sdmInterpreter.getFacadeFactory()));
        }
        this.staticParameters = this.createParameter();
        this.activities = this.createBindingsForActivities();
    }

    private Collection<Activity> createBindingsForActivities() {
        Collection<Activity> ActivitiesFromModels = this.storyDiagrams;
        LinkedList<Activity> result = new LinkedList<Activity>();
        for (Activity activity : ActivitiesFromModels) {
            Activity activityWithBindings = ActivityLoader.createBindings(activity, new String[]{USAGE_MODEL, SYSTEM_MODEL, REPOSITORY_MODEL, ALLOCATION_MODEL, RESOURCE_ENVIRONMENT_MODEL, PRM_MODEL, MONITORED_ELEMENT}, new EClassifier[]{USAGE_MODEL_ECLASS, SYSTEM_MODEL_ECLASS, REPOSITORY_MODEL_ECLASS, ALLOCATION_MODEL_ECLASS, RESOURCE_ENVIRONMENT_MODEL_ECLASS, PALLADIO_RUNTIME_MEASUREMENT_MODEL_ECLASS, EOBJECT_ECLASS});
            result.add(activityWithBindings);
        }
        return result;
    }

    private List<Variable<EClassifier>> createParameter() {
        ArrayList<Variable<EClassifier>> parameters = new ArrayList<Variable<EClassifier>>();
        Variable usageModelParameter = new Variable(USAGE_MODEL, (Object)USAGE_MODEL_ECLASS, (Object)this.globalPcmResourceSetPartition.getUsageModel());
        Variable systemModelParameter = new Variable(SYSTEM_MODEL, (Object)SYSTEM_MODEL_ECLASS, (Object)this.globalPcmResourceSetPartition.getAllocation().getSystem_Allocation());
        Variable allocationModelParameter = new Variable(ALLOCATION_MODEL, (Object)ALLOCATION_MODEL_ECLASS, (Object)this.globalPcmResourceSetPartition.getAllocation());
        Variable resourceEnvironmentModelParameter = new Variable(RESOURCE_ENVIRONMENT_MODEL, (Object)RESOURCE_ENVIRONMENT_MODEL_ECLASS, (Object)this.globalPcmResourceSetPartition.getAllocation().getTargetResourceEnvironment_Allocation());
        Variable prmModelParameter = new Variable(PRM_MODEL, (Object)PALLADIO_RUNTIME_MEASUREMENT_MODEL_ECLASS, (Object)this.runtimeMeasurementModel);
        parameters.add(usageModelParameter);
        parameters.add(systemModelParameter);
        parameters.add(allocationModelParameter);
        parameters.add(resourceEnvironmentModelParameter);
        parameters.add(prmModelParameter);
        return parameters;
    }

    private boolean execute(Activity activity, List<Variable<EClassifier>> parameters) throws SDMException {
        this.sdNotificationReceiver.reset();
        Map result = this.sdmInterpreter.executeActivity((Object)activity, parameters);
        return this.sdNotificationReceiver.applicationSuccessful();
    }

    public boolean executeActivities(EObject monitoredElement) {
        EObject returnvalue = EcoreFactory.eINSTANCE.create(BOOLEAN_ECLASS);
        Variable monitoredElementParameter = new Variable(MONITORED_ELEMENT, (Object)EOBJECT_ECLASS, (Object)monitoredElement);
        Variable returnValueParameter = new Variable(RETURN_VALUE, (Object)BOOLEAN_ECLASS, (Object)returnvalue);
        ArrayList<Variable<EClassifier>> paramterList = new ArrayList<Variable<EClassifier>>();
        paramterList.addAll(this.staticParameters);
        paramterList.add(monitoredElementParameter);
        paramterList.add(returnValueParameter);
        boolean result = false;
        for (Activity activity : this.activities) {
            try {
                LOGGER.debug((Object)("Trying to execute Story Diagram " + activity.getName() + "."));
                result |= this.execute(activity, paramterList);
            }
            catch (SDMException e) {
                LOGGER.error((Object)"SD failed", (Throwable)e);
                throw new RuntimeException("SD interpretation failed", e);
            }
        }
        return result;
    }
}

