/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.reconfiguration.storydiagram.modelaccess;

import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.palladiosimulator.analyzer.workflow.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.monitorrepository.MonitorRepository;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementModel;
import org.palladiosimulator.simulizar.access.IModelAccess;
import org.palladiosimulator.simulizar.reconfiguration.storydiagram.jobs.LoadSDMModelsIntoBlackboardJob;
import org.palladiosimulator.simulizar.reconfiguration.storydiagram.modelaccess.SDMResourceSetPartition;
import org.palladiosimulator.simulizar.runconfig.SimuLizarWorkflowConfiguration;
import org.scaledl.usageevolution.UsageEvolution;
import org.storydriven.storydiagrams.activities.Activity;

public class StoryDiagramModelAccess
implements IModelAccess {
    private static final Logger LOGGER = Logger.getLogger(StoryDiagramModelAccess.class);
    private final SDMResourceSetPartition sdmPartition;
    private final IModelAccess modelAccess;

    public StoryDiagramModelAccess(IModelAccess modelAccess, SimuLizarWorkflowConfiguration configuration) {
        this.modelAccess = modelAccess;
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            LoadSDMModelsIntoBlackboardJob loadSDMModelsJob = new LoadSDMModelsIntoBlackboardJob(configuration);
            loadSDMModelsJob.setBlackboard(this.modelAccess.getBlackboard());
            loadSDMModelsJob.execute((IProgressMonitor)monitor);
        }
        catch (JobFailedException e) {
            LOGGER.error((Object)"Failed loading StoryDiagram reconfiguration rules into Blackboard.", (Throwable)e);
        }
        catch (UserCanceledException e) {
            LOGGER.error((Object)"Loading StoryDiagram reconfiguration rules into Blackboard was aborted.", (Throwable)e);
        }
        this.sdmPartition = (SDMResourceSetPartition)((Object)this.getResourceSetPartition(modelAccess.getBlackboard(), "org.palladiosimulator.simulizar.reconfiguration.sdm"));
    }

    public List<Activity> getStoryDiagrams() {
        if (this.sdmPartition != null) {
            return this.sdmPartition.getActivities();
        }
        return new LinkedList<Activity>();
    }

    private <T extends ResourceSetPartition> T getResourceSetPartition(MDSDBlackboard blackboard, String id) {
        return (T)((ResourceSetPartition)blackboard.getPartition(id));
    }

    public boolean sdmModelsExists() {
        return this.sdmPartition.getResourceSet().getResources().size() > 0;
    }

    public PCMResourceSetPartition getLocalPCMModel() {
        return this.modelAccess.getLocalPCMModel();
    }

    public PCMResourceSetPartition getGlobalPCMModel() {
        return this.modelAccess.getGlobalPCMModel();
    }

    public MonitorRepository getMonitorRepositoryModel() {
        return this.modelAccess.getMonitorRepositoryModel();
    }

    public RuntimeMeasurementModel getRuntimeMeasurementModel() {
        return this.modelAccess.getRuntimeMeasurementModel();
    }

    public UsageEvolution getUsageEvolutionModel() {
        return this.modelAccess.getUsageEvolutionModel();
    }

    public IModelAccess clone() {
        return this.modelAccess.clone();
    }

    public MDSDBlackboard getBlackboard() {
        return this.modelAccess.getBlackboard();
    }
}

