/**
 */
package org.palladiosimulator.solver.lqn.provider;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.palladiosimulator.solver.lqn.LqnPackage;
import org.palladiosimulator.solver.lqn.MvaInfoType;

/**
 * This is the item provider adapter for a {@link org.palladiosimulator.solver.lqn.MvaInfoType} object.
 * <!-- begin-user-doc --> <!-- end-user-doc -->
 * @generated
 */
public class MvaInfoTypeItemProvider extends ItemProviderAdapter implements
		IEditingDomainItemProvider, IStructuredItemContentProvider,
		ITreeItemContentProvider, IItemLabelProvider, IItemPropertySource {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	public MvaInfoTypeItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addCorePropertyDescriptor(object);
			addFaultsPropertyDescriptor(object);
			addStepPropertyDescriptor(object);
			addStepSquaredPropertyDescriptor(object);
			addSubmodelsPropertyDescriptor(object);
			addWaitPropertyDescriptor(object);
			addWaitSquaredPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Core feature.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected void addCorePropertyDescriptor(Object object) {
		itemPropertyDescriptors
				.add(createItemPropertyDescriptor(
						((ComposeableAdapterFactory) adapterFactory)
								.getRootAdapterFactory(),
						getResourceLocator(),
						getString("_UI_MvaInfoType_core_feature"),
						getString("_UI_PropertyDescriptor_description",
								"_UI_MvaInfoType_core_feature",
								"_UI_MvaInfoType_type"),
						LqnPackage.Literals.MVA_INFO_TYPE__CORE, true, false,
						false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
						null, null));
	}

	/**
	 * This adds a property descriptor for the Faults feature.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected void addFaultsPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_MvaInfoType_faults_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_MvaInfoType_faults_feature",
						"_UI_MvaInfoType_type"),
				LqnPackage.Literals.MVA_INFO_TYPE__FAULTS, true, false, false,
				ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the Step feature.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected void addStepPropertyDescriptor(Object object) {
		itemPropertyDescriptors
				.add(createItemPropertyDescriptor(
						((ComposeableAdapterFactory) adapterFactory)
								.getRootAdapterFactory(),
						getResourceLocator(),
						getString("_UI_MvaInfoType_step_feature"),
						getString("_UI_PropertyDescriptor_description",
								"_UI_MvaInfoType_step_feature",
								"_UI_MvaInfoType_type"),
						LqnPackage.Literals.MVA_INFO_TYPE__STEP, true, false,
						false, ItemPropertyDescriptor.REAL_VALUE_IMAGE, null,
						null));
	}

	/**
	 * This adds a property descriptor for the Step Squared feature.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected void addStepSquaredPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_MvaInfoType_stepSquared_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_MvaInfoType_stepSquared_feature",
						"_UI_MvaInfoType_type"),
				LqnPackage.Literals.MVA_INFO_TYPE__STEP_SQUARED, true, false,
				false, ItemPropertyDescriptor.REAL_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the Submodels feature.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected void addSubmodelsPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_MvaInfoType_submodels_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_MvaInfoType_submodels_feature",
						"_UI_MvaInfoType_type"),
				LqnPackage.Literals.MVA_INFO_TYPE__SUBMODELS, true, false,
				false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the Wait feature.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected void addWaitPropertyDescriptor(Object object) {
		itemPropertyDescriptors
				.add(createItemPropertyDescriptor(
						((ComposeableAdapterFactory) adapterFactory)
								.getRootAdapterFactory(),
						getResourceLocator(),
						getString("_UI_MvaInfoType_wait_feature"),
						getString("_UI_PropertyDescriptor_description",
								"_UI_MvaInfoType_wait_feature",
								"_UI_MvaInfoType_type"),
						LqnPackage.Literals.MVA_INFO_TYPE__WAIT, true, false,
						false, ItemPropertyDescriptor.REAL_VALUE_IMAGE, null,
						null));
	}

	/**
	 * This adds a property descriptor for the Wait Squared feature.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected void addWaitSquaredPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_MvaInfoType_waitSquared_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_MvaInfoType_waitSquared_feature",
						"_UI_MvaInfoType_type"),
				LqnPackage.Literals.MVA_INFO_TYPE__WAIT_SQUARED, true, false,
				false, ItemPropertyDescriptor.REAL_VALUE_IMAGE, null, null));
	}

	/**
	 * This returns MvaInfoType.gif.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object getImage(Object object) {
		return overlayImage(object,
				getResourceLocator().getImage("full/obj16/MvaInfoType"));
	}

	/**
	 * This returns the label text for the adapted class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @generated
	 */
	@Override
	public String getText(Object object) {
		BigInteger labelValue = ((MvaInfoType) object).getCore();
		String label = labelValue == null ? null : labelValue.toString();
		return label == null || label.length() == 0 ? getString("_UI_MvaInfoType_type")
				: getString("_UI_MvaInfoType_type") + " " + label;
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(MvaInfoType.class)) {
		case LqnPackage.MVA_INFO_TYPE__CORE:
		case LqnPackage.MVA_INFO_TYPE__FAULTS:
		case LqnPackage.MVA_INFO_TYPE__STEP:
		case LqnPackage.MVA_INFO_TYPE__STEP_SQUARED:
		case LqnPackage.MVA_INFO_TYPE__SUBMODELS:
		case LqnPackage.MVA_INFO_TYPE__WAIT:
		case LqnPackage.MVA_INFO_TYPE__WAIT_SQUARED:
			fireNotifyChanged(new ViewerNotification(notification,
					notification.getNotifier(), false, true));
			return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s describing the children
	 * that can be created under this object.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(
			Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);
	}

	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator() {
		return LqnEditPlugin.INSTANCE;
	}

}
