/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.spa.basicsolver;

import de.uka.ipd.sdq.probfunction.math.IProbabilityFunctionFactory;
import de.uka.ipd.sdq.probfunction.math.IProbabilityMassFunction;
import de.uka.ipd.sdq.probfunction.math.ManagedPDF;
import de.uka.ipd.sdq.probfunction.math.exception.ConfigurationNotSetException;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.solver.spa.basicsolver.operations.RUPerformanceOps;
import org.palladiosimulator.solver.spa.expression.Acquire;
import org.palladiosimulator.solver.spa.expression.Alternative;
import org.palladiosimulator.solver.spa.expression.Expression;
import org.palladiosimulator.solver.spa.expression.Loop;
import org.palladiosimulator.solver.spa.expression.Parallel;
import org.palladiosimulator.solver.spa.expression.Release;
import org.palladiosimulator.solver.spa.expression.Sequence;
import org.palladiosimulator.solver.spa.expression.Symbol;
import org.palladiosimulator.solver.spa.expression.util.ExpressionSwitch;
import org.palladiosimulator.solver.spa.resourcemodel.ActiveResource;
import org.palladiosimulator.solver.spa.resourcemodel.ResourceUsage;

public class PerformanceSolver {
    private final IProbabilityFunctionFactory pfFactory = IProbabilityFunctionFactory.eINSTANCE;
    private final RUPerformanceOps performanceOps;
    private final ExpressionSwitch exprSwitch = new ExpressionSwitch(){

        public Object caseAcquire(Acquire object) {
            System.err.println("Acquire ignored in performance computation!");
            return super.caseAcquire(object);
        }

        public Object caseAlternative(Alternative object) {
            Hashtable leftRUs = (Hashtable)this.doSwitch((EObject)object.getLeftOption().getRegexp());
            Hashtable rightRUs = (Hashtable)this.doSwitch((EObject)object.getRightOption().getRegexp());
            double leftProb = object.getLeftOption().getProbability();
            double rightProb = object.getRightOption().getProbability();
            return PerformanceSolver.this.performanceOps.computeAlternative(leftRUs, leftProb, rightRUs, rightProb);
        }

        public Object caseLoop(Loop loop) {
            Hashtable innerRUs = (Hashtable)this.doSwitch((EObject)loop.getRegExp());
            IProbabilityMassFunction iterations = PerformanceSolver.this.pfFactory.transformToPMF(loop.getIterationsPMF());
            try {
                return PerformanceSolver.this.performanceOps.computeIteration(innerRUs, iterations);
            }
            catch (ConfigurationNotSetException e) {
                e.printStackTrace();
                System.exit(-1);
                return null;
            }
        }

        public Object caseParallel(Parallel object) {
            Hashtable leftRUs = (Hashtable)this.doSwitch((EObject)object.getLeftTask());
            Hashtable rightRUs = (Hashtable)this.doSwitch((EObject)object.getRightTask());
            return PerformanceSolver.this.performanceOps.computeParallel(leftRUs, rightRUs);
        }

        public Object caseRelease(Release object) {
            System.err.println("Release ignored in performance prediction!");
            return super.caseRelease(object);
        }

        public Object caseSequence(Sequence object) {
            Hashtable leftRUs = (Hashtable)this.doSwitch((EObject)object.getLeftRegExp());
            Hashtable rightRUs = (Hashtable)this.doSwitch((EObject)object.getRightRegExp());
            return PerformanceSolver.this.performanceOps.computeSequence(leftRUs, rightRUs);
        }

        public Object caseSymbol(Symbol symbol) {
            EList resourceUsageList = symbol.getResourceUsages();
            return PerformanceSolver.this.performanceOps.getResourceUsageTimes((List<ResourceUsage>)resourceUsageList);
        }
    };

    public PerformanceSolver(RUPerformanceOps performanceOps) {
        this.performanceOps = performanceOps;
    }

    public PerformanceSolver() {
        this.performanceOps = new RUPerformanceOps();
    }

    public Hashtable<ActiveResource, ManagedPDF> getResourceUsageTimes(Expression expression) {
        return (Hashtable)this.exprSwitch.doSwitch((EObject)expression);
    }
}

