/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.spa.basicsolver.visitor.perfhandler;

import de.uka.ipd.sdq.probfunction.math.IProbabilityDensityFunction;
import de.uka.ipd.sdq.probfunction.math.IProbabilityFunctionFactory;
import de.uka.ipd.sdq.probfunction.math.ISamplePDF;
import de.uka.ipd.sdq.probfunction.math.exception.ProbabilityFunctionException;
import java.util.Hashtable;
import org.palladiosimulator.solver.spa.basicsolver.visitor.SymbolHandler;
import org.palladiosimulator.solver.spa.expression.Expression;
import org.palladiosimulator.solver.spa.expression.Symbol;
import org.palladiosimulator.solver.spa.resourcemodel.ResourceUsage;

public class PerformanceSymbolHandler
implements SymbolHandler {
    private Hashtable<Expression, IProbabilityDensityFunction> pdfTable;
    private IProbabilityFunctionFactory pfFactory = IProbabilityFunctionFactory.eINSTANCE;
    private int domainSize;

    protected PerformanceSymbolHandler(Hashtable<Expression, IProbabilityDensityFunction> pdfTable, int domainSize) {
        this(domainSize);
        this.pdfTable = pdfTable;
    }

    protected PerformanceSymbolHandler(int domainSize) {
        this.domainSize = domainSize;
    }

    @Override
    public void handle(Symbol symbol) {
        try {
            ResourceUsage resourceUsage = (ResourceUsage)symbol.getResourceUsages().get(0);
            IProbabilityDensityFunction pdf = this.pfFactory.transformToPDF(resourceUsage.getUsageTime());
            ISamplePDF spdf = this.pfFactory.transformToSamplePDF(pdf);
            spdf.expand(this.domainSize);
            IProbabilityDensityFunction fftPDF = spdf.getFourierTransform();
            this.pdfTable.put((Expression)symbol, fftPDF);
        }
        catch (ProbabilityFunctionException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public Hashtable<Expression, IProbabilityDensityFunction> getPdfTable() {
        return this.pdfTable;
    }

    public void setPdfTable(Hashtable<Expression, IProbabilityDensityFunction> pdfTable) {
        this.pdfTable = pdfTable;
    }
}

