/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver;

import de.uka.ipd.sdq.probfunction.math.IProbabilityDensityFunction;
import de.uka.ipd.sdq.probfunction.math.IProbabilityFunctionFactory;
import de.uka.ipd.sdq.probfunction.math.ISamplePDF;
import de.uka.ipd.sdq.probfunction.math.PDFConfiguration;
import de.uka.ipd.sdq.probfunction.math.exception.ConfigurationNotSetException;
import de.uka.ipd.sdq.probfunction.math.exception.ProbabilityFunctionException;
import de.uka.ipd.sdq.probfunction.math.exception.UnknownPDFTypeException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.solver.models.PCMInstance;
import org.palladiosimulator.solver.spa.expression.Expression;
import org.palladiosimulator.solver.transformations.pcm2regex.ExpressionPrinter;
import org.palladiosimulator.solver.transformations.pcm2regex.TransformUsageModelVisitor;
import org.palladiosimulator.solver.visitors.UsageModelVisitor;
import org.palladiosimulator.solver.visualisation.JFVisualisation;

public class DependencySolver {
    private static final int DOMAIN_SIZE = 32;
    private static final double DISTANCE = 0.1;
    protected IProbabilityFunctionFactory iProbFuncFactory = IProbabilityFunctionFactory.eINSTANCE;
    private Properties config;
    private PCMInstance currentModel;
    private static Logger logger = Logger.getLogger((String)DependencySolver.class.getName());

    public DependencySolver(Properties config) {
        this.config = config;
        logger.debug((Object)"Loading PCM Instance");
        this.currentModel = new PCMInstance(config);
        this.runDSolver();
        Expression result = this.runPcm2RegEx();
    }

    public DependencySolver(ILaunchConfiguration configuration) {
        PatternLayout myLayout = new PatternLayout("%d{HH:mm:ss,SSS} [%t] %-5p %c - %m%n");
        ConsoleAppender myAppender = new ConsoleAppender((Layout)myLayout);
        BasicConfigurator.configure((Appender)myAppender);
        this.runDSolver();
        Expression result = this.runPcm2RegEx();
    }

    private IProbabilityDensityFunction runCalculation(Expression result) {
        long timeBeforeCalc = System.nanoTime();
        long timeAfterCalc = System.nanoTime();
        long duration3 = TimeUnit.NANOSECONDS.toMillis(timeAfterCalc - timeBeforeCalc);
        logger.debug((Object)("Finished Calculation, Duration: " + duration3 + " ms"));
        return null;
    }

    private void visualize(IProbabilityDensityFunction iPDF) {
        long timeBeforeVis = System.nanoTime();
        ISamplePDF samplePDF = null;
        try {
            samplePDF = this.iProbFuncFactory.transformToSamplePDF(iPDF);
        }
        catch (UnknownPDFTypeException e1) {
            e1.printStackTrace();
        }
        try {
            double dist = 0.0;
            try {
                dist = PDFConfiguration.getCurrentConfiguration().getDistance();
            }
            catch (ConfigurationNotSetException e) {
                e.printStackTrace();
            }
            JFVisualisation vis = new JFVisualisation(dist);
            vis.addSamplePDF(samplePDF, "Execution Time");
            vis.visualizeOverlay();
        }
        catch (ProbabilityFunctionException e) {
            e.printStackTrace();
        }
        long timeAfterVis = System.nanoTime();
        long duration = TimeUnit.NANOSECONDS.toMillis(timeAfterVis - timeBeforeVis);
        logger.debug((Object)("Finished Visualisati on, Duration: " + duration + " ms"));
    }

    private Expression runPcm2RegEx() {
        long timeBeforeTransform = System.nanoTime();
        Expression result = this.pcm2RegEx(this.currentModel);
        long timeAfterTransform = System.nanoTime();
        long duration2 = TimeUnit.NANOSECONDS.toMillis(timeAfterTransform - timeBeforeTransform);
        logger.debug((Object)("Finished Transform, Duration: " + duration2 + " ms"));
        return result;
    }

    private void runDSolver() {
        long startTime = System.nanoTime();
        this.visitScenarioEMFSwitch();
        this.currentModel.saveToFiles("SolvedDSolverExample1");
        long timeAfterDSolve = System.nanoTime();
        long duration = TimeUnit.NANOSECONDS.toMillis(timeAfterDSolve - startTime);
        logger.debug((Object)("Finished Traversal, Saving; Duration: " + duration + " ms"));
    }

    private Expression pcm2RegEx(PCMInstance currentModel) {
        TransformUsageModelVisitor umVisit = new TransformUsageModelVisitor(currentModel);
        UsageScenario us = (UsageScenario)currentModel.getUsageModel().getUsageScenario_UsageModel().get(0);
        Expression result = null;
        try {
            result = (Expression)umVisit.doSwitch((EObject)us.getScenarioBehaviour_UsageScenario());
        }
        catch (Exception e) {
            logger.error((Object)("Usage Scenario caused Exception!" + e.getMessage()));
            e.printStackTrace();
        }
        ExpressionPrinter expPrinter = new ExpressionPrinter();
        expPrinter.doSwitch((EObject)result);
        System.out.println();
        return result;
    }

    private void visitScenarioEMFSwitch() {
        UsageModelVisitor visitor = new UsageModelVisitor(this.currentModel);
        try {
            UsageScenario us = (UsageScenario)this.currentModel.getUsageModel().getUsageScenario_UsageModel().get(0);
            visitor.doSwitch((EObject)us.getScenarioBehaviour_UsageScenario());
        }
        catch (Exception e) {
            logger.error((Object)("Usage Scenario caused Exception!" + e.getMessage()));
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        DependencySolver.configureLogger();
        DependencySolver dsolver = new DependencySolver(DependencySolver.getConfig(args));
    }

    private static void configureLogger() {
        PatternLayout myLayout = new PatternLayout("%d{HH:mm:ss,SSS} [%t] %-5p %c - %m%n");
        ConsoleAppender myAppender = new ConsoleAppender((Layout)myLayout);
        BasicConfigurator.configure((Appender)myAppender);
    }

    public static Properties getConfig(String[] args) {
        Properties configFromFile = new Properties();
        if (args.length != 1) {
            System.out.println("Usage: DependencySolver <configfile.xml>");
            System.exit(-1);
        } else {
            configFromFile = new Properties();
            try {
                FileInputStream fis = new FileInputStream(args[0]);
                configFromFile.loadFromXML(fis);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return configFromFile;
    }
}

