/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver;

import de.uka.ipd.sdq.probfunction.math.IProbabilityFunctionFactory;
import de.uka.ipd.sdq.probfunction.math.IUnit;
import de.uka.ipd.sdq.probfunction.math.PDFConfiguration;
import java.io.OutputStream;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.palladiosimulator.solver.models.PCMInstance;
import org.palladiosimulator.solver.transformations.SolverStrategy;

public class PCMSolver {
    private static MessageConsole messageConsole;
    private static Logger logger;
    private static final int DOMAINSIZEDEFAULT = 32;
    private static final double DISTANCEDEFAULT = 1.0;
    private PCMInstance currentModel;
    private IProgressMonitor monitor;
    private SolverStrategy strategy;

    static {
        logger = Logger.getLogger((String)PCMSolver.class.getName());
    }

    public static MessageConsole getConsole() {
        return messageConsole;
    }

    public PCMSolver(ILaunchConfiguration configuration, IProgressMonitor monitor, boolean reliability) {
        this.monitor = monitor;
        this.configureLogging(configuration);
        this.currentModel = new PCMInstance(configuration);
        int domainSize = 32;
        double distance = 1.0;
        String solver = "SRES (Stochastic Regular Expression Solver)";
        try {
            domainSize = Integer.parseInt(configuration.getAttribute("maxDomain", "32"));
            distance = Double.parseDouble(configuration.getAttribute("samplingDist", "1.0"));
            solver = configuration.getAttribute("solver", "SRES (Stochastic Regular Expression Solver)");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        PDFConfiguration.setCurrentConfiguration((int)domainSize, (double)distance, (IUnit)IProbabilityFunctionFactory.eINSTANCE.createDefaultUnit());
        if (!(reliability || solver.equals("SRES (Stochastic Regular Expression Solver)") || solver.equals("LQNS (Layered Queueing Network Solver)"))) {
            solver.equals("LQSIM (Layered Queueing Simulation)");
        }
    }

    public PCMSolver(ILaunchConfiguration configuration, IProgressMonitor monitor) {
        this(configuration, monitor, false);
    }

    public void execute() {
        if (!this.currentModel.isValid()) {
            logger.error((Object)"PCM Instance invalid! Check filenames.");
            return;
        }
        this.monitor.beginTask("Analysis", 100);
        this.strategy.transform(this.currentModel);
        this.monitor.worked(50);
        this.strategy.solve();
        this.monitor.worked(50);
    }

    private void configureLogging(ILaunchConfiguration configuration) {
        PatternLayout myLayout = new PatternLayout("%d{HH:mm:ss,SSS} [%t] %-5p %c - %m%n");
        if (messageConsole == null) {
            messageConsole = new MessageConsole("PCM Solver Console: Analysis Tool Output", null);
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{messageConsole});
        }
        messageConsole.activate();
        BasicConfigurator.resetConfiguration();
        BasicConfigurator.configure((Appender)new WriterAppender((Layout)myLayout, (OutputStream)messageConsole.newMessageStream()));
    }

    public SolverStrategy getStrategy() {
        return this.strategy;
    }
}

