/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.handler;

import de.uka.ipd.sdq.probfunction.ProbabilityMassFunction;
import de.uka.ipd.sdq.probfunction.Sample;
import de.uka.ipd.sdq.stoex.Expression;
import de.uka.ipd.sdq.stoex.ProbabilityFunctionLiteral;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.pcm.seff.AbstractBranchTransition;
import org.palladiosimulator.pcm.seff.GuardedBranchTransition;
import org.palladiosimulator.solver.handler.AbstractBranchTransitionHandler;
import org.palladiosimulator.solver.visitors.ExpressionHelper;
import org.palladiosimulator.solver.visitors.SeffVisitor;

public class GuardedBranchTransitionHandler
extends AbstractBranchTransitionHandler {
    private static Logger logger = Logger.getLogger((String)GuardedBranchTransitionHandler.class.getName());

    public GuardedBranchTransitionHandler(SeffVisitor seffVisitor) {
        super(seffVisitor);
    }

    public void handle(GuardedBranchTransition bt) {
        double solvedBranchProb = this.getBranchProbFromExpression(bt);
        logger.debug((Object)("SolvedBranchProb:" + solvedBranchProb));
        this.storeToUsageContext((AbstractBranchTransition)bt, solvedBranchProb);
        if (solvedBranchProb > 0.0) {
            this.visitChildBehaviour((AbstractBranchTransition)bt);
        }
    }

    private double getBranchProbFromExpression(GuardedBranchTransition bt) {
        String specification = bt.getBranchCondition_GuardedBranchTransition().getSpecification();
        Expression solvedExpression = ExpressionHelper.getSolvedExpression(specification, this.visitor.getContextWrapper());
        ProbabilityFunctionLiteral pfl = (ProbabilityFunctionLiteral)solvedExpression;
        ProbabilityMassFunction pmf = (ProbabilityMassFunction)pfl.getFunction_ProbabilityFunctionLiteral();
        double solvedBranchProb = 1.0;
        EList points = pmf.getSamples();
        for (Sample point : points) {
            String bool = point.getValue().toString();
            if (!bool.toLowerCase().equals("true")) continue;
            solvedBranchProb = point.getProbability();
        }
        solvedBranchProb = this.adjustToScope(solvedBranchProb);
        return solvedBranchProb;
    }

    private double adjustToScope(double solvedBranchProb) {
        return solvedBranchProb;
    }
}

