/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.analyzer.workflow.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.analyzer.workflow.configurations.AbstractPCMWorkflowRunConfiguration;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.resourcetype.ResourceRepository;
import org.palladiosimulator.pcm.system.System;
import org.palladiosimulator.pcm.usagemodel.UsageModel;
import org.palladiosimulator.solver.context.aggregatedUsageContext.AggregatedUsageContextFactory;
import org.palladiosimulator.solver.context.aggregatedUsageContext.ComputedAggregatedUsage;
import org.palladiosimulator.solver.context.computed_allocation.ComputedAllocation;
import org.palladiosimulator.solver.context.computed_allocation.ComputedAllocationContext;
import org.palladiosimulator.solver.context.computed_allocation.ComputedAllocationFactory;
import org.palladiosimulator.solver.context.computed_usage.ComputedUsage;
import org.palladiosimulator.solver.context.computed_usage.ComputedUsageFactory;
import org.palladiosimulator.solver.transformations.EMFHelper;

public class PCMInstance {
    private ComputedUsage computedUsage = ComputedUsageFactory.eINSTANCE.createComputedUsage();
    private ComputedAllocation actualAllocation = ComputedAllocationFactory.eINSTANCE.createComputedAllocation();
    private ComputedAggregatedUsage computedAggregatedUsage = AggregatedUsageContextFactory.eINSTANCE.createComputedAggregatedUsage();
    private String storagePath;
    private PCMResourceSetPartition resourceSetPartition;

    public PCMInstance(Properties config) {
        this.storagePath = config.getProperty("Storage_Path");
        ArrayList<String> fileList = new ArrayList<String>();
        fileList.add(config.getProperty("Filename_UsageModel"));
        fileList.add(config.getProperty("Filename_AllocationModel"));
        this.createResourceSetPartition(fileList);
    }

    @Deprecated
    public PCMInstance(ILaunchConfiguration configuration) {
        try {
            this.storagePath = configuration.getAttribute("outputPath", ".");
            ArrayList<String> fileList = new ArrayList<String>();
            fileList.add(configuration.getAttribute("usageFile", ""));
            fileList.add(configuration.getAttribute("allocationFile", ""));
            this.createResourceSetPartition(fileList);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public PCMInstance(PCMResourceSetPartition pcmModel) {
        this.storagePath = ".";
        this.resourceSetPartition = pcmModel;
    }

    private void createResourceSetPartition(List<String> modelFiles) {
        this.resourceSetPartition = new PCMResourceSetPartition();
        this.resourceSetPartition.initialiseResourceSetEPackages(AbstractPCMWorkflowRunConfiguration.PCM_EPACKAGES);
        for (String modelFile : modelFiles) {
            this.resourceSetPartition.loadModel(modelFile);
        }
        this.resourceSetPartition.resolveAllProxies();
    }

    public Allocation getAllocation() {
        return this.resourceSetPartition.getAllocation();
    }

    public List<Repository> getRepositories() {
        return this.resourceSetPartition.getRepositories();
    }

    public ResourceEnvironment getResourceEnvironment() {
        return this.resourceSetPartition.getResourceEnvironment();
    }

    public ResourceRepository getResourceRepository() {
        return this.resourceSetPartition.getResourceTypeRepository();
    }

    public System getSystem() {
        return this.resourceSetPartition.getSystem();
    }

    public UsageModel getUsageModel() {
        return this.resourceSetPartition.getUsageModel();
    }

    public ComputedAllocation getComputedAllocation() {
        return this.actualAllocation;
    }

    public ComputedUsage getComputedUsage() {
        return this.computedUsage;
    }

    public void saveToFiles(String fileNamePrefix) {
        fileNamePrefix = String.valueOf(this.storagePath) + "\\" + fileNamePrefix;
        this.saveToXMIFile((EObject)this.getAllocation(), String.valueOf(fileNamePrefix) + ".allocation");
        List<Repository> repositories = this.getRepositories();
        for (Repository repository : repositories) {
            this.saveToXMIFile((EObject)repository, String.valueOf(fileNamePrefix) + ".repository");
        }
        this.saveToXMIFile((EObject)this.getResourceEnvironment(), String.valueOf(fileNamePrefix) + ".resourceenvironment");
        this.saveToXMIFile((EObject)this.getResourceRepository(), String.valueOf(fileNamePrefix) + ".resourcetype");
        this.saveToXMIFile((EObject)this.getSystem(), String.valueOf(fileNamePrefix) + ".system");
        this.saveToXMIFile((EObject)this.getUsageModel(), String.valueOf(fileNamePrefix) + ".usagemodel");
        this.saveToXMIFile((EObject)this.computedUsage, String.valueOf(fileNamePrefix) + ".usage");
        this.saveToXMIFile((EObject)this.actualAllocation, String.valueOf(fileNamePrefix) + ".actualallocation");
    }

    public void saveToXMIFile(EObject modelToSave, String fileName) {
        EMFHelper.saveToXMIFile(modelToSave, fileName);
    }

    public boolean isValid() {
        return this.getAllocation() != null && this.getRepositories().size() != 0 && this.getResourceEnvironment() != null && this.getResourceRepository() != null && this.getSystem() != null && this.computedUsage != null;
    }

    public Set<ResourceContainer> getUsedResourceContainer() {
        HashSet<ResourceContainer> usedRCList = new HashSet<ResourceContainer>(this.getResourceEnvironment().getResourceContainer_ResourceEnvironment().size());
        if (this.actualAllocation != null && this.actualAllocation.getComputedAllocationContexts_ComputedAllocation().size() != 0) {
            EList computedAllocationContextList = this.actualAllocation.getComputedAllocationContexts_ComputedAllocation();
            for (ComputedAllocationContext cac : computedAllocationContextList) {
                ResourceContainer rc = cac.getAllocationContext_ComputedAllocationContext().getResourceContainer_AllocationContext();
                if (usedRCList.contains(rc)) continue;
                usedRCList.add(rc);
            }
        } else {
            usedRCList.addAll((Collection<ResourceContainer>)this.getResourceEnvironment().getResourceContainer_ResourceEnvironment());
        }
        return usedRCList;
    }

    public ComputedAggregatedUsage getComputedAggregatedUsage() {
        return this.computedAggregatedUsage;
    }

    public void setComputedContexts(ComputedAllocation computedAllocation, ComputedUsage computedUsage, ComputedAggregatedUsage aggregatedUsage) {
        this.computedUsage = computedUsage;
        this.actualAllocation = computedAllocation;
        this.computedAggregatedUsage = aggregatedUsage;
    }

    public void resetComputedContexts() {
        this.computedUsage = ComputedUsageFactory.eINSTANCE.createComputedUsage();
        this.actualAllocation = ComputedAllocationFactory.eINSTANCE.createComputedAllocation();
        this.computedAggregatedUsage = AggregatedUsageContextFactory.eINSTANCE.createComputedAggregatedUsage();
    }
}

