/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.runconfig;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.palladiosimulator.analyzer.workflow.runconfig.FileNamesInputTab;

public class MainConfigTab
extends FileNamesInputTab {
    private Text textSamplingDist;
    private Text textMaxDomain;
    private Text lqnsConfig1;
    private Text lqnsConfig2;
    private Text lqnsConfig3;
    private Text lqnsConfig4;
    private Button lqnsConfigStopOnMessageLoss;
    private Button lqnsConfigInfTaskMult;
    protected Combo comboLqnsOutput;
    private Text lqsimConfig1;
    private Text lqsimConfig2;
    private Text lqsimConfig3;
    private Button lqsimConfigStopOnMessageLoss;
    protected Combo comboLqsimOutput;
    private Text lqnsConfigPragma;
    private Text lqnsimConfigPragma;
    private Group sresConfigGroup;
    private Group lqnsConfigGroup;
    private Group lqsimConfigGroup;
    private Group lineConfigGroup;
    private StackLayout stackLayout;
    protected Combo comboSolver;
    private Text textLqnsOutputDir;
    private Text textLqsimOutputDir;
    private Text textSREOutputFile;
    private Button checkboxUseExpressionAsInput;
    private Button debugLINEButton;
    private Text textLINEOutputDir;
    private Text textLINEPropFile;
    final ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            MainConfigTab.this.setDirty(true);
            MainConfigTab.this.updateLaunchConfigurationDialog();
        }
    };
    private ComboBoxListener comboListener = new ComboBoxListener();

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout());
        this.comboSolver = new Combo(container, 8);
        this.comboSolver.setItems(new String[]{"SRES (Stochastic Regular Expression Solver)", "LQNS (Layered Queueing Network Solver)", "LQSIM (Layered Queueing Simulation)", "LINE"});
        this.comboSolver.setSize(400, 200);
        this.comboSolver.addModifyListener(this.listener);
        this.comboSolver.addSelectionListener((SelectionListener)this.comboListener);
        Composite innerContainer = new Composite(container, 0);
        this.stackLayout = new StackLayout();
        innerContainer.setLayout((Layout)this.stackLayout);
        innerContainer.setLayoutData((Object)new GridData(4, 128, true, true, 1, 1));
        this.sresConfigGroup = this.createSREWidgets(innerContainer);
        this.lqnsConfigGroup = this.createLQNSWidgets(innerContainer);
        this.lqsimConfigGroup = this.createLQSIMWidgets(innerContainer);
        this.lineConfigGroup = this.createLINEWidgets(innerContainer);
    }

    private Group createLQSIMWidgets(Composite container) {
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                MainConfigTab.this.setDirty(true);
                MainConfigTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetSelected(SelectionEvent e) {
                MainConfigTab.this.setDirty(true);
                MainConfigTab.this.updateLaunchConfigurationDialog();
            }
        };
        GridLayout analysisGL = new GridLayout();
        analysisGL.numColumns = 4;
        Group group = new Group(container, 0);
        group.setLayout((Layout)analysisGL);
        group.setText("Configuration (see LQSim manual for details or use defaults)");
        group.setLayoutData((Object)new GridData(500, -1));
        GridData threeColumnGridData = new GridData(16384, 0x1000000, true, false);
        threeColumnGridData.horizontalSpan = 3;
        Label label1 = new Label((Composite)group, 0);
        label1.setText("Run Time (optional):");
        label1.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.lqsimConfig1 = new Text((Composite)group, 2052);
        this.lqsimConfig1.setLayoutData((Object)threeColumnGridData);
        this.lqsimConfig1.addModifyListener(this.listener);
        Label label2 = new Label((Composite)group, 0);
        label2.setText("Blocks (optional):");
        label2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.lqsimConfig2 = new Text((Composite)group, 2052);
        this.lqsimConfig2.setLayoutData((Object)threeColumnGridData);
        this.lqsimConfig2.addModifyListener(this.listener);
        Label label3 = new Label((Composite)group, 0);
        label3.setText("Processor Sharing Time Quantum:");
        label3.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.lqsimConfig3 = new Text((Composite)group, 2052);
        this.lqsimConfig3.setLayoutData((Object)threeColumnGridData);
        this.lqsimConfig3.addModifyListener(this.listener);
        Label labelStopOnMessageLoss = new Label((Composite)group, 0);
        labelStopOnMessageLoss.setText("\"Stop On Message Loss\" Pragma:");
        labelStopOnMessageLoss.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.lqsimConfigStopOnMessageLoss = new Button((Composite)group, 32);
        this.lqsimConfigStopOnMessageLoss.setEnabled(true);
        this.lqsimConfigStopOnMessageLoss.setText("Stop on message loss");
        this.lqsimConfigStopOnMessageLoss.addSelectionListener(selectionListener);
        this.lqsimConfigStopOnMessageLoss.setSelection(true);
        this.lqsimConfigStopOnMessageLoss.setLayoutData((Object)threeColumnGridData);
        Label label4 = new Label((Composite)group, 0);
        label4.setText("Output Type:");
        label4.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.comboLqsimOutput = new Combo((Composite)group, 8);
        this.comboLqsimOutput.setItems(new String[]{"HTML Output", "Human Readable Output", "XML Output"});
        this.comboLqsimOutput.setSize(400, 200);
        this.comboLqsimOutput.setLayoutData((Object)threeColumnGridData);
        this.comboLqsimOutput.addModifyListener(this.listener);
        Label label5 = new Label((Composite)group, 0);
        label5.setText("Output Dir:");
        label5.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.textLqsimOutputDir = new Text((Composite)group, 2052);
        this.textLqsimOutputDir.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textLqsimOutputDir.addModifyListener(this.listener);
        this.createFolderSelectionButtons(group, this.textLqsimOutputDir);
        Label labelPragma = new Label((Composite)group, 0);
        labelPragma.setText("Additional Pragmas:");
        labelPragma.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.lqnsimConfigPragma = new Text((Composite)group, 2052);
        this.lqnsimConfigPragma.setLayoutData((Object)threeColumnGridData);
        this.lqnsimConfigPragma.addModifyListener(this.listener);
        return group;
    }

    private Group createLQNSWidgets(Composite container) {
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                MainConfigTab.this.setDirty(true);
                MainConfigTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetSelected(SelectionEvent e) {
                MainConfigTab.this.setDirty(true);
                MainConfigTab.this.updateLaunchConfigurationDialog();
            }
        };
        GridLayout analysisGL = new GridLayout();
        analysisGL.numColumns = 4;
        Group group = new Group(container, 0);
        group.setLayout((Layout)analysisGL);
        group.setText("Configuration (see LQNS manual for details or use defaults)");
        group.setLayoutData((Object)new GridData(500, -1));
        GridData threeColumnGridData = new GridData(16384, 0x1000000, true, false);
        threeColumnGridData.horizontalSpan = 3;
        Label label1 = new Label((Composite)group, 0);
        label1.setText("Convergence Value:");
        label1.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.lqnsConfig1 = new Text((Composite)group, 2052);
        this.lqnsConfig1.setLayoutData((Object)threeColumnGridData);
        this.lqnsConfig1.addModifyListener(this.listener);
        Label label2 = new Label((Composite)group, 0);
        label2.setText("Iteration Limit:");
        label2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.lqnsConfig2 = new Text((Composite)group, 2052);
        this.lqnsConfig2.setLayoutData((Object)threeColumnGridData);
        this.lqnsConfig2.addModifyListener(this.listener);
        Label label3 = new Label((Composite)group, 0);
        label3.setText("Print Interval Intermediate Results:");
        label3.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.lqnsConfig3 = new Text((Composite)group, 2052);
        this.lqnsConfig3.setLayoutData((Object)threeColumnGridData);
        this.lqnsConfig3.addModifyListener(this.listener);
        Label label4 = new Label((Composite)group, 0);
        label4.setText("Under-relaxation Coefficient:");
        label4.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.lqnsConfig4 = new Text((Composite)group, 2052);
        this.lqnsConfig4.setLayoutData((Object)threeColumnGridData);
        this.lqnsConfig4.addModifyListener(this.listener);
        Label labelStopOnMessageLoss = new Label((Composite)group, 0);
        labelStopOnMessageLoss.setText("\"Stop On Message Loss\" Pragma:");
        labelStopOnMessageLoss.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.lqnsConfigStopOnMessageLoss = new Button((Composite)group, 32);
        this.lqnsConfigStopOnMessageLoss.setEnabled(true);
        this.lqnsConfigStopOnMessageLoss.setText("Stop on message loss");
        this.lqnsConfigStopOnMessageLoss.addSelectionListener(selectionListener);
        this.lqnsConfigStopOnMessageLoss.setSelection(true);
        this.lqnsConfigStopOnMessageLoss.setLayoutData((Object)threeColumnGridData);
        Label labelInfTaskMult = new Label((Composite)group, 0);
        labelInfTaskMult.setText("Infinite Task Multiplicity:");
        labelInfTaskMult.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.lqnsConfigInfTaskMult = new Button((Composite)group, 32);
        this.lqnsConfigInfTaskMult.setEnabled(true);
        this.lqnsConfigInfTaskMult.setText("");
        this.lqnsConfigInfTaskMult.addSelectionListener(selectionListener);
        this.lqnsConfigInfTaskMult.setSelection(true);
        this.lqnsConfigInfTaskMult.setLayoutData((Object)threeColumnGridData);
        Label label5 = new Label((Composite)group, 0);
        label5.setText("Output Type:");
        label5.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.comboLqnsOutput = new Combo((Composite)group, 8);
        this.comboLqnsOutput.setItems(new String[]{"HTML Output", "Human Readable Output", "XML Output"});
        this.comboLqnsOutput.setSize(400, 200);
        this.comboLqnsOutput.setLayoutData((Object)threeColumnGridData);
        this.comboLqnsOutput.addModifyListener(this.listener);
        this.comboLqnsOutput.addSelectionListener((SelectionListener)this.comboListener);
        Label label6 = new Label((Composite)group, 0);
        label6.setText("Output Dir:");
        label6.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.textLqnsOutputDir = new Text((Composite)group, 2052);
        this.textLqnsOutputDir.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textLqnsOutputDir.addModifyListener(this.listener);
        this.createFolderSelectionButtons(group, this.textLqnsOutputDir);
        Label labelPragma = new Label((Composite)group, 0);
        labelPragma.setText("Additional Pragmas:");
        labelPragma.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.lqnsConfigPragma = new Text((Composite)group, 2052);
        this.lqnsConfigPragma.setLayoutData((Object)threeColumnGridData);
        this.lqnsConfigPragma.addModifyListener(this.listener);
        return group;
    }

    private Group createLINEWidgets(Composite container) {
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                MainConfigTab.this.setDirty(true);
                MainConfigTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetSelected(SelectionEvent e) {
                MainConfigTab.this.setDirty(true);
                MainConfigTab.this.updateLaunchConfigurationDialog();
            }
        };
        GridLayout analysisGL = new GridLayout();
        analysisGL.numColumns = 4;
        Group group = new Group(container, 0);
        group.setLayout((Layout)analysisGL);
        group.setText("Configuration (Definition of parameters)");
        group.setLayoutData((Object)new GridData(500, -1));
        GridData threeColumnGridData = new GridData(16384, 0x1000000, true, false);
        threeColumnGridData.horizontalSpan = 3;
        Label labelOutFolder = new Label((Composite)group, 0);
        labelOutFolder.setText("Output Dir:");
        labelOutFolder.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.textLINEOutputDir = new Text((Composite)group, 2052);
        this.textLINEOutputDir.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textLINEOutputDir.addModifyListener(this.listener);
        this.createFolderSelectionButtons(group, this.textLINEOutputDir);
        Label labelPerfFile = new Label((Composite)group, 0);
        labelPerfFile.setText("LINE property file:");
        labelPerfFile.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.textLINEPropFile = new Text((Composite)group, 2052);
        this.textLINEPropFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textLINEPropFile.addModifyListener(this.listener);
        this.createFileSelectionButtons(group, this.textLINEPropFile);
        this.debugLINEButton = new Button((Composite)group, 32);
        this.debugLINEButton.setEnabled(true);
        this.debugLINEButton.setText("Verbose Debugging");
        this.debugLINEButton.addSelectionListener(selectionListener);
        this.debugLINEButton.setSelection(true);
        this.debugLINEButton.setLayoutData((Object)threeColumnGridData);
        return group;
    }

    private void createFileSelectionButtons(Group group, Text text) {
        Button workspaceButton = new Button((Composite)group, 0);
        workspaceButton.setText("Workspace...");
        workspaceButton.addSelectionListener((SelectionListener)new WorkspaceFileButtonSelectionListener(text));
        Button fileSystemButton = new Button((Composite)group, 0);
        fileSystemButton.setText("File System...");
        fileSystemButton.addSelectionListener((SelectionListener)new FileSystemButtonSelectionAdapter(text));
    }

    private void createFolderSelectionButtons(Group group, Text text) {
        Button workspaceButton = new Button((Composite)group, 0);
        workspaceButton.setText("Workspace...");
        workspaceButton.addSelectionListener((SelectionListener)new WorkspaceButtonSelectionListener(text));
        Button fileSystemButton = new Button((Composite)group, 0);
        fileSystemButton.setText("File System...");
        fileSystemButton.addSelectionListener((SelectionListener)new FileSystemButtonSelectionAdapter(text));
    }

    private Group createSREWidgets(Composite container) {
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                MainConfigTab.this.setDirty(true);
                MainConfigTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetSelected(SelectionEvent e) {
                MainConfigTab.this.setDirty(true);
                MainConfigTab.this.updateLaunchConfigurationDialog();
            }
        };
        GridLayout analysisGL = new GridLayout();
        analysisGL.numColumns = 4;
        GridData threeColumnGridData = new GridData(16384, 0x1000000, true, false);
        threeColumnGridData.horizontalSpan = 3;
        Group group = new Group(container, 0);
        group.setLayout((Layout)analysisGL);
        group.setText("Configuration");
        group.setLayoutData((Object)new GridData(500, -1));
        Label samplingDist = new Label((Composite)group, 0);
        samplingDist.setText("Sampling Distance:");
        samplingDist.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.textSamplingDist = new Text((Composite)group, 2052);
        this.textSamplingDist.setLayoutData((Object)threeColumnGridData);
        this.textSamplingDist.addModifyListener(this.listener);
        Label maxDomain = new Label((Composite)group, 0);
        maxDomain.setText("Maximum Domain Size:");
        maxDomain.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.textMaxDomain = new Text((Composite)group, 2052);
        this.textMaxDomain.setLayoutData((Object)threeColumnGridData);
        this.textMaxDomain.addModifyListener(this.listener);
        Label useExpressionLabel = new Label((Composite)group, 0);
        useExpressionLabel.setText("Use of Expression Model File:");
        useExpressionLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.checkboxUseExpressionAsInput = new Button((Composite)group, 32);
        this.checkboxUseExpressionAsInput.setEnabled(true);
        this.checkboxUseExpressionAsInput.setText("Use expression file below as input. If not checked, file is used as output file.");
        this.checkboxUseExpressionAsInput.addSelectionListener(selectionListener);
        this.checkboxUseExpressionAsInput.setLayoutData((Object)threeColumnGridData);
        this.checkboxUseExpressionAsInput.setSelection(false);
        Label label6 = new Label((Composite)group, 0);
        label6.setText("Expression Model File:");
        label6.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.textSREOutputFile = new Text((Composite)group, 2052);
        this.textSREOutputFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textSREOutputFile.addModifyListener(this.listener);
        this.createFolderSelectionButtons(group, this.textSREOutputFile);
        return group;
    }

    public String getName() {
        return "Solver";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        String outputStr;
        String str;
        int i;
        String[] items;
        try {
            String solverStr = configuration.getAttribute("solver", "SRES (Stochastic Regular Expression Solver)");
            items = this.comboSolver.getItems();
            i = 0;
            while (i < items.length) {
                str = items[i];
                if (str.equals(solverStr)) {
                    this.comboSolver.select(i);
                }
                ++i;
            }
            this.setVisibleConfigurationOptions(solverStr);
        }
        catch (CoreException e) {
            this.comboSolver.select(0);
        }
        try {
            outputStr = configuration.getAttribute("output", "Human Readable Output");
            items = this.comboLqnsOutput.getItems();
            i = 0;
            while (i < items.length) {
                str = items[i];
                if (str.equals(outputStr)) {
                    this.comboLqnsOutput.select(i);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            this.comboLqnsOutput.select(0);
        }
        try {
            outputStr = configuration.getAttribute("lqsimoutput", "Human Readable Output");
            items = this.comboLqsimOutput.getItems();
            i = 0;
            while (i < items.length) {
                str = items[i];
                if (str.equals(outputStr)) {
                    this.comboLqsimOutput.select(i);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            this.comboLqsimOutput.select(0);
        }
        try {
            this.textSamplingDist.setText(configuration.getAttribute("samplingDist", "1.0"));
        }
        catch (CoreException e) {
            this.textSamplingDist.setText("1.0");
        }
        try {
            this.textMaxDomain.setText(configuration.getAttribute("maxDomain", "256"));
        }
        catch (CoreException e) {
            this.textMaxDomain.setText("256");
        }
        try {
            this.textSREOutputFile.setText(configuration.getAttribute("SREOutputDir", System.getProperty("user.dir")));
        }
        catch (CoreException e) {
            this.textSREOutputFile.setText(System.getProperty("user.dir"));
        }
        try {
            this.lqnsConfig1.setText(configuration.getAttribute("convValue", "0.001"));
        }
        catch (CoreException e) {
            this.lqnsConfig1.setText("0.001");
        }
        try {
            this.lqnsConfig2.setText(configuration.getAttribute("itLimit", "50"));
        }
        catch (CoreException e) {
            this.lqnsConfig2.setText("50");
        }
        try {
            this.lqnsConfig3.setText(configuration.getAttribute("printInt", "10"));
        }
        catch (CoreException e) {
            this.lqnsConfig3.setText("10");
        }
        try {
            this.lqnsConfig4.setText(configuration.getAttribute("underCoeff", "0.5"));
        }
        catch (CoreException e) {
            this.lqnsConfig4.setText("0.5");
        }
        try {
            this.textLqnsOutputDir.setText(configuration.getAttribute("lqnsOutputDir", System.getProperty("user.dir")));
        }
        catch (CoreException e) {
            this.textLqnsOutputDir.setText(System.getProperty("user.dir"));
        }
        try {
            this.textLINEOutputDir.setText(configuration.getAttribute("LINEOutputDir", System.getProperty("user.dir")));
        }
        catch (CoreException e) {
            this.textLINEOutputDir.setText(System.getProperty("user.dir"));
        }
        try {
            this.textLINEPropFile.setText(configuration.getAttribute("LINEPropFile", String.valueOf(System.getProperty("user.dir")) + "LINE.properties"));
        }
        catch (CoreException e) {
            this.textLINEPropFile.setText(String.valueOf(System.getProperty("user.dir")) + "LINE.properties");
        }
        try {
            this.lqnsConfigPragma.setText(configuration.getAttribute("lqnPragmas", ""));
        }
        catch (CoreException e) {
            this.lqnsConfigPragma.setText("");
        }
        try {
            this.lqsimConfig1.setText(configuration.getAttribute("runTime", ""));
        }
        catch (CoreException e) {
            this.lqsimConfig1.setText("");
        }
        try {
            this.lqsimConfig2.setText(configuration.getAttribute("blocks", ""));
        }
        catch (CoreException e) {
            this.lqsimConfig2.setText("");
        }
        try {
            this.lqsimConfig3.setText(configuration.getAttribute("psQuantum", "0.001"));
        }
        catch (CoreException e) {
            this.lqsimConfig3.setText("0.001");
        }
        try {
            this.textLqsimOutputDir.setText(configuration.getAttribute("lqsimOutputDir", System.getProperty("user.dir")));
        }
        catch (CoreException e) {
            this.textLqsimOutputDir.setText(System.getProperty("user.dir"));
        }
        try {
            this.checkboxUseExpressionAsInput.setSelection(configuration.getAttribute("SREUseInputModel", false));
        }
        catch (CoreException e) {
            this.checkboxUseExpressionAsInput.setSelection(false);
        }
        try {
            this.lqnsConfigStopOnMessageLoss.setSelection(configuration.getAttribute("LQNS Stop On Message Loss", true));
        }
        catch (CoreException e) {
            this.lqnsConfigStopOnMessageLoss.setSelection(true);
        }
        try {
            this.debugLINEButton.setSelection(configuration.getAttribute("LINEDebug", true));
        }
        catch (CoreException e) {
            this.debugLINEButton.setSelection(true);
        }
        try {
            this.lqsimConfigStopOnMessageLoss.setSelection(configuration.getAttribute("LQSIM Stop On Message Loss", true));
        }
        catch (CoreException e) {
            this.lqsimConfigStopOnMessageLoss.setSelection(true);
        }
        try {
            this.lqnsimConfigPragma.setText(configuration.getAttribute("lqnPragmas", ""));
        }
        catch (CoreException e) {
            this.lqnsimConfigPragma.setText("");
        }
        try {
            this.lqnsConfigInfTaskMult.setSelection(configuration.getAttribute("infiniteTaskMultiplicity", true));
        }
        catch (CoreException e) {
            this.lqnsConfigInfTaskMult.setSelection(true);
        }
        this.updateLaunchConfigurationDialog();
    }

    private void setVisibleConfigurationOptions(String solverStr) {
        if (solverStr.equals("SRES (Stochastic Regular Expression Solver)")) {
            this.stackLayout.topControl = this.sresConfigGroup;
        } else if (solverStr.equals("LQNS (Layered Queueing Network Solver)")) {
            this.stackLayout.topControl = this.lqnsConfigGroup;
        } else if (solverStr.equals("LQSIM (Layered Queueing Simulation)")) {
            this.stackLayout.topControl = this.lqsimConfigGroup;
        } else if (solverStr.equals("LINE")) {
            this.stackLayout.topControl = this.lineConfigGroup;
        }
        this.lqsimConfigGroup.getParent().layout();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("solver", this.comboSolver.getText());
        configuration.setAttribute("samplingDist", this.textSamplingDist.getText());
        configuration.setAttribute("maxDomain", Integer.parseInt(this.textMaxDomain.getText()));
        configuration.setAttribute("convValue", this.lqnsConfig1.getText());
        configuration.setAttribute("itLimit", this.lqnsConfig2.getText());
        configuration.setAttribute("printInt", this.lqnsConfig3.getText());
        configuration.setAttribute("underCoeff", this.lqnsConfig4.getText());
        configuration.setAttribute("output", this.comboLqnsOutput.getText());
        configuration.setAttribute("lqsimoutput", this.comboLqsimOutput.getText());
        configuration.setAttribute("LQNS Stop On Message Loss", this.lqnsConfigStopOnMessageLoss.getSelection());
        configuration.setAttribute("LQSIM Stop On Message Loss", this.lqsimConfigStopOnMessageLoss.getSelection());
        configuration.setAttribute("LINEDebug", this.debugLINEButton.getSelection());
        configuration.setAttribute("infiniteTaskMultiplicity", this.lqnsConfigInfTaskMult.getSelection());
        configuration.setAttribute("runTime", this.lqsimConfig1.getText());
        configuration.setAttribute("blocks", this.lqsimConfig2.getText());
        configuration.setAttribute("psQuantum", this.lqsimConfig3.getText());
        configuration.setAttribute("lqnPragmas", this.lqnsimConfigPragma.getText());
        configuration.setAttribute("lqnPragmas", this.lqnsConfigPragma.getText());
        configuration.setAttribute("lqnsOutputDir", this.textLqnsOutputDir.getText());
        configuration.setAttribute("lqsimOutputDir", this.textLqsimOutputDir.getText());
        configuration.setAttribute("SREOutputDir", this.textSREOutputFile.getText());
        configuration.setAttribute("LINEOutputDir", this.textLINEOutputDir.getText());
        configuration.setAttribute("LINEPropFile", this.textLINEPropFile.getText());
        configuration.setAttribute("SREUseInputModel", this.checkboxUseExpressionAsInput.getSelection());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        String sampDist = this.textSamplingDist.getText();
        if (sampDist.equals("")) {
            this.setErrorMessage("Sampling distance is missing!");
            return false;
        }
        try {
            Double.parseDouble(sampDist);
        }
        catch (NumberFormatException e) {
            this.setErrorMessage("Sampling distance is not a Double Value!");
            return false;
        }
        String maxDom = this.textMaxDomain.getText();
        if (maxDom.equals("")) {
            this.setErrorMessage("Maximum domain size is missing!");
            return false;
        }
        try {
            Integer.parseInt(maxDom);
        }
        catch (NumberFormatException e) {
            this.setErrorMessage("Maximum domain is not an Integer Value!");
            return false;
        }
        String outputDir = this.textLqnsOutputDir.getText();
        if (outputDir.equals("")) {
            this.setErrorMessage("Output folder must be set!");
            return false;
        }
        if (outputDir.contains(" ")) {
            this.setErrorMessage("Output folder must not contain a space character, as the LQN solvers cannot handle that.");
            return false;
        }
        return true;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    private String openFileSystemFolderDialog() {
        String folderName = "";
        DirectoryDialog dirDialog = new DirectoryDialog(this.getShell(), 4096);
        dirDialog.setText("Select a folder.");
        if (dirDialog.open() != null) {
            folderName = dirDialog.getFilterPath();
        }
        return folderName;
    }

    private String openFileSystemFileDialog() {
        String fileName = "";
        FileDialog fDialog = new FileDialog(this.getShell(), 4096);
        fDialog.setText("Select a file.");
        if (fDialog.open() != null) {
            fileName = String.valueOf(fDialog.getFilterPath()) + System.getProperty("file.separator") + fDialog.getFileName();
        }
        return fileName;
    }

    private String openWorkspaceResourceFolderDialog() {
        String msg = "Select a folder.";
        IContainer container = null;
        IContainer[] containers = WorkspaceResourceDialog.openFolderSelection((Shell)this.getShell(), null, (String)msg, (boolean)false, null, new ArrayList());
        if (containers.length != 0) {
            container = containers[0];
        }
        if (container != null) {
            return container.getLocation().toOSString();
        }
        return "";
    }

    private String openWorkspaceResourceFileDialog() {
        String msg = "Select a file.";
        IFile file = null;
        IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)this.getShell(), null, (String)msg, (boolean)false, null, new ArrayList());
        if (files.length != 0) {
            file = files[0];
        }
        if (file != null) {
            return file.getLocation().toOSString();
        }
        return "";
    }

    private class ComboBoxListener
    extends SelectionAdapter
    implements SelectionListener {
        private ComboBoxListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            super.widgetSelected(e);
            String selectedText = ((Combo)e.getSource()).getText();
            MainConfigTab.this.setVisibleConfigurationOptions(selectedText);
        }
    }

    class FileSystemButtonSelectionAdapter
    extends SelectionAdapter {
        private Text field;

        public FileSystemButtonSelectionAdapter(Text field) {
            this.field = field;
        }

        public void widgetSelected(SelectionEvent e) {
            String resultOpenFolderDialog = MainConfigTab.this.openFileSystemFolderDialog();
            if (!resultOpenFolderDialog.equals(new String(""))) {
                this.field.setText(resultOpenFolderDialog);
            }
        }
    }

    class FileSystemFileButtonSelectionAdapter
    extends SelectionAdapter {
        private Text field;

        public FileSystemFileButtonSelectionAdapter(Text field) {
            this.field = field;
        }

        public void widgetSelected(SelectionEvent e) {
            String resultOpenFileDialog = MainConfigTab.this.openFileSystemFileDialog();
            if (!resultOpenFileDialog.equals(new String(""))) {
                this.field.setText(resultOpenFileDialog);
            }
        }
    }

    class WorkspaceButtonSelectionListener
    extends SelectionAdapter {
        private Text field;

        public WorkspaceButtonSelectionListener(Text field) {
            this.field = field;
        }

        public void widgetSelected(SelectionEvent e) {
            String resultOpenFolderDialog = MainConfigTab.this.openWorkspaceResourceFolderDialog();
            if (!resultOpenFolderDialog.equals(new String(""))) {
                this.field.setText(resultOpenFolderDialog);
            }
        }
    }

    class WorkspaceFileButtonSelectionListener
    extends SelectionAdapter {
        private Text field;

        public WorkspaceFileButtonSelectionListener(Text field) {
            this.field = field;
        }

        public void widgetSelected(SelectionEvent e) {
            String resultOpenFileDialog = MainConfigTab.this.openWorkspaceResourceFileDialog();
            if (!resultOpenFileDialog.equals(new String(""))) {
                this.field.setText(resultOpenFileDialog);
            }
        }
    }
}

