/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.transformations.pcm2lqn;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.solver.handler.LineServerHandler;
import org.palladiosimulator.solver.handler.LineServerHandlerFactory;
import org.palladiosimulator.solver.models.PCMInstance;
import org.palladiosimulator.solver.runconfig.PCMSolverWorkflowRunConfiguration;
import org.palladiosimulator.solver.transformations.ContextWrapper;
import org.palladiosimulator.solver.transformations.SolverStrategy;
import org.palladiosimulator.solver.transformations.pcm2lqn.LqnBuilder;
import org.palladiosimulator.solver.transformations.pcm2lqn.LqnXmlHandler;
import org.palladiosimulator.solver.transformations.pcm2lqn.Pcm2LqnHelper;
import org.palladiosimulator.solver.transformations.pcm2lqn.ResourceEnvironment2Lqn;
import org.palladiosimulator.solver.transformations.pcm2lqn.UsageModel2Lqn;
import org.palladiosimulator.solver.visitors.UsageModelVisitor;
import org.palladiosimulator.solver.visualisation.LQNHtmlResultGenerator;
import org.palladiosimulator.solver.visualisation.LQNResultEditorInput;

public class Pcm2LqnStrategy
implements SolverStrategy {
    private static Logger logger = Logger.getLogger((String)Pcm2LqnStrategy.class.getName());
    private String filenameInputXML;
    private String filenameResultHumanReadable;
    private String filenameResultXML;
    private static final String FILENAME_LQNS = "lqns";
    private static final String FILENAME_LQSIM = "lqsim";
    private static final String FILENAME_LINE = "LINE";
    public static final String LQN_FILE_EXTENSION = "lqxo";
    private static final int LQNS_RETURN_SUCCESS = 0;
    private static final int LQNS_RETURN_MODEL_FAILED_TO_CONVERGE = 1;
    private static final int LQNS_RETURN_INVALID_INPUT = 2;
    private static final int LQNS_RETURN_FATAL_ERROR = -1;
    private long overallDuration = 0L;
    private PCMSolverWorkflowRunConfiguration config;

    public Pcm2LqnStrategy(PCMSolverWorkflowRunConfiguration configuration) {
        this.config = configuration;
        SimpleDateFormat dateFormat = new SimpleDateFormat("-yyyy-MM-dd-HHmmss");
        Date date = new Date();
        String timestamp = dateFormat.format(date);
        this.filenameInputXML = String.valueOf(this.getOutputFolder()) + System.getProperty("file.separator") + "pcm2lqn" + timestamp + ".in." + LQN_FILE_EXTENSION;
        this.filenameResultHumanReadable = String.valueOf(this.getOutputFolder()) + System.getProperty("file.separator") + "pcm2lqn" + timestamp + ".out";
        this.filenameResultXML = String.valueOf(this.getOutputFolder()) + System.getProperty("file.separator") + "pcm2lqn" + timestamp + ".out." + LQN_FILE_EXTENSION;
    }

    public String getFilenameResultXML() {
        return this.filenameResultXML;
    }

    private String getOutputFolder() {
        if (this.getSolverProgramName().equals(FILENAME_LQNS)) {
            return this.config.getLqnsOutputDir();
        }
        if (this.getSolverProgramName().equals(FILENAME_LINE)) {
            return this.config.getLINEOutputDir();
        }
        return this.config.getLqsimOutputDir();
    }

    public Pcm2LqnStrategy() {
    }

    @Override
    public void loadTransformedModel(String fileName) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void solve() {
        String solverProgram = this.getSolverProgramName();
        String lqnsOutputType = this.getLqnsOutputTypeName();
        String lqnSimOutputType = this.getLqsimOutputTypeName();
        String options = "";
        String resultFile = "";
        String inputFile = "";
        long timeBeforeCalc = System.nanoTime();
        int exitVal = -1;
        String errorMessages = "";
        try {
            String command;
            block26: {
                block25: {
                    command = "";
                    if (!solverProgram.equals(FILENAME_LQNS) && !solverProgram.equals(FILENAME_LQSIM)) break block25;
                    String lqnOutputType = "";
                    if (solverProgram.equals(FILENAME_LQNS)) {
                        if (!this.config.getStopOnMessageLossLQNS() || !"".equals(this.config.getPragmas())) {
                            options = String.valueOf(options) + " -P ";
                            if (!this.config.getStopOnMessageLossLQNS()) {
                                options = String.valueOf(options) + "stop-on-message-loss=false ";
                            }
                            if (!"".equals(this.config.getPragmas())) {
                                options = String.valueOf(options) + this.config.getPragmas();
                            }
                        }
                        lqnOutputType = lqnsOutputType;
                    } else if (solverProgram.equals(FILENAME_LQSIM)) {
                        String blocks = this.config.getLQSimBlocks();
                        String runtime = this.config.getLQSimRuntime();
                        if (runtime != null && runtime != "") {
                            options = String.valueOf(options) + " -A " + runtime;
                        }
                        if (blocks != null && blocks != "") {
                            options = String.valueOf(options) + " -B " + blocks;
                        }
                        if (!this.config.getStopOnMessageLossLQSim()) {
                            options = String.valueOf(options) + " -P stop-on-message-loss=false";
                        }
                        lqnOutputType = lqnSimOutputType;
                    }
                    if (lqnOutputType.equals("Human Readable Output")) {
                        inputFile = this.filenameInputXML;
                        resultFile = this.filenameResultHumanReadable;
                        command = String.valueOf(solverProgram) + options + " -o" + resultFile + " " + inputFile;
                        break block26;
                    } else if (lqnOutputType.equals("XML Output") || lqnOutputType.equals("HTML Output")) {
                        inputFile = this.filenameInputXML;
                        resultFile = this.filenameResultXML;
                        command = String.valueOf(solverProgram) + options + " -x -o" + resultFile + " " + inputFile;
                    }
                    break block26;
                }
                if (solverProgram.equals(FILENAME_LINE)) {
                    inputFile = this.filenameInputXML;
                    resultFile = this.filenameResultXML;
                    this.fixXmlHeader(inputFile);
                    LineServerHandlerFactory.setLINEPropertyFile(this.config.getLINEPropFile());
                    LineServerHandler lineHandler = LineServerHandlerFactory.getHandler();
                    lineHandler.connectToLINEServer();
                    String inputFileAbsPath = new File(inputFile).getAbsolutePath();
                    lineHandler.solve(inputFileAbsPath, null);
                    while (true) {
                        if (lineHandler.isSolved(inputFileAbsPath)) {
                            lineHandler.terminateLine();
                            break;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            logger.error((Object)"Error watiting for LINE solution", (Throwable)e);
                        }
                    }
                }
            }
            if (!solverProgram.equals(FILENAME_LINE)) {
                this.fixXmlHeader(inputFile);
                logger.warn((Object)("Calling LQN analysis tool with " + command));
                ProcessBuilder pb = new ProcessBuilder(this.splitToCommandArray(command));
                pb.redirectErrorStream(true);
                Process proc = pb.start();
                errorMessages = this.readStream(proc.getInputStream());
                exitVal = proc.waitFor();
                proc.destroy();
            }
        }
        catch (Throwable e) {
            logger.error((Object)("Running " + solverProgram + " failed!"));
            throw new RuntimeException(e);
        }
        long timeAfterCalc = System.nanoTime();
        long duration = TimeUnit.NANOSECONDS.toMillis(timeAfterCalc - timeBeforeCalc);
        this.overallDuration += duration;
        logger.warn((Object)("Finished Running " + solverProgram + ":\t\t" + duration + " ms"));
        logger.warn((Object)("Completed Analysis:\t\t" + this.overallDuration + " ms overall"));
        if (solverProgram.equals(FILENAME_LINE)) {
            logger.info((Object)"Using the perfromance Engine Solver");
            logger.info((Object)("Exit val: " + exitVal));
            logger.info((Object)("Results written in: " + resultFile));
            return;
        }
        if (exitVal == 0) {
            if (errorMessages.contains("error")) {
                logger.error((Object)("LQN analysis threw errors: " + errorMessages));
                logger.warn((Object)("Trying to continue and writing results to " + resultFile));
            } else {
                logger.warn((Object)("Analysis Result has been written to " + resultFile));
            }
            logger.warn((Object)("Analysis Result has been written to " + resultFile));
            if (!lqnsOutputType.equals("HTML Output")) return;
            LQNHtmlResultGenerator result = new LQNHtmlResultGenerator(resultFile);
            result.display();
            return;
        }
        if (exitVal == 1) {
            logger.error((Object)(String.valueOf(solverProgram) + " exited with " + exitVal + ": The model failed to converge. Results are most likely inaccurate. "));
            logger.warn((Object)("Analysis Result has been written to: " + resultFile));
            return;
        }
        String message = "";
        message = exitVal == 2 ? String.valueOf(solverProgram) + " exited with " + exitVal + ": Invalid Input." : (exitVal == -1 ? String.valueOf(solverProgram) + " exited with " + exitVal + ": Fatal error" : String.valueOf(solverProgram) + " returned an unrecognised exit value " + exitVal + ". Key: 0 on success, 1 if the model failed to meet the convergence criteria, 2 if the input was invalid, 4 if a command line argument was incorrect, 8 for file read/write problems and -1 for fatal errors. If multiple input files are being processed, the exit code is the bit-wise OR of the above conditions.");
        message = String.valueOf(message) + "\nFurther errors: " + errorMessages;
        logger.error((Object)message);
        throw new RuntimeException(message);
    }

    private String getSolverProgramName() {
        if (this.config.getSolver().equals("LQNS (Layered Queueing Network Solver)")) {
            return FILENAME_LQNS;
        }
        if (this.config.getSolver().equals(FILENAME_LINE)) {
            return FILENAME_LINE;
        }
        return FILENAME_LQSIM;
    }

    private String getLqnsOutputTypeName() {
        return this.config.getLqnsOutput();
    }

    private String getLqsimOutputTypeName() {
        return this.config.getLqsimOutput();
    }

    public String getFilenameInputXML() {
        return this.filenameInputXML;
    }

    private void showOutput(String filename) {
        FileInputStream fis = null;
        byte[] b = null;
        try {
            fis = new FileInputStream(filename);
            int x = 0;
            x = fis.available();
            b = new byte[x];
            fis.read(b);
            fis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String content = new String(b);
        final String htmlText = this.getHtmlForLqnResult(content);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (page != null) {
                    try {
                        page.openEditor((IEditorInput)new LQNResultEditorInput(htmlText), "org.palladiosimulator.solver.LQNResultEditor");
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private String getHtmlForLqnResult(String lqnResult) {
        String htmlText = "<html><head><title>LQN Results</title></head><body><pre>" + lqnResult + "</pre></body></html>";
        return htmlText;
    }

    @Override
    public void storeTransformedModel(String fileName) {
    }

    @Override
    public void transform(PCMInstance model) {
        long startTime = System.nanoTime();
        this.runDSolver(model);
        long timeAfterDSolve = System.nanoTime();
        long duration = TimeUnit.NANOSECONDS.toMillis(timeAfterDSolve - startTime);
        this.overallDuration += duration;
        logger.warn((Object)("Finished DSolver:\t\t" + duration + " ms"));
        long timeBeforeTransform = System.nanoTime();
        this.runPcm2Lqn(model);
        long timeAfterTransform = System.nanoTime();
        long duration2 = TimeUnit.NANOSECONDS.toMillis(timeAfterTransform - timeBeforeTransform);
        this.overallDuration += duration2;
        logger.warn((Object)("Finished PCM2LQN:\t\t" + duration2 + " ms"));
    }

    private void runPcm2Lqn(PCMInstance model) {
        LqnBuilder lqnBuilder = new LqnBuilder(this.config.isInfiniteTaskMultiplicity());
        if (this.getSolverProgramName().equals(FILENAME_LQSIM)) {
            lqnBuilder.setIsLQSimAnalysis(true);
        }
        ResourceEnvironment2Lqn reVisitor = new ResourceEnvironment2Lqn(lqnBuilder, this.config);
        reVisitor.doSwitch((EObject)model.getResourceEnvironment());
        UsageModel2Lqn umVisitor = new UsageModel2Lqn(lqnBuilder, new ContextWrapper(model));
        umVisitor.doSwitch((EObject)model.getUsageModel());
        lqnBuilder.finalizeLqnModel(this.config);
        LqnXmlHandler lqnXmlHandler = new LqnXmlHandler(lqnBuilder.getLqnModel());
        lqnXmlHandler.saveModelToXMI(this.filenameInputXML);
        Pcm2LqnHelper.clearGuidMap();
    }

    private void runDSolver(PCMInstance model) {
        UsageModelVisitor visitor = new UsageModelVisitor(model);
        EList scenarios = model.getUsageModel().getUsageScenario_UsageModel();
        for (UsageScenario usageScenario : scenarios) {
            visitor.doSwitch((EObject)usageScenario.getScenarioBehaviour_UsageScenario());
        }
    }

    private String readStream(InputStream is) {
        String errorMessages = "";
        try {
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.contains("warning")) {
                    if (!this.isDebug()) continue;
                    logger.debug((Object)line);
                    continue;
                }
                logger.warn((Object)line);
                errorMessages = String.valueOf(errorMessages) + line + "\n";
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return errorMessages;
    }

    private String[] splitToCommandArray(String command) {
        return command.split("\\s");
    }

    private boolean isDebug() {
        int level = this.config.getDebugLevel();
        return level <= 1;
    }

    private void fixXmlHeader(String inputFile) throws FileNotFoundException, IOException {
        FileReader fr = new FileReader(inputFile);
        BufferedReader br = new BufferedReader(fr);
        br.readLine();
        ArrayList<String> content = new ArrayList<String>();
        String line = br.readLine();
        while (line != null) {
            content.add(String.valueOf(line) + "\n");
            line = br.readLine();
        }
        br.close();
        fr.close();
        File f = new File(inputFile);
        f.delete();
        File recordFile = new File(inputFile);
        FileWriter recordFw = new FileWriter(recordFile);
        BufferedWriter recordBw = new BufferedWriter(recordFw);
        recordBw.write("<?xml version=\"1.0\" encoding=\"us-ascii\"?>\n");
        recordBw.flush();
        for (String s : content) {
            recordBw.write(s);
            recordBw.flush();
        }
        recordBw.close();
        recordFw.close();
    }
}

