/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.visitors;

import de.uka.ipd.sdq.stoex.Expression;
import de.uka.ipd.sdq.stoex.analyser.visitors.ExpressionInferTypeVisitor;
import de.uka.ipd.sdq.stoex.analyser.visitors.StoExPrettyPrintVisitor;
import de.uka.ipd.sdq.stoex.analyser.visitors.TypeEnum;
import java.util.Arrays;
import java.util.HashMap;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.stochasticexpressions.parser.PCMStoExLexer;
import org.palladiosimulator.pcm.stochasticexpressions.parser.PCMStoExParser;
import org.palladiosimulator.solver.transformations.ContextWrapper;
import org.palladiosimulator.solver.transformations.ExpressionToPDFWrapper;
import org.palladiosimulator.solver.visitors.ExpressionParameterSolverVisitor;

public class ExpressionHelper {
    private static Logger logger = Logger.getLogger((String)ExpressionHelper.class.getName());

    public static Expression parseToExpression(String specification) {
        Expression expression = null;
        PCMStoExLexer lexer = new PCMStoExLexer((CharStream)new ANTLRStringStream(specification));
        PCMStoExParser parser = new PCMStoExParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        try {
            expression = parser.expression();
        }
        catch (RecognitionException e) {
            e.printStackTrace();
        }
        return expression;
    }

    public static String getSolvedExpressionAsString(String specification, ContextWrapper ctxWrp) {
        Expression solvedExpression = ExpressionHelper.getSolvedExpression(specification, ctxWrp);
        String solvedExprString = ((StringBuilder)new StoExPrettyPrintVisitor().doSwitch((EObject)solvedExpression)).toString();
        if (solvedExpression == null) {
            throw new RuntimeException("Could not print solved expression " + specification);
        }
        return solvedExprString;
    }

    public static Expression getSolvedExpression(String specification, ContextWrapper ctxWrp) {
        Expression expr = ExpressionHelper.parseToExpression(specification);
        return ExpressionHelper.getSolvedExpression(expr, ctxWrp);
    }

    public static Expression getSolvedExpression(Expression expr, ContextWrapper ctxWrp) {
        ExpressionInferTypeVisitor inferTypeVisitor = new ExpressionInferTypeVisitor();
        try {
            inferTypeVisitor.doSwitch((EObject)expr);
        }
        catch (UnsupportedOperationException e) {
            logger.error((Object)("Infering the type failed with an " + e.getClass().getName() + ". I will try to ignore this and continue. Details:\n" + e.getMessage() + "\n" + Arrays.toString(e.getStackTrace())));
            e.printStackTrace();
        }
        HashMap typeAnnotation = inferTypeVisitor.getTypeAnnotation();
        ExpressionParameterSolverVisitor solveVisitor = new ExpressionParameterSolverVisitor(typeAnnotation, ctxWrp);
        return (Expression)solveVisitor.doSwitch((EObject)expr);
    }

    public static HashMap<Expression, TypeEnum> getTypeAnnotation(Expression expr) {
        ExpressionInferTypeVisitor inferTypeVisitor = new ExpressionInferTypeVisitor();
        inferTypeVisitor.doSwitch((EObject)expr);
        return inferTypeVisitor.getTypeAnnotation();
    }

    public static double meanValue(Expression expression) throws IllegalArgumentException {
        ExpressionToPDFWrapper wrapper = ExpressionToPDFWrapper.createExpressionToPDFWrapper(expression);
        return wrapper.getMeanValue();
    }

    public static double getMeanValue(PCMRandomVariable variable) {
        ExpressionToPDFWrapper expToPDF = ExpressionToPDFWrapper.createExpressionToPDFWrapper(variable.getExpression());
        return expToPDF.getMeanValue();
    }
}

