/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.visitors;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.seff.AbstractBranchTransition;
import org.palladiosimulator.pcm.seff.AbstractInternalControlFlowAction;
import org.palladiosimulator.pcm.seff.AcquireAction;
import org.palladiosimulator.pcm.seff.BranchAction;
import org.palladiosimulator.pcm.seff.CollectionIteratorAction;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.ForkAction;
import org.palladiosimulator.pcm.seff.GuardedBranchTransition;
import org.palladiosimulator.pcm.seff.InternalAction;
import org.palladiosimulator.pcm.seff.LoopAction;
import org.palladiosimulator.pcm.seff.ProbabilisticBranchTransition;
import org.palladiosimulator.pcm.seff.ReleaseAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.SetVariableAction;
import org.palladiosimulator.pcm.seff.StartAction;
import org.palladiosimulator.pcm.seff.StopAction;
import org.palladiosimulator.pcm.seff.seff_reliability.RecoveryAction;
import org.palladiosimulator.pcm.seff.util.SeffSwitch;
import org.palladiosimulator.solver.handler.CollectionIteratorActionHandler;
import org.palladiosimulator.solver.handler.ExternalCallActionHandler;
import org.palladiosimulator.solver.handler.ForkActionHandler;
import org.palladiosimulator.solver.handler.GuardedBranchTransitionHandler;
import org.palladiosimulator.solver.handler.InternalActionHandler;
import org.palladiosimulator.solver.handler.LoopActionHandler;
import org.palladiosimulator.solver.handler.ProbabilisticBranchTransitionHandler;
import org.palladiosimulator.solver.handler.RecoveryBlockActionHandler;
import org.palladiosimulator.solver.handler.SetVariableActionHandler;
import org.palladiosimulator.solver.transformations.ContextWrapper;
import org.palladiosimulator.solver.visitors.EMFQueryHelper;

public class SeffVisitor
extends SeffSwitch {
    private static Logger logger = Logger.getLogger((String)SeffVisitor.class.getName());
    private CollectionIteratorActionHandler collectionIteratorHandler;
    private ExternalCallActionHandler externalCallHandler;
    private ForkActionHandler forkHandler;
    private GuardedBranchTransitionHandler guardedBranchHandler;
    private InternalActionHandler internalActionHandler;
    private LoopActionHandler loopHandler;
    private ProbabilisticBranchTransitionHandler probabilisticBranchHandler;
    private RecoveryBlockActionHandler recoveryBlockHandler;
    private SetVariableActionHandler setVariableHandler;
    protected ContextWrapper contextWrapper;

    public SeffVisitor(ContextWrapper wrapper) {
        this.contextWrapper = wrapper;
        this.externalCallHandler = new ExternalCallActionHandler(this);
        this.internalActionHandler = new InternalActionHandler(this);
        this.guardedBranchHandler = new GuardedBranchTransitionHandler(this);
        this.probabilisticBranchHandler = new ProbabilisticBranchTransitionHandler(this);
        this.collectionIteratorHandler = new CollectionIteratorActionHandler(this);
        this.loopHandler = new LoopActionHandler(this);
        this.setVariableHandler = new SetVariableActionHandler(this);
        this.recoveryBlockHandler = new RecoveryBlockActionHandler(this);
        this.forkHandler = new ForkActionHandler(this);
    }

    public Object caseAbstractInternalControlFlowAction(AbstractInternalControlFlowAction action) {
        if (action instanceof RecoveryAction) {
            logger.debug((Object)("Visit " + action.getClass().getSimpleName() + " \"" + action.getEntityName() + "\""));
            this.recoveryBlockHandler.handle((RecoveryAction)action);
            this.doSwitch((EObject)action.getSuccessor_AbstractAction());
            return action;
        }
        return null;
    }

    public Object caseAcquireAction(AcquireAction action) {
        logger.debug((Object)("Visit " + action.getClass().getSimpleName() + " \"" + action.getEntityName() + "\""));
        this.doSwitch((EObject)action.getSuccessor_AbstractAction());
        return action;
    }

    public Object caseBranchAction(BranchAction action) {
        logger.debug((Object)("Visit " + action.getClass().getSimpleName() + " \"" + action.getEntityName() + "\""));
        EList abtList = action.getBranches_Branch();
        for (AbstractBranchTransition abt : abtList) {
            this.doSwitch((EObject)abt);
        }
        this.doSwitch((EObject)action.getSuccessor_AbstractAction());
        return action;
    }

    public Object caseCollectionIteratorAction(CollectionIteratorAction action) {
        logger.debug((Object)("Visit " + action.getClass().getSimpleName() + " \"" + action.getEntityName() + "\""));
        this.collectionIteratorHandler.handle(action);
        this.doSwitch((EObject)action.getSuccessor_AbstractAction());
        return action;
    }

    public Object caseExternalCallAction(ExternalCallAction action) {
        logger.debug((Object)("Visit " + action.getClass().getSimpleName() + " \"" + action.getEntityName() + "\""));
        this.externalCallHandler.handle(action);
        this.doSwitch((EObject)action.getSuccessor_AbstractAction());
        return action;
    }

    public Object caseForkAction(ForkAction action) {
        logger.debug((Object)("Visit " + action.getClass().getSimpleName() + " \"" + action.getEntityName() + "\""));
        this.forkHandler.handle(action);
        this.doSwitch((EObject)action.getSuccessor_AbstractAction());
        return action;
    }

    public Object caseGuardedBranchTransition(GuardedBranchTransition transition) {
        this.guardedBranchHandler.handle(transition);
        return transition;
    }

    public Object caseInternalAction(InternalAction action) {
        logger.debug((Object)("Visit " + action.getClass().getSimpleName() + " \"" + action.getEntityName() + "\""));
        this.internalActionHandler.handle(action);
        this.doSwitch((EObject)action.getSuccessor_AbstractAction());
        return action;
    }

    public Object caseLoopAction(LoopAction action) {
        logger.debug((Object)("Visit " + action.getClass().getSimpleName() + " \"" + action.getEntityName() + "\""));
        this.loopHandler.handle(action);
        this.doSwitch((EObject)action.getSuccessor_AbstractAction());
        return action;
    }

    public Object caseProbabilisticBranchTransition(ProbabilisticBranchTransition transition) {
        this.probabilisticBranchHandler.handle(transition);
        return transition;
    }

    public Object caseReleaseAction(ReleaseAction action) {
        logger.debug((Object)("Visit " + action.getClass().getSimpleName() + " \"" + action.getEntityName() + "\""));
        this.doSwitch((EObject)action.getSuccessor_AbstractAction());
        return action;
    }

    public Object caseResourceDemandingBehaviour(ResourceDemandingBehaviour behaviour) {
        this.doSwitch((EObject)this.getStartAction(behaviour));
        return behaviour;
    }

    public Object caseResourceDemandingSEFF(ResourceDemandingSEFF behaviour) {
        ResourceDemandingSEFF rdb = behaviour;
        this.doSwitch((EObject)this.getStartAction((ResourceDemandingBehaviour)rdb));
        return behaviour;
    }

    public Object caseSetVariableAction(SetVariableAction action) {
        logger.debug((Object)("Visit " + action.getClass().getSimpleName() + " \"" + action.getEntityName() + "\""));
        this.setVariableHandler.handle(action);
        this.doSwitch((EObject)action.getSuccessor_AbstractAction());
        return action;
    }

    public Object caseStartAction(StartAction action) {
        logger.debug((Object)("Visit " + action.getClass().getSimpleName() + " \"" + action.getEntityName() + "\""));
        this.doSwitch((EObject)action.getSuccessor_AbstractAction());
        return action;
    }

    public Object caseStopAction(StopAction action) {
        logger.debug((Object)("Visit " + action.getClass().getSimpleName() + " \"" + action.getEntityName() + "\""));
        if (action.eContainer() instanceof ResourceDemandingSEFF) {
            this.saveContexts();
        }
        return action;
    }

    public ContextWrapper getContextWrapper() {
        return this.contextWrapper;
    }

    public void setContextWrapper(ContextWrapper wrapper) {
        this.contextWrapper = wrapper;
    }

    private StartAction getStartAction(ResourceDemandingBehaviour behaviour) {
        StartAction startAction = (StartAction)EMFQueryHelper.getObjectByType(behaviour.getSteps_Behaviour(), StartAction.class);
        return startAction;
    }

    private void saveContexts() {
    }
}

