/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.builder;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.jgrapht.Graph;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.ComposedStructure;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector;
import org.palladiosimulator.pcm.core.composition.RequiredDelegationConnector;
import org.palladiosimulator.pcm.core.entity.ComposedProvidingRequiringEntity;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.somox.analyzer.simplemodelanalyzer.builder.AssemblyConnectorBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.IAssemblyConnectorStrategy;
import org.somox.metrics.ClusteringRelation;
import org.somox.sourcecodedecorator.ComponentImplementingClassesLink;

public class AssemblyConnectorsInsideCompositeComponentStrategy
implements IAssemblyConnectorStrategy {
    private static final Logger logger = Logger.getLogger(AssemblyConnectorsInsideCompositeComponentStrategy.class);

    @Deprecated
    public AssemblyConnectorsInsideCompositeComponentStrategy(AssemblyConnectorBuilder connectorBuilder) {
    }

    public AssemblyConnectorsInsideCompositeComponentStrategy() {
    }

    @Override
    public void buildAssemblyConnectors(ComponentImplementingClassesLink compositeComponentCandidate, Graph<ComponentImplementingClassesLink, ClusteringRelation> compositeComponentSubgraph) {
        if (!(compositeComponentCandidate.getComponent() instanceof ComposedProvidingRequiringEntity)) {
            throw new IllegalArgumentException("must be a ComposedProvidingRequiringEntity!");
        }
        ComposedProvidingRequiringEntity outerComposite = (ComposedProvidingRequiringEntity)compositeComponentCandidate.getComponent();
        this.establishAssemblyConnectorsForNonConnectedPorts(outerComposite, (List<ComponentImplementingClassesLink>)compositeComponentCandidate.getSubComponents());
    }

    @Override
    public void buildAssemblyConnectors(ComposedProvidingRequiringEntity compositeStructure, List<ComponentImplementingClassesLink> subComponents) {
        this.establishAssemblyConnectorsForNonConnectedPorts(compositeStructure, subComponents);
    }

    private void establishAssemblyConnectorsForNonConnectedPorts(ComposedProvidingRequiringEntity outerComposite, List<ComponentImplementingClassesLink> subComponents) {
        for (ComponentImplementingClassesLink component : subComponents) {
            for (RequiredRole requiredRole : component.getComponent().getRequiredRoles_InterfaceRequiringEntity()) {
                if (this.isBoundInConnector((EList<Connector>)outerComposite.getConnectors__ComposedStructure(), requiredRole)) continue;
                this.findMatchingProvidedPortAndCreateAssemblyConnector(subComponents, (ComposedStructure)outerComposite, component, requiredRole);
            }
        }
    }

    private void findMatchingProvidedPortAndCreateAssemblyConnector(List<ComponentImplementingClassesLink> subComponents, ComposedStructure outerComposite, ComponentImplementingClassesLink requiringComponent, RequiredRole requiredRole) {
        for (ComponentImplementingClassesLink providingComponent : subComponents) {
            for (ProvidedRole providedRole : providingComponent.getComponent().getProvidedRoles_InterfaceProvidingEntity()) {
                if (requiredRole instanceof OperationRequiredRole && providedRole instanceof OperationProvidedRole) {
                    OperationRequiredRole opReqRole = (OperationRequiredRole)requiredRole;
                    OperationProvidedRole opProvRole = (OperationProvidedRole)providedRole;
                    if (!opReqRole.getRequiredInterface__OperationRequiredRole().equals(opProvRole.getProvidedInterface__OperationProvidedRole())) continue;
                    Connector newAssemblyConnector = AssemblyConnectorBuilder.createAssemblyConnector(outerComposite, opReqRole, opProvRole, requiringComponent.getComponent(), providingComponent.getComponent());
                    outerComposite.getConnectors__ComposedStructure().add((Object)newAssemblyConnector);
                    continue;
                }
                logger.warn((Object)("Provided role type: " + providedRole.getClass().getSimpleName() + " and required role type: " + requiredRole.getClass().getSimpleName() + " not yet supported"));
            }
        }
    }

    private boolean isBoundInConnector(EList<Connector> connectors, RequiredRole requiredRole) {
        for (Connector connector : connectors) {
            if (connector instanceof AssemblyConnector) {
                AssemblyConnector assemblyConnector = (AssemblyConnector)connector;
                if (!assemblyConnector.getRequiredRole_AssemblyConnector().equals(requiredRole)) continue;
                return true;
            }
            if (connector instanceof ProvidedDelegationConnector) continue;
            if (connector instanceof RequiredDelegationConnector) {
                RequiredDelegationConnector reqDelegationConnector = (RequiredDelegationConnector)connector;
                if (!reqDelegationConnector.getInnerRequiredRole_RequiredDelegationConnector().equals(requiredRole)) continue;
                return true;
            }
            logger.warn((Object)("Connector type " + connector.getClass().getSimpleName() + " not yet supported."));
        }
        return false;
    }
}

