/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.builder;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.gmt.modisco.java.ASTNode;
import org.eclipse.gmt.modisco.java.Type;
import org.eclipse.modisco.java.composition.javaapplication.JavaNodeSourceRegion;
import org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector;
import org.palladiosimulator.pcm.core.composition.RequiredDelegationConnector;
import org.palladiosimulator.pcm.repository.Interface;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.somox.kdmhelper.KDMHelper;
import org.somox.kdmhelper.metamodeladdition.Root;
import org.somox.sourcecodedecorator.ComponentImplementingClassesLink;

public class ComponentAndTypeNaming {
    private final Logger logger = Logger.getLogger(ComponentAndTypeNaming.class);
    private int compositeComponentNumber = 0;
    private int primitiveComponentNumber = 1;
    private final int requiredPortNumber;
    private int providedPortNumber;
    private final int MAXIMUM_NAME_LENGTH = 55;
    private final int MAX_NUMBER_OF_PATH_SEGMENTS_IN_INTERFACE_NAME = 3;

    public ComponentAndTypeNaming() {
        this.requiredPortNumber = 1;
    }

    @Deprecated
    public String createSimpleComponentName(int i, Type astClass) {
        return "Comp. " + i + ": " + astClass.getName();
    }

    public String createSimpleComponentName(List<Type> astClasses, boolean shorten) {
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append("<PC#" + this.primitiveComponentNumber++);
        StringBuilder subComponentNames = new StringBuilder();
        for (Type astClass : astClasses) {
            subComponentNames.append(" " + KDMHelper.computeFullQualifiedName((ASTNode)astClass));
        }
        if (shorten) {
            nameBuilder.append(this.shorten(subComponentNames.toString()));
        } else {
            nameBuilder.append((CharSequence)subComponentNames);
        }
        nameBuilder.append(">");
        return nameBuilder.toString();
    }

    public String createSimpleComponentName(Type astClass) {
        return String.valueOf(KDMHelper.computeFullQualifiedName((ASTNode)astClass)) + " <PC No. " + this.primitiveComponentNumber++ + ">";
    }

    public String createSimpleComponentName(int i, List<ComponentImplementingClassesLink> currentList) {
        StringBuilder sb = new StringBuilder();
        for (ComponentImplementingClassesLink currentClassesLinkList : currentList) {
            for (Type currentClass : currentClassesLinkList.getImplementingClasses()) {
                sb.append(String.valueOf(currentClass.getName()) + " ");
            }
        }
        String name = "Comp No. " + i + " " + sb.toString();
        return this.shorten(name);
    }

    public String createCompositeComponentName(Collection<ComponentImplementingClassesLink> innerComponents) {
        return this.createCompositeComponentName(innerComponents, true);
    }

    public String createCompositeComponentName(Collection<ComponentImplementingClassesLink> innerComponents, boolean shorten) {
        ++this.compositeComponentNumber;
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append("CC#");
        nameBuilder.append(String.valueOf(this.compositeComponentNumber) + " ");
        nameBuilder.append(this.createComponentNameBasedOnPackageName(this.compositeComponentNumber, innerComponents));
        nameBuilder.append(" <");
        StringBuilder subComponentName = new StringBuilder();
        for (ComponentImplementingClassesLink subcomponent : innerComponents) {
            if (subcomponent.getComponent() != null) {
                subComponentName.append(String.valueOf(subcomponent.getComponent().getEntityName()) + " ");
                continue;
            }
            subComponentName.append(String.valueOf(this.createSimpleComponentName(0, (List<ComponentImplementingClassesLink>)subcomponent.getSubComponents())) + " ");
        }
        subComponentName.deleteCharAt(subComponentName.length() - 1);
        if (shorten) {
            nameBuilder.append(this.shorten(subComponentName.toString(), true));
        } else {
            nameBuilder.append(subComponentName.toString());
        }
        nameBuilder.append(">");
        return nameBuilder.toString();
    }

    private String createComponentNameBasedOnPackageName(int i, Collection<ComponentImplementingClassesLink> currentList) {
        String compName;
        String returnComponentName = "";
        HashMap<String, Integer> numberOfPackageNames = new HashMap<String, Integer>();
        HashMap<String, String> packageNames = new HashMap<String, String>();
        String maxNumberPackageId = null;
        String directoryName = "";
        int maxNumber = 0;
        for (ComponentImplementingClassesLink currentClassesLink : currentList) {
            for (Type currentClass : currentClassesLink.getImplementingClasses()) {
                if (KDMHelper.getSurroundingPackage((Type)currentClass) != null) {
                    Integer tmpNumber = (Integer)numberOfPackageNames.get(Root.getIdForPackage((ASTNode)KDMHelper.getSurroundingPackage((Type)currentClass)));
                    if (tmpNumber != null) {
                        tmpNumber = tmpNumber + 1;
                        numberOfPackageNames.put(Root.getIdForPackage((ASTNode)KDMHelper.getSurroundingPackage((Type)currentClass)), tmpNumber);
                        if (tmpNumber <= maxNumber) continue;
                        maxNumber = tmpNumber;
                        maxNumberPackageId = Root.getIdForPackage((ASTNode)KDMHelper.getSurroundingPackage((Type)currentClass));
                        continue;
                    }
                    numberOfPackageNames.put(Root.getIdForPackage((ASTNode)KDMHelper.getSurroundingPackage((Type)currentClass)), 1);
                    packageNames.put(Root.getIdForPackage((ASTNode)KDMHelper.getSurroundingPackage((Type)currentClass)), KDMHelper.computeFullQualifiedName((ASTNode)KDMHelper.getSurroundingPackage((Type)currentClass)));
                    if (1 <= maxNumber) continue;
                    maxNumber = 1;
                    maxNumberPackageId = Root.getIdForPackage((ASTNode)KDMHelper.getSurroundingPackage((Type)currentClass));
                    continue;
                }
                if (KDMHelper.getJavaNodeSourceRegion((ASTNode)currentClass) != null && KDMHelper.getSourceFile((JavaNodeSourceRegion)KDMHelper.getJavaNodeSourceRegion((ASTNode)currentClass)) != null) {
                    directoryName = KDMHelper.getSourceFile((JavaNodeSourceRegion)KDMHelper.getJavaNodeSourceRegion((ASTNode)currentClass)).getPath();
                    continue;
                }
                this.logger.warn((Object)("found neither packages nor directories for GAST class " + KDMHelper.computeFullQualifiedName((ASTNode)currentClass)));
            }
        }
        returnComponentName = "";
        if (maxNumber > 0 && (compName = (String)packageNames.get(maxNumberPackageId)) != null) {
            returnComponentName = String.valueOf(returnComponentName) + compName;
        }
        if (!directoryName.equals("")) {
            returnComponentName = String.valueOf(returnComponentName) + "(dir: " + directoryName + ")";
        }
        return this.shorten(returnComponentName);
    }

    public String createComponentInstanceName(RepositoryComponent repositoryComponent) {
        if (repositoryComponent != null) {
            return String.valueOf(repositoryComponent.getEntityName()) + "-instance";
        }
        return "class-level-instance";
    }

    public String createProvidedPortName(Interface provInterface, RepositoryComponent component) {
        String ifName = provInterface.getEntityName();
        if (ifName.contains(".")) {
            String[] subStrings = ifName.split("\\.", 0);
            ifName = subStrings[subStrings.length - 1];
        }
        return String.valueOf(this.shorten(ifName)) + " (prov)";
    }

    public String createProvidedSystemPortName(Interface provInterface, RepositoryComponent component) {
        return String.valueOf(this.createProvidedPortName(provInterface, component)) + "(sys)";
    }

    public String createRequiredPortName(Interface reqInterface, RepositoryComponent component) {
        String ifName = reqInterface.getEntityName();
        if (ifName.contains(".")) {
            String[] subStrings = ifName.split("\\.", 0);
            ifName = subStrings[subStrings.length - 1];
        }
        return String.valueOf(this.shorten(ifName)) + " (req)";
    }

    public String createRequiredSystemPortName(Interface reqInterface, RepositoryComponent component) {
        return String.valueOf(this.createRequiredPortName(reqInterface, component)) + "(sys)";
    }

    public String createInterfaceName(Type interfaceClass) {
        String interfaceName = this.segmentBasedInterfaceName(KDMHelper.computeFullQualifiedName((ASTNode)interfaceClass));
        return this.shorten(interfaceName, true);
    }

    public String createInterfaceNameForClass(Type interfaceClass) {
        String interfaceName = this.segmentBasedInterfaceName(KDMHelper.computeFullQualifiedName((ASTNode)interfaceClass));
        return "I" + this.shorten(interfaceName, true);
    }

    private String segmentBasedInterfaceName(String qualifiedName) {
        String[] segments = qualifiedName.split("\\.");
        String interfaceName = "";
        boolean first = true;
        int i = 3;
        while (i > 0) {
            if (segments.length >= i) {
                if (!first) {
                    interfaceName = String.valueOf(interfaceName) + ".";
                }
                interfaceName = String.valueOf(interfaceName) + segments[segments.length - i];
                first = false;
            }
            --i;
        }
        return interfaceName;
    }

    private String shorten(String theString, boolean removeStartOfString) {
        String name = theString;
        if (theString.length() > 55) {
            name = removeStartOfString ? "..." + theString.substring(theString.length() - 55 + 3, theString.length()) : String.valueOf(theString.substring(0, 52)) + "...";
        }
        return name;
    }

    private String shorten(String theString) {
        return this.shorten(theString, false);
    }

    public void createProvidedDelegationConnectorName(ProvidedDelegationConnector delegationConnector) {
        delegationConnector.setEntityName(delegationConnector.getInnerProvidedRole_ProvidedDelegationConnector().getProvidedInterface__OperationProvidedRole().getEntityName());
    }

    public void createRequiredDelegationConnectorName(RequiredDelegationConnector delegationConnector) {
        delegationConnector.setEntityName(delegationConnector.getInnerRequiredRole_RequiredDelegationConnector().getRequiredInterface__OperationRequiredRole().getEntityName());
    }
}

