/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmt.modisco.java.ASTNode;
import org.eclipse.gmt.modisco.java.ParameterizedType;
import org.eclipse.gmt.modisco.java.Type;
import org.eclipse.gmt.modisco.java.TypeAccess;
import org.eclipse.gmt.modisco.java.emf.JavaPackage;
import org.palladiosimulator.pcm.core.entity.ComposedProvidingRequiringEntity;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.Interface;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Role;
import org.somox.analyzer.AnalysisResult;
import org.somox.analyzer.simplemodelanalyzer.builder.AbstractBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.AssemblyConnectorsInsideCompositeComponentStrategy;
import org.somox.analyzer.simplemodelanalyzer.builder.ComponentAndTypeNaming;
import org.somox.analyzer.simplemodelanalyzer.builder.OperationBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.Seff2JavaASTBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.util.InterfacePortBuilderHelper;
import org.somox.analyzer.simplemodelanalyzer.detection.ComponentInterfaceStrategy;
import org.somox.analyzer.simplemodelanalyzer.detection.IComponentInterfaceStrategy;
import org.somox.analyzer.simplemodelanalyzer.detection.util.AccessFilter;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.filter.EClassBasedFilter;
import org.somox.kdmhelper.KDMHelper;
import org.somox.kdmhelper.metamodeladdition.Root;
import org.somox.sourcecodedecorator.ComponentImplementingClassesLink;
import org.somox.sourcecodedecorator.InterfaceSourceCodeLink;
import org.somox.sourcecodedecorator.SourceCodeDecoratorFactory;

public class InterfaceBuilder
extends AbstractBuilder {
    private final Map<Type, OperationInterface> alreadyCreatedInterfaces = new HashMap<Type, OperationInterface>();
    private static Logger logger = Logger.getLogger(InterfaceBuilder.class);
    private OperationBuilder operationBuilder = null;
    private Seff2JavaASTBuilder behaviourBuilder = null;
    private ComponentAndTypeNaming naming = null;
    private IComponentInterfaceStrategy interfaceStrategy = null;
    public static final boolean PROVIDED_INTERFACE = true;

    public InterfaceBuilder(Root gastModel, SoMoXConfiguration configuration, AnalysisResult result) {
        super(gastModel, configuration, result);
        logger.debug((Object)"Interface builder initialised");
        this.operationBuilder = new OperationBuilder(gastModel, configuration, result);
        this.behaviourBuilder = new Seff2JavaASTBuilder(gastModel, configuration, result);
        this.naming = new ComponentAndTypeNaming();
        this.interfaceStrategy = new ComponentInterfaceStrategy(result.getSourceCodeDecoratorRepository());
    }

    public boolean findAndAddRequiredInterfaces(ComponentImplementingClassesLink componentCandidate) {
        boolean addedARequiredInterface = false;
        EClassBasedFilter accessFilter = new EClassBasedFilter(new EClass[]{JavaPackage.eINSTANCE.getThisExpression(), JavaPackage.eINSTANCE.getSuperFieldAccess()});
        LinkedList<Type> filteredAccessedClasses = new LinkedList<Type>();
        LinkedList<Type> componentClasses = new LinkedList<Type>();
        for (Type clazz : componentCandidate.getImplementingClasses()) {
            filteredAccessedClasses.addAll(AccessFilter.filterAccessList(KDMHelper.getAllAccesses((ASTNode)clazz), (EClassBasedFilter<ASTNode>)accessFilter));
            componentClasses.add(clazz);
        }
        filteredAccessedClasses.removeAll(componentClasses);
        for (Type accessedClass : this.somoxConfiguration.getBlacklistFilter().filter(filteredAccessedClasses)) {
            OperationInterface reqInterface;
            if (!this.interfaceStrategy.isComponentInterface(accessedClass) || this.doesComponentAlreadyRequireInterface((Interface)(reqInterface = this.createInterface(null, accessedClass)), componentCandidate.getComponent())) continue;
            this.createRequiredPort(componentCandidate.getComponent(), reqInterface);
            this.updateInterfacesInSourceCodeDecorator(componentCandidate, (Interface)reqInterface, accessedClass, false);
            addedARequiredInterface = true;
        }
        if (!componentCandidate.isCompositeComponent()) {
            this.removeInterfaceSelfAccesses(componentCandidate);
        }
        return addedARequiredInterface;
    }

    public void addProvidedInterfaces(ComponentImplementingClassesLink componentCandidate) {
        if (componentCandidate.isCompositeComponent()) {
            throw new IllegalArgumentException("This method can only be called on primitive components");
        }
        for (Type gastClass : componentCandidate.getImplementingClasses()) {
            for (Type superType : this.somoxConfiguration.getBlacklistFilter().filter((Iterable)KDMHelper.getSuperTypes((Type)gastClass))) {
                this.createInterfaceForSupertype(componentCandidate, gastClass, superType);
            }
        }
        if (componentCandidate.getComponent().getProvidedRoles_InterfaceProvidingEntity().isEmpty()) {
            this.assignPublicMethodsAsInterfaceForComponentsWithoutInterface(componentCandidate);
        }
    }

    private void createRequiredPort(RepositoryComponent component, OperationInterface reqInterface) {
        OperationRequiredRole requiredRole = RepositoryFactory.eINSTANCE.createOperationRequiredRole();
        requiredRole.setEntityName(this.naming.createRequiredPortName((Interface)reqInterface, component));
        requiredRole.setRequiredInterface__OperationRequiredRole(reqInterface);
        component.getRequiredRoles_InterfaceRequiringEntity().add((Object)requiredRole);
    }

    private ProvidedRole createProvidedPort(OperationInterface theInterface, RepositoryComponent component) {
        OperationProvidedRole providedRole = RepositoryFactory.eINSTANCE.createOperationProvidedRole();
        providedRole.setEntityName(this.naming.createProvidedPortName((Interface)theInterface, component));
        providedRole.setProvidedInterface__OperationProvidedRole(theInterface);
        component.getProvidedRoles_InterfaceProvidingEntity().add((Object)providedRole);
        return providedRole;
    }

    private boolean doesComponentAlreadyRequireInterface(Interface theInterface, RepositoryComponent component) {
        for (RequiredRole role : component.getRequiredRoles_InterfaceRequiringEntity()) {
            if (role instanceof OperationRequiredRole) {
                OperationRequiredRole opReqRole = (OperationRequiredRole)role;
                OperationInterface opInterface = opReqRole.getRequiredInterface__OperationRequiredRole();
                if (!opInterface.equals(theInterface)) continue;
                return true;
            }
            logger.warn((Object)("Role type not yet supported: " + role.getClass().getSimpleName()));
        }
        return false;
    }

    private boolean componentProvidesInterface(Interface theInterface, RepositoryComponent component) {
        for (ProvidedRole provRole : component.getProvidedRoles_InterfaceProvidingEntity()) {
            if (!provRole.getId().equals(theInterface.getId())) continue;
            return true;
        }
        return false;
    }

    private void createInterfaceForSupertype(ComponentImplementingClassesLink componentCandidate, Type gastClass, Type rawSuperType) {
        for (Type ownSuperType : this.somoxConfiguration.getBlacklistFilter().filter((Iterable)KDMHelper.getSuperTypes((Type)rawSuperType))) {
            this.createInterfaceForSupertype(componentCandidate, gastClass, ownSuperType);
        }
        Type superType = InterfaceBuilder.unpackParametricType(rawSuperType);
        if (this.interfaceStrategy.isComponentInterface(superType)) {
            logger.debug((Object)("Found interface " + KDMHelper.computeFullQualifiedName((ASTNode)superType) + " for component " + componentCandidate.getComponent().getEntityName()));
            OperationInterface providedInterface = this.createInterface(gastClass, superType);
            if (!this.componentProvidesInterface((Interface)providedInterface, componentCandidate.getComponent())) {
                this.createProvidedPortAndBehaviour(componentCandidate, providedInterface, superType);
            }
        }
    }

    private static Type unpackParametricType(Type inputClass) {
        Type classToCheck = inputClass;
        if (classToCheck instanceof ParameterizedType) {
            classToCheck = ((ParameterizedType)inputClass).getType().getType();
        }
        return classToCheck;
    }

    private void createProvidedPortAndBehaviour(ComponentImplementingClassesLink componentCandidate, OperationInterface providedInterface, Type gastClass) {
        ProvidedRole providedRole = this.createProvidedPort(providedInterface, componentCandidate.getComponent());
        this.updateInterfacesInSourceCodeDecorator(componentCandidate, (Interface)providedInterface, gastClass, true);
        if (!componentCandidate.isCompositeComponent()) {
            this.behaviourBuilder.addSeffsToPrimitiveComponent((BasicComponent)componentCandidate.getComponent(), providedRole);
        }
    }

    private void assignPublicMethodsAsInterfaceForComponentsWithoutInterface(ComponentImplementingClassesLink componentCandidate) {
        logger.debug((Object)"Assigning public methods as interfaces");
        EList gastClasses = componentCandidate.getImplementingClasses();
        if (!gastClasses.isEmpty()) {
            for (Type gastClass : gastClasses) {
                OperationInterface compInterface = this.createInterfaceBasedOnPublicMethods(gastClass);
                if (compInterface != null) {
                    this.createProvidedPortAndBehaviour(componentCandidate, compInterface, gastClass);
                    continue;
                }
                logger.warn((Object)"Failed to create interface by using public methods for class without real interfaces");
            }
        } else {
            logger.warn((Object)("No gast classes found for component: " + componentCandidate.getComponent().getEntityName() + " id: " + componentCandidate.getComponent().getId()));
        }
    }

    private OperationInterface createInterfaceBasedOnPublicMethods(Type gastClass) {
        if (this.interfaceStrategy.isComponentInterface(gastClass)) {
            logger.info((Object)(String.valueOf(KDMHelper.computeFullQualifiedName((ASTNode)gastClass)) + " used as interface but is a pseudo-interface."));
        }
        if (this.alreadyCreatedInterfaces.containsKey(gastClass)) {
            return this.alreadyCreatedInterfaces.get(gastClass);
        }
        OperationInterface compInterface = RepositoryFactory.eINSTANCE.createOperationInterface();
        compInterface.setEntityName(this.naming.createInterfaceNameForClass(gastClass));
        this.operationBuilder.createOperations(gastClass, compInterface);
        this.alreadyCreatedInterfaces.put(gastClass, compInterface);
        this.analysisResult.getInternalArchitectureModel().getInterfaces__Repository().add((Object)compInterface);
        return compInterface;
    }

    private OperationInterface createInterface(Type implementingClass, Type interfaceClass) {
        OperationInterface operationInterface = this.getExistingInterface(interfaceClass);
        if (operationInterface == null) {
            operationInterface = RepositoryFactory.eINSTANCE.createOperationInterface();
            for (TypeAccess inheritanceTypeAccess : KDMHelper.getInheritanceTypeAccesses((Type)interfaceClass)) {
                Type superType = inheritanceTypeAccess.getType();
                if (!this.somoxConfiguration.getBlacklistFilter().passes(superType) || !this.interfaceStrategy.isComponentInterface(superType)) continue;
                OperationInterface parentInterface = this.createInterface(implementingClass, superType);
                operationInterface.getParentInterfaces__Interface().add((Object)parentInterface);
            }
            operationInterface.setEntityName(this.naming.createInterfaceName(interfaceClass));
            this.operationBuilder.createOperations(interfaceClass, operationInterface);
            this.alreadyCreatedInterfaces.put(interfaceClass, operationInterface);
            this.analysisResult.getInternalArchitectureModel().getInterfaces__Repository().add((Object)operationInterface);
        }
        return operationInterface;
    }

    private OperationInterface getExistingInterface(Type gastClass) {
        OperationInterface returnInterface = null;
        if (this.alreadyCreatedInterfaces.containsKey(gastClass)) {
            returnInterface = this.alreadyCreatedInterfaces.get(gastClass);
        }
        return returnInterface;
    }

    private void updateInterfacesInSourceCodeDecorator(ComponentImplementingClassesLink component, Interface interf, Type gastClass, boolean isProvidedInterface) {
        InterfaceSourceCodeLink interfaceLink = SourceCodeDecoratorFactory.eINSTANCE.createInterfaceSourceCodeLink();
        if (gastClass != null) {
            interfaceLink.setGastClass(gastClass);
        }
        interfaceLink.setInterface(interf);
        this.analysisResult.getSourceCodeDecoratorRepository().getInterfaceSourceCodeLink().add((Object)interfaceLink);
        if (isProvidedInterface) {
            component.getProvidedInterfaces().add((Object)interfaceLink);
        } else {
            component.getRequiredInterfaces().add((Object)interfaceLink);
        }
    }

    public void updateRequiredInterfacesOfExistingPrimitiveComponents() {
        boolean addedANewInterface = false;
        for (ComponentImplementingClassesLink compLink : this.analysisResult.getSourceCodeDecoratorRepository().getComponentImplementingClassesLink()) {
            if (compLink.isCompositeComponent()) continue;
            addedANewInterface = this.findAndAddRequiredInterfaces(compLink);
            addedANewInterface = true;
        }
        AssemblyConnectorsInsideCompositeComponentStrategy assemblyConnectorStrategy = new AssemblyConnectorsInsideCompositeComponentStrategy();
        if (addedANewInterface) {
            for (ComponentImplementingClassesLink compLink : this.analysisResult.getSourceCodeDecoratorRepository().getComponentImplementingClassesLink()) {
                if (!compLink.isCompositeComponent()) continue;
                ComposedProvidingRequiringEntity composite = (ComposedProvidingRequiringEntity)compLink.getComponent();
                assemblyConnectorStrategy.buildAssemblyConnectors(composite, (List<ComponentImplementingClassesLink>)compLink.getSubComponents());
            }
        }
    }

    public void reverseEngineerRemainingInterfacesAsFreeFloatingInterfaces(AnalysisResult analysisResult, Root gastModel) {
        analysisResult.getSourceCodeDecoratorRepository();
        for (Type currentClass : gastModel.getNormalClasses()) {
            if (!this.interfaceStrategy.isComponentInterface(currentClass) || this.alreadyCreatedInterfaces.containsKey(currentClass)) continue;
            OperationInterface newInterface = this.createInterface(currentClass, currentClass);
            analysisResult.getInternalArchitectureModel().getInterfaces__Repository().add((Object)newInterface);
            InterfaceSourceCodeLink ifLink = SourceCodeDecoratorFactory.eINSTANCE.createInterfaceSourceCodeLink();
            ifLink.setGastClass(currentClass);
            analysisResult.getSourceCodeDecoratorRepository().getInterfaceSourceCodeLink().add((Object)ifLink);
        }
    }

    public void removeInterfaceSelfAccesses(ComponentImplementingClassesLink primitiveComponent) {
        List<InterfaceSourceCodeInterfacePortTuple> requiredIfToRemove = this.identifyComponentInterfaceSelfAccess(primitiveComponent);
        for (InterfaceSourceCodeInterfacePortTuple currentIfTupleToRemove : requiredIfToRemove) {
            logger.trace((Object)("removing self-access component interface " + currentIfTupleToRemove.interfaceSourceCodeLink.getInterface().getEntityName() + " of component " + primitiveComponent.getComponent().getEntityName()));
            primitiveComponent.getComponent().getRequiredRoles_InterfaceRequiringEntity().remove((Object)currentIfTupleToRemove.role);
            EcoreUtil.delete((EObject)currentIfTupleToRemove.role);
            primitiveComponent.getRequiredInterfaces().remove((Object)currentIfTupleToRemove.interfaceSourceCodeLink);
            EcoreUtil.delete((EObject)currentIfTupleToRemove.interfaceSourceCodeLink);
        }
    }

    private List<InterfaceSourceCodeInterfacePortTuple> identifyComponentInterfaceSelfAccess(ComponentImplementingClassesLink primitiveComponent) {
        ArrayList<InterfaceSourceCodeInterfacePortTuple> requiredIfToRemove = new ArrayList<InterfaceSourceCodeInterfacePortTuple>();
        for (InterfaceSourceCodeLink providedInterfaceLink : primitiveComponent.getProvidedInterfaces()) {
            for (InterfaceSourceCodeLink requiredInterfaceLink : primitiveComponent.getRequiredInterfaces()) {
                if (!providedInterfaceLink.getInterface().equals(requiredInterfaceLink.getInterface())) continue;
                InterfaceSourceCodeInterfacePortTuple ifToRemoveTuple = new InterfaceSourceCodeInterfacePortTuple();
                ifToRemoveTuple.role = InterfacePortBuilderHelper.getInterfacePort(primitiveComponent, requiredInterfaceLink, false);
                ifToRemoveTuple.interfaceSourceCodeLink = requiredInterfaceLink;
                requiredIfToRemove.add(ifToRemoveTuple);
            }
        }
        return requiredIfToRemove;
    }

    private class InterfaceSourceCodeInterfacePortTuple {
        public InterfaceSourceCodeLink interfaceSourceCodeLink;
        public Role role;

        private InterfaceSourceCodeInterfacePortTuple() {
        }
    }
}

